/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *    Jim Sermersheim (Novell)
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.token.self;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IRequestSecurityToken;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Handle RSTs and generate RSTRs as SAML Assertions. 
 * Compatible with www.identityblog.com
 * 
 * @author mikemci at us dot ibm dot com
 */
public class SelfIdentityHandler
	extends org.eclipse.higgins.sts.server.token.handler.TokenHandler
{
	final private org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SelfIdentityHandler.class.getName());
	
	final private javax.xml.namespace.QName qnameIdentityClaimType = new javax.xml.namespace.QName
		(null,
		"ClaimType");
	
	final private javax.xml.namespace.QName qnameIdentityClaimURI = new javax.xml.namespace.QName
		(null,
		"Uri");
	
	final private java.net.URI uriPPI = java.net.URI.create
		("http://schemas.xmlsoap.org/ws/2005/05/identity/claims/privatepersonalidentifier");

    private boolean bConfigured = false;
	
	/**
	 * Protected constructor, must use SelfIdentityHandlerFactory
	 */
	protected SelfIdentityHandler()
	{
		this.log.trace("SelfIdentityHandler::SelfIdentityHandler");
	}
	
    /* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityTokenServiceExtension#configure(java.util.Hashtable)
	 */
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
	{
		this.log.trace("SelfIdentityHandler::configure: " + strComponentName);
		
		this.bConfigured = true;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.ISecurityTokenServiceExtension#invoke
     */
	public void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
	{
		this.log.trace("SelfIdentityHandler::invoke: " + strComponentName);
		
		if (!this.bConfigured)
		{
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Issue handler not configured");
			response.setFault(fault);
			return;		
		}	
		
		final org.eclipse.higgins.sts.api.IDigitalIdentity digitalIdentity = new org.eclipse.higgins.sts.common.DigitalIdentity();

		final java.net.URI uriSubjectNameIdentifierAttribute = (java.net.URI)mapComponentSettings.get
			("SubjectNameIdentifierAttribute");
		this.log.trace("SubjectNameIdentifierAttribute: " + uriSubjectNameIdentifierAttribute.toString());
		digitalIdentity.setSubjectNameIdentifierURI(uriSubjectNameIdentifierAttribute);

		// TODO: Properly namespace qualify LocalNames throughout
		final java.util.List listRST = request.getRequestSecurityTokenCollection();
		final IRequestSecurityToken RST = (IRequestSecurityToken)listRST.get(0);
		// TODO: Deal with collections?
		
		final org.eclipse.higgins.sts.api.IElement elemClaims = RST.getClaims();
		org.apache.axiom.om.OMElement omClaims = null;
		if (null != elemClaims)
		{
			try
			{
				omClaims = (org.apache.axiom.om.OMElement)elemClaims.getAs
					(org.apache.axiom.om.OMElement.class);
			}
			catch (final Exception e)
			{
	    		org.eclipse.higgins.sts.utilities.ExceptionHelper.Log
					(this.log,
					e);
				final Fault fault = new Fault
					(constants.getWSTrustNamespace(),
					"wst",
					constants.getRequestFailedFaultCode(),
					"The specified request failed",
					"Unsupported contained object class.");
				response.setFault(fault);
				return;			
			}
		}		
		
		java.util.Iterator iterClaimTypes = null;
		if (null != omClaims)
		{
			iterClaimTypes = omClaims.getChildrenWithName
				(this.qnameIdentityClaimType);
			while (iterClaimTypes.hasNext())
			{
				final org.apache.axiom.om.OMElement elemClaimType = (org.apache.axiom.om.OMElement)iterClaimTypes.next();
		  		final String strAttributeURI = elemClaimType.getAttributeValue(this.qnameIdentityClaimURI);
		  		final java.net.URI uriAttribute = java.net.URI.create(strAttributeURI);				
				if (this.uriPPI.equals(uriAttribute))
				{
					digitalIdentity.setIncludePPIClaim(true);
					continue;
				}
				this.log.trace("Adding Identity Attribute: " + uriAttribute.toString());	   						

				final org.eclipse.higgins.sts.api.IClaimType claimType = new org.eclipse.higgins.sts.common.ClaimType();
	   			claimType.setName(uriAttribute);
	   			final org.eclipse.higgins.sts.api.IClaim claim = new org.eclipse.higgins.sts.common.Claim();
	   			claim.setType(claimType);
	   			final String strValue = elemClaimType.getText();
		   		this.log.trace("Adding Claim Value: " + strValue);	   			  					
		   		claim.addValue(strValue);			  		
		   		digitalIdentity.addClaim(claim);
	   		}
	   		this.log.trace("Calling setDigitalIdentity");
	   		RST.setDigitalIdentity
	   			(digitalIdentity);
   		}
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}