/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.trust;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.spi.IExtensionMapper;
import org.eclipse.higgins.sts.spi.ITokenExtension;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class SecurityTokenService
implements ISecurityTokenService {
    private final LogHelper log;
    private boolean bInitialized;
    static /* synthetic */ Class class$0;

    protected SecurityTokenService() throws Exception {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.server.trust.SecurityTokenService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = new LogHelper(clazz.getName());
        this.bInitialized = false;
        this.log.trace((Object)"SecurityTokenService::SecurityTokenService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
        this.log.trace((Object)"SecurityTokenService::configure");
        this.bInitialized = false;
        String strSecurityTokenServiceName = strComponentName;
        if (strSecurityTokenServiceName == null) {
            strSecurityTokenServiceName = "SecurityTokenService";
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        Map mapSecurityTokenServiceSettings = mapComponentSettings;
        if (mapSecurityTokenServiceSettings == null) {
            mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get(strSecurityTokenServiceName);
        }
        this.bInitialized = true;
        this.log.trace((Object)"SecurityTokenService::initialize DONE");
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        String strExtensionConfiguration;
        Hashtable mapThisInvocationSettings;
        this.log.trace((Object)"SecurityTokenService::invoke (server)");
        if (!this.bInitialized) {
            this.log.error((Object)"Not Initialized (server)");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Not initialized.");
            response.setFault((IFault)fault);
            return;
        }
        String strSecurityTokenServiceName = strComponentName;
        if (strSecurityTokenServiceName == null) {
            strSecurityTokenServiceName = "SecurityTokenService";
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        Map mapSecurityTokenServiceSettings = mapComponentSettings;
        if (mapSecurityTokenServiceSettings == null) {
            mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get(strSecurityTokenServiceName);
        }
        if ((mapThisInvocationSettings = mapInvocationSettings) == null) {
            mapThisInvocationSettings = new Hashtable();
        }
        if ((strExtensionConfiguration = this.getHandlerConfiguration(mapGlobalSettings, strSecurityTokenServiceName, mapSecurityTokenServiceSettings, mapThisInvocationSettings, constants, request)) == null) {
            this.log.error((Object)MsgHelper.getString((String)"no_extension_configuration_found"));
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "No Configuration Found.");
            response.setFault((IFault)fault);
            return;
        }
        this.log.trace((Object)("Invoking Extension: " + strExtensionConfiguration));
        ITokenExtension tokenExtension = (ITokenExtension)mapGlobalSettings.get(strExtensionConfiguration);
        if (tokenExtension != null) {
            Map mapTokenExtensionSettings = (Map)mapComponentsSettings.get(strExtensionConfiguration);
            tokenExtension.invoke(mapGlobalSettings, strExtensionConfiguration, mapTokenExtensionSettings, mapThisInvocationSettings, constants, request, response);
        } else {
            this.log.error((Object)"No TokenExtension Configured for this Request.");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "No Extension for Configuration.");
            response.setFault((IFault)fault);
        }
    }

    public String getHandlerConfiguration(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request) {
        this.log.trace((Object)"SecurityTokenService::getHandlerConfiguration");
        if (!this.bInitialized) {
            this.log.error((Object)"Not Initialized");
            return null;
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        List listExtensionMappers = (List)mapComponentSettings.get("ExtensionMapperList");
        int i = 0;
        while (i < listExtensionMappers.size()) {
            String strExtensionMapperName = (String)listExtensionMappers.get(i);
            Map mapExtensionMapperSettings = (Map)mapComponentsSettings.get(strExtensionMapperName);
            IExtensionMapper mapper = (IExtensionMapper)mapGlobalSettings.get(strExtensionMapperName);
            String strHandlerConfiguration = mapper.getConfiguration(mapGlobalSettings, strExtensionMapperName, mapExtensionMapperSettings, mapInvocationSettings, constants, request);
            if (strHandlerConfiguration != null) {
                return strHandlerConfiguration;
            }
            ++i;
        }
        return null;
    }
}

