/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.server.trust;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.higgins.messages.utilities.MsgHelper;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IFault;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.api.ISecurityTokenService;
import org.eclipse.higgins.sts.common.Fault;
import org.eclipse.higgins.sts.spi.IExtensionMapper;
import org.eclipse.higgins.sts.spi.ITokenExtension;
import org.eclipse.higgins.sts.utilities.LogHelper;

public class SecurityTokenService
implements ISecurityTokenService {
    private final LogHelper log = new LogHelper((class$org$eclipse$higgins$sts$server$trust$SecurityTokenService == null ? (class$org$eclipse$higgins$sts$server$trust$SecurityTokenService = SecurityTokenService.class$("org.eclipse.higgins.sts.server.trust.SecurityTokenService")) : class$org$eclipse$higgins$sts$server$trust$SecurityTokenService).getName());
    private boolean bInitialized = false;
    static /* synthetic */ Class class$org$eclipse$higgins$sts$server$trust$SecurityTokenService;

    protected SecurityTokenService() throws Exception {
        this.log.trace((Object)"SecurityTokenService::SecurityTokenService");
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) throws Exception {
        this.log.trace((Object)"SecurityTokenService::configure");
        this.bInitialized = false;
        String strSecurityTokenServiceName = strComponentName;
        if (null == strSecurityTokenServiceName) {
            strSecurityTokenServiceName = "SecurityTokenService";
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        Map mapSecurityTokenServiceSettings = mapComponentSettings;
        if (null == mapSecurityTokenServiceSettings) {
            mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get(strSecurityTokenServiceName);
        }
        this.bInitialized = true;
        this.log.trace((Object)"SecurityTokenService::initialize DONE");
    }

    public void invoke(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request, ISTSResponse response) {
        String strExtensionConfiguration;
        Hashtable mapThisInvocationSettings;
        this.log.trace((Object)"SecurityTokenService::invoke (server)");
        if (!this.bInitialized) {
            this.log.error((Object)"Not Initialized (server)");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "Not initialized.");
            response.setFault((IFault)fault);
            return;
        }
        String strSecurityTokenServiceName = strComponentName;
        if (null == strSecurityTokenServiceName) {
            strSecurityTokenServiceName = "SecurityTokenService";
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        Map mapSecurityTokenServiceSettings = mapComponentSettings;
        if (null == mapSecurityTokenServiceSettings) {
            mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get(strSecurityTokenServiceName);
        }
        if (null == (mapThisInvocationSettings = mapInvocationSettings)) {
            mapThisInvocationSettings = new Hashtable();
        }
        if (null == (strExtensionConfiguration = this.getHandlerConfiguration(mapGlobalSettings, strSecurityTokenServiceName, mapSecurityTokenServiceSettings, mapThisInvocationSettings, constants, request))) {
            this.log.error((Object)MsgHelper.getString((String)"no_extension_configuration_found"));
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "No Configuration Found.");
            response.setFault((IFault)fault);
            return;
        }
        this.log.trace((Object)("Invoking Extension: " + strExtensionConfiguration));
        ITokenExtension tokenExtension = (ITokenExtension)mapGlobalSettings.get(strExtensionConfiguration);
        if (null != tokenExtension) {
            Map mapTokenExtensionSettings = (Map)mapComponentsSettings.get(strExtensionConfiguration);
            tokenExtension.invoke(mapGlobalSettings, strExtensionConfiguration, mapTokenExtensionSettings, mapThisInvocationSettings, constants, request, response);
        } else {
            this.log.error((Object)"No TokenExtension Configured for this Request.");
            Fault fault = new Fault(constants.getWSTrustNamespace(), "wst", constants.getRequestFailedFaultCode(), "The specified request failed", "No Extension for Configuration.");
            response.setFault((IFault)fault);
        }
    }

    public String getHandlerConfiguration(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings, Map mapInvocationSettings, IConstants constants, ISTSRequest request) {
        this.log.trace((Object)"SecurityTokenService::getHandlerConfiguration");
        if (!this.bInitialized) {
            this.log.error((Object)"Not Initialized");
            return null;
        }
        Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
        List listExtensionMappers = (List)mapComponentSettings.get("ExtensionMapperList");
        for (int i = 0; i < listExtensionMappers.size(); ++i) {
            String strExtensionMapperName = (String)listExtensionMappers.get(i);
            Map mapExtensionMapperSettings = (Map)mapComponentsSettings.get(strExtensionMapperName);
            IExtensionMapper mapper = (IExtensionMapper)mapGlobalSettings.get(strExtensionMapperName);
            String strHandlerConfiguration = mapper.getConfiguration(mapGlobalSettings, strExtensionMapperName, mapExtensionMapperSettings, mapInvocationSettings, constants, request);
            if (null == strHandlerConfiguration) continue;
            return strHandlerConfiguration;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

