/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.server.trust;

import java.util.Map;

import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;
import org.eclipse.higgins.sts.common.Fault;

/**
 * Implements the Higgins Security Token Service.
 * 
 * @author mikemci at us dot ibm dot com
 */
// TODO: Implement some form of Java Authorization
// TODO: Implement * AppliesTo

public class SecurityTokenService
	implements org.eclipse.higgins.sts.api.ISecurityTokenService
{
	private final org.eclipse.higgins.sts.utilities.LogHelper log = new org.eclipse.higgins.sts.utilities.LogHelper
		(SecurityTokenService.class.getName());

	/**
	 * Indicates whether Initialize was called successfully.
	 */
	private boolean bInitialized = false;
	
	/**
	 *  Creates and initializes the Class. 
	 */
	protected SecurityTokenService()
		throws Exception
	{
		this.log.trace("SecurityTokenService::SecurityTokenService");
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.higgins.sts.server.ISecurityTokenService#configure(java.util.Map, java.util.Map, java.util.Map, java.util.Map)
	 */ 
	public void configure
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings,
		final ISettingDescriptor componentDescriptor,
		final ISettingDescriptor globalDescriptor)
		throws Exception
	{
		this.log.trace("SecurityTokenService::configure");

		// TODO: Lock / Sequentialize
		this.bInitialized = false;
		
		String strSecurityTokenServiceName = strComponentName;
		if (null == strSecurityTokenServiceName)
		{
			strSecurityTokenServiceName = "SecurityTokenService";
		}

		final Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
		Map mapSecurityTokenServiceSettings = mapComponentSettings;
		if (null == mapSecurityTokenServiceSettings)
		{
			mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get
				(strSecurityTokenServiceName);
		}

		this.bInitialized = true;
		
		this.log.trace("SecurityTokenService::initialize DONE");
	}
	
	/**
	 *  Called by the framework wheneven an RST is received. Dispatches the request to the appropriate Extension.
	 */
	public void invoke
		(final Map mapGlobalSettings,
		final String strComponentName,
		final Map mapComponentSettings,
		final Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response)
    {
		this.log.trace("SecurityTokenService::invoke (server)");

		if (!this.bInitialized)
		{
			this.log.error("Not Initialized (server)");
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"Not initialized.");
			response.setFault(fault);			
			return;
		}
		
		String strSecurityTokenServiceName = strComponentName;
		if (null == strSecurityTokenServiceName)
		{
			strSecurityTokenServiceName = "SecurityTokenService";
		}

		final Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
		Map mapSecurityTokenServiceSettings = mapComponentSettings;
		if (null == mapSecurityTokenServiceSettings)
		{
			mapSecurityTokenServiceSettings = (Map)mapComponentsSettings.get
				(strSecurityTokenServiceName);
		}
		
		Map mapThisInvocationSettings = mapInvocationSettings;
		if (null == mapThisInvocationSettings)
		{
			mapThisInvocationSettings = new java.util.Hashtable();
		}
		
		final String strExtensionConfiguration = this.getHandlerConfiguration
			(mapGlobalSettings,
			strSecurityTokenServiceName,
			mapSecurityTokenServiceSettings,
			mapThisInvocationSettings,
			constants,
			request);
		if (null == strExtensionConfiguration)
		{
			this.log.error
				(org.eclipse.higgins.messages.utilities.MsgHelper.getString
					(org.eclipse.higgins.messages.utilities.MsgHelper.no_extension_configuration_found));
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"No Configuration Found.");			
			response.setFault(fault);			
			return;
		}
		
		this.log.trace("Invoking Extension: " + strExtensionConfiguration);
		final org.eclipse.higgins.sts.spi.ITokenExtension tokenExtension = (org.eclipse.higgins.sts.spi.ITokenExtension)mapGlobalSettings.get
			(strExtensionConfiguration);
		if (null != tokenExtension)
		{	
			final Map mapTokenExtensionSettings = (Map)mapComponentsSettings.get
				(strExtensionConfiguration);
			
			tokenExtension.invoke
				(mapGlobalSettings,
				strExtensionConfiguration,
				mapTokenExtensionSettings,
				mapThisInvocationSettings,
				constants,
				request,
				response);
		}
		else
		{
			this.log.error("No TokenExtension Configured for this Request.");
			final Fault fault = new Fault
				(constants.getWSTrustNamespace(),
				"wst",
				constants.getRequestFailedFaultCode(),
				"The specified request failed",
				"No Extension for Configuration.");			
			response.setFault(fault);			
		}
	}
	
	public String getHandlerConfiguration
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request)
	{
		this.log.trace("SecurityTokenService::getHandlerConfiguration");

		if (!this.bInitialized)
		{
			this.log.error("Not Initialized");
			return null;
		}
		
		final Map mapComponentsSettings = (Map)mapGlobalSettings.get("ComponentSettings");
		final java.util.List listExtensionMappers = (java.util.List)mapComponentSettings.get
			("ExtensionMapperList");
		
		for (int i = 0; i < listExtensionMappers.size(); ++i)
		{
			final String strExtensionMapperName = (String)listExtensionMappers.get(i);

			final Map mapExtensionMapperSettings = (Map)mapComponentsSettings.get(strExtensionMapperName);
			final org.eclipse.higgins.sts.spi.IExtensionMapper mapper = (org.eclipse.higgins.sts.spi.IExtensionMapper)mapGlobalSettings.get
				(strExtensionMapperName);
			final String strHandlerConfiguration = mapper.getConfiguration
				(mapGlobalSettings,
				strExtensionMapperName,
				mapExtensionMapperSettings,
				mapInvocationSettings,
				constants,
				request);
			if (null != strHandlerConfiguration)
			{
				return strHandlerConfiguration;
			}
		}
		return null;
	}
	
	public ISettingDescriptor getComponentDescriptor() {
		return null;
	}
}
