/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/

package org.eclipse.higgins.sts.spi;

import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.ISTSRequest;
import org.eclipse.higgins.sts.api.ISTSResponse;

/**
 * Interface representing the plug-point for Extensions
 * 
 * @author mikemci at us dot ibm dot com
 */
public interface ITokenExtension
	extends org.eclipse.higgins.configuration.api.IConfigurableComponent
{
	/**
	 * Called for each received RST, generates a set of RSTRs.
	 * 
	 * @param request an ISTSRequest containing values from the RequestSecurityToken
	 * @param response an ISTSResponse containing values to be placed into the RequestSecurityTokenResponse
	 * @param constants an IConstants containing the URIs appropriate for the request and response
	 */
    public abstract void invoke
		(final java.util.Map mapGlobalSettings,
		final String strComponentName,
		final java.util.Map mapComponentSettings,
		final java.util.Map mapInvocationSettings,
		final IConstants constants,
		final ISTSRequest request,
		final ISTSResponse response);
 
    /**
     * Called by the framework when a request is received to determine which extension should process the request.
     * 
	 * @param request an ISTSRequest containing values from the RequestSecurityToken
     * @param constants  an IConstants containing the URIs appropriate for the request
     * @return true if the extension can handle the request, otherwise false.
     */
    public abstract boolean canHandle
		(java.util.Map mapGlobalSettings,
		String strComponentName,
		java.util.Map mapComponentSettings,
		java.util.Map mapInvocationSettings,
		IConstants constants,
		ISTSRequest request);
}