/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.spi;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.eclipse.higgins.sts.api.IConstants;

/**
 * @author mikemci
 *
 */
public interface IXMLSecurityExtension extends org.eclipse.higgins.configuration.api.IConfigurableComponent
{	
	public abstract String SHA1Digest
		(final byte [] byteData) throws Exception;
	
	public abstract org.eclipse.higgins.sts.api.IElement SignDetached
		(final String [] strElementIdsToSign,
		final org.eclipse.higgins.sts.api.IElement elemParent,
		final java.security.PrivateKey privateKey,
		final java.security.PublicKey publicKey,
		final String strIDOfToken,	
		final org.eclipse.higgins.sts.api.IConstants constants)
		throws Exception;

	public abstract org.eclipse.higgins.sts.api.IElement SignEnveloped
		(final String strTagNameOfElementsToSign,
		final org.eclipse.higgins.sts.api.IElement elemParent,
		final String strReferenceIdentifier,
		final java.security.PrivateKey privateKey,
		final java.security.PublicKey publicKey,		
		final org.eclipse.higgins.sts.api.IConstants constants)
		throws Exception;
	
	public org.eclipse.higgins.sts.api.IElement SignEnveloping
		(final org.eclipse.higgins.sts.api.IElement elemObject,
		final String strObjectId,
		final X509Certificate x509Certificate,
		final PrivateKey privateKey) throws Exception;
	
	public abstract boolean VerifyEnveloped
		(final org.eclipse.higgins.sts.api.IElement elemSignedElement,
		final IConstants constants)
		throws Exception;

	public abstract org.eclipse.higgins.sts.api.IElement EncryptElement
		(final String strTagNameOfElementToEncrypt,
		final org.eclipse.higgins.sts.api.IElement elemParent,
		final String strCertificate)
		throws Exception;
	
	public abstract org.eclipse.higgins.sts.api.IElement DecryptElement
		(final org.eclipse.higgins.sts.api.IElement elemEncryptedData,
		final java.security.PrivateKey privateKey)
		throws Exception;
}
