/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.sts.xmlsecurity.apache;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.eclipse.higgins.sts.api.IConstants;
import org.eclipse.higgins.sts.api.IElement;
import org.eclipse.higgins.sts.common.Element;
import org.eclipse.higgins.sts.spi.IXMLSecurityExtension;
import org.eclipse.higgins.sts.utilities.LogHelper;
import org.eclipse.higgins.sts.utilities.XMLHelper;
import org.eclipse.higgins.sts.xmlsecurity.apache.IDResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSecurityApacheExtension
implements IXMLSecurityExtension {
    private static final LogHelper log;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.sts.xmlsecurity.apache.XMLSecurityApacheExtension");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new LogHelper(clazz.getName());
    }

    public IElement SignEnveloping(IElement elemObject, String strObjectId, X509Certificate x509Certificate, PrivateKey privateKey) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document docSignedManagedCard = documentBuilder.newDocument();
        XMLSignature xmlSignature = new XMLSignature(docSignedManagedCard, "", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        docSignedManagedCard.appendChild(xmlSignature.getElement());
        ObjectContainer objectContainer = new ObjectContainer(docSignedManagedCard);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        org.w3c.dom.Element domObject = (org.w3c.dom.Element)elemObject.getAs((Class)clazz);
        objectContainer.appendChild(docSignedManagedCard.importNode(domObject, true));
        objectContainer.setId(strObjectId);
        xmlSignature.appendObject(objectContainer);
        Transforms transforms = new Transforms(docSignedManagedCard);
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        xmlSignature.addDocument("#" + strObjectId, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        xmlSignature.addKeyInfo(x509Certificate);
        xmlSignature.sign((Key)privateKey);
        Element elemResult = new Element();
        elemResult.set((Object)XMLHelper.reparseElement((org.w3c.dom.Element)xmlSignature.getElement()));
        return elemResult;
    }

    public String SHA1Digest(byte[] byteData) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.reset();
        byte[] byteDigest = md.digest(byteData);
        return Base64.encode((byte[])byteDigest);
    }

    public IElement DecryptElement(IElement elemEncryptedData, PrivateKey privateKey) throws Exception {
        org.w3c.dom.Element domEncryptedData;
        NodeList nlEncryptedKey;
        log.trace((Object)"DecryptElement");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((nlEncryptedKey = (domEncryptedData = (org.w3c.dom.Element)elemEncryptedData.getAs((Class)clazz)).getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey")) == null) {
            log.trace((Object)"No EncryptedKey found (getElementsByTagName returned null)");
        } else if (nlEncryptedKey.getLength() == 0) {
            log.trace((Object)"No EncryptedKey found (0 == getLength())");
        } else {
            log.trace((Object)"Processing EncryptedKey element in EncryptedData");
            Document domDocument = domEncryptedData.getOwnerDocument();
            org.w3c.dom.Element elemEncryptedKey = (org.w3c.dom.Element)nlEncryptedKey.item(0);
            log.trace((Object)"Before XMLCipher::getProviderInstance(RSA_OAEP)");
            XMLCipher keyCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            log.trace((Object)"Before XMLCipher::init(UNWRAP_MODE)");
            keyCipher.init(4, (Key)privateKey);
            log.trace((Object)"Before XMLCipher::loadEncryptedKey");
            EncryptedKey encryptedKey = keyCipher.loadEncryptedKey(domDocument, elemEncryptedKey);
            log.trace((Object)"Before XMLCipher::decryptKey");
            Key keySecret = keyCipher.decryptKey(encryptedKey, "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
            SecretKey secretKey = (SecretKey)keySecret;
            byte[] encodedSecretKey = secretKey.getEncoded();
            SecretKeySpec secretKeySpec = new SecretKeySpec(encodedSecretKey, "AES");
            log.trace((Object)"Before XMLCipher::getProviderInstance(AES_256)");
            XMLCipher xmlCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            log.trace((Object)"Before XMLCipher::init(DECRYPT_MODE)");
            xmlCipher.init(2, (Key)secretKeySpec);
            log.trace((Object)"Before XMLCipher::doFinal");
            Document domResultDocument = xmlCipher.doFinal(domDocument, domEncryptedData, false);
            Element elemResult = new Element();
            elemResult.set((Object)domResultDocument.getDocumentElement());
            StringBuffer stringBuffer = new StringBuffer("Decrypted Element: ");
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            log.trace((Object)stringBuffer.append((String)elemResult.getAs((Class)clazz2)).toString());
            return elemResult;
        }
        return null;
    }

    public IElement EncryptElement(String strTagNameOfElementToEncrypt, IElement elemParent, String strCertificate) throws Exception {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        org.w3c.dom.Element domParent = (org.w3c.dom.Element)elemParent.getAs((Class)clazz);
        Document domDocument = domParent.getOwnerDocument();
        NodeList nlToEncrypts = domParent.getElementsByTagName(strTagNameOfElementToEncrypt);
        if (nlToEncrypts == null) {
            String string = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null";
            log.error((Object)"org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
            return null;
        }
        if (1 != nlToEncrypts.getLength()) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned " + nlToEncrypts.getLength() + " nodes";
            log.error((Object)strErrorMessage);
            return null;
        }
        org.w3c.dom.Element domToEncrypt = (org.w3c.dom.Element)nlToEncrypts.item(0);
        org.w3c.dom.Element domTempParent = domDocument.createElement("Parent");
        org.w3c.dom.Element domTempToEncrypt = (org.w3c.dom.Element)domTempParent.appendChild(domToEncrypt.cloneNode(true));
        String strEncryptionCertificate = "-----BEGIN CERTIFICATE-----\n" + strCertificate + "\n-----END CERTIFICATE-----\n";
        ByteArrayInputStream streamCertificate = new ByteArrayInputStream(strEncryptionCertificate.getBytes());
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(streamCertificate);
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(256);
        SecretKey secretKey = keyGenerator.generateKey();
        PublicKey publicKeyRP = certificate.getPublicKey();
        XMLCipher keyCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        keyCipher.init(3, (Key)publicKeyRP);
        KeyInfo keyInfoKey = new KeyInfo(domDocument);
        MessageDigest mdSha1 = MessageDigest.getInstance("SHA-1");
        byte[] byteThumbPrint = mdSha1.digest(certificate.getEncoded());
        Document domParentDocument = domParent.getOwnerDocument();
        org.w3c.dom.Element domSTR = domParentDocument.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference");
        org.w3c.dom.Element domKeyIdentifier = domParentDocument.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
        domKeyIdentifier.setAttribute("ValueType", "http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#ThumbprintSHA1");
        domKeyIdentifier.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        String strThumbprint = Base64.encode((byte[])byteThumbPrint);
        log.trace((Object)("Cert: " + certificate.getSubjectDN().getName()));
        log.trace((Object)("Thumbprint: " + strThumbprint));
        XMLHelper.setTextContent((org.w3c.dom.Element)domKeyIdentifier, (String)strThumbprint);
        domSTR.appendChild(domKeyIdentifier);
        keyInfoKey.addUnknownElement(domSTR);
        EncryptedKey encryptedKey = keyCipher.encryptKey(domDocument, (Key)secretKey);
        encryptedKey.setKeyInfo(keyInfoKey);
        EncryptionMethod encryptionMethod = encryptedKey.getEncryptionMethod();
        org.w3c.dom.Element elemDigestMethod = domDocument.createElementNS("http://www.w3.org/2000/09/xmldsig#", "DigestMethod");
        elemDigestMethod.setAttribute("Algorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        encryptionMethod.addEncryptionMethodInformation(elemDigestMethod);
        XMLCipher xmlCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        xmlCipher.init(1, (Key)secretKey);
        EncryptedData encryptedData = xmlCipher.getEncryptedData();
        KeyInfo keyInfoEncryption = new KeyInfo(domDocument);
        keyInfoEncryption.add(encryptedKey);
        encryptedData.setKeyInfo(keyInfoEncryption);
        xmlCipher.doFinal(domDocument, domTempToEncrypt, false);
        NodeList nlEncryptedData = domTempParent.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedData");
        if (1 != nlEncryptedData.getLength()) {
            throw new Exception("One EncryptedData Not Found!");
        }
        org.w3c.dom.Element domEncryptedData = (org.w3c.dom.Element)nlEncryptedData.item(0);
        XMLHelper.stripNewLinesFromElement((org.w3c.dom.Element)((org.w3c.dom.Element)nlEncryptedData.item(0)));
        domParent.replaceChild(domEncryptedData, domToEncrypt);
        Element elemResult = new Element();
        elemResult.set((Object)domParent);
        return elemResult;
    }

    public IElement SignEnveloped(String strTagNameOfElementsToSign, IElement elemParent, String strReferenceIdentifier, PrivateKey privateKey, PublicKey publicKey, IConstants constants) throws Exception {
        if (strTagNameOfElementsToSign == null) {
            throw new Exception("Sign Failed: Invalid Parameter: TagNameOfElementsToSign is null");
        }
        if (elemParent == null) {
            throw new Exception("Sign Failed: Invalid Parameter: Parent is null");
        }
        if (strReferenceIdentifier == null) {
            throw new Exception("Sign Failed: Invalid Parameter: ReferenceIdentifier is null");
        }
        if (privateKey == null) {
            throw new Exception("Sign Failed: Invalid Parameter: PrivateKey is null");
        }
        if (publicKey == null) {
            throw new Exception("Sign Failed: Invalid Parameter: PublicKey is null");
        }
        if (constants == null) {
            throw new Exception("Sign Failed: Invalid Parameter: Constants is null");
        }
        Constants.setSignatureSpecNSprefix((String)"ds");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        org.w3c.dom.Element domParent = (org.w3c.dom.Element)elemParent.getAs((Class)clazz);
        domParent = XMLHelper.reparseElement((org.w3c.dom.Element)domParent);
        Document domDocument = domParent.getOwnerDocument();
        NodeList nlToSigns = domParent.getElementsByTagName(strTagNameOfElementsToSign);
        if (nlToSigns == null) {
            String string = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null";
            log.error((Object)"org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
            throw new Exception("Sign Failed: org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned null");
        }
        if (1 != nlToSigns.getLength()) {
            String strErrorMessage = "org.w3c.dom.Element.getElementsByTagNameNS unexpectedly returned " + nlToSigns.getLength() + " nodes";
            log.error((Object)strErrorMessage);
            throw new Exception("Sign Failed: " + strErrorMessage);
        }
        org.w3c.dom.Element domToSign = (org.w3c.dom.Element)nlToSigns.item(0);
        XMLSignature signature = new XMLSignature(domDocument, "", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2001/10/xml-exc-c14n#");
        domToSign.appendChild(signature.getElement());
        SignedInfo signedInfo = signature.getSignedInfo();
        IDResolver resolver = new IDResolver(domToSign);
        signedInfo.addResourceResolver((ResourceResolverSpi)resolver);
        Transforms transforms = new Transforms(domDocument);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        signature.addDocument("#" + strReferenceIdentifier, transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        signature.addKeyInfo(publicKey);
        signature.sign((Key)privateKey);
        org.w3c.dom.Element elemSignature = signature.getElement();
        NodeList nodeListSignatureValue = elemSignature.getElementsByTagNameNS(constants.getXMLSignatureNamespace().toString(), "SignatureValue");
        org.w3c.dom.Element elemSignatureValue = (org.w3c.dom.Element)nodeListSignatureValue.item(0);
        XMLHelper.stripWhiteSpaceFromElement((org.w3c.dom.Element)elemSignatureValue);
        domParent = XMLHelper.reparseElement((org.w3c.dom.Element)domParent);
        Element elemResult = new Element();
        elemResult.set((Object)domParent);
        return elemResult;
    }

    public boolean VerifyEnveloped(IElement elemSignedElement, IConstants constants) throws Exception {
        if (elemSignedElement == null) {
            throw new Exception("Verify Failed: Invalid Parameter: SignedElement is null");
        }
        if (constants == null) {
            throw new Exception("Verify Failed: Invalid Parameter: Constants is null");
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.w3c.dom.Element");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        org.w3c.dom.Element domSignedElement = (org.w3c.dom.Element)elemSignedElement.getAs((Class)clazz);
        Document domParent = domSignedElement.getOwnerDocument();
        org.w3c.dom.Element elemContext = XMLUtils.createDSctx(domParent, "ds", "http://www.w3.org/2000/09/xmldsig#");
        org.w3c.dom.Element elemSignature = (org.w3c.dom.Element)XPathAPI.selectSingleNode((Node)domParent, (String)"//ds:Signature[1]", (Node)elemContext);
        XMLSignature signature = new XMLSignature(elemSignature, domParent.getBaseURI());
        signature.addResourceResolver((ResourceResolverSpi)new IDResolver(domSignedElement));
        KeyInfo keyInfo = signature.getKeyInfo();
        boolean bResult = false;
        if (keyInfo != null) {
            X509Certificate cert;
            if (keyInfo.containsX509Data()) {
                System.out.println("Found a X509Data element in the KeyInfo");
            }
            if ((cert = signature.getKeyInfo().getX509Certificate()) != null) {
                bResult = signature.checkSignatureValue(cert);
            } else {
                System.out.println("Did not find an X509Data element in the KeyInfo");
                PublicKey publicKey = keyInfo.getPublicKey();
                if (publicKey != null) {
                    bResult = signature.checkSignatureValue((Key)publicKey);
                } else {
                    System.out.println("Did not find a public key, so I can't check the signature");
                }
            }
        } else {
            System.out.println("Did not find a KeyInfo");
        }
        return bResult;
    }

    public void configure(Map mapGlobalSettings, String strComponentName, Map mapComponentSettings) {
        Init.init();
    }
}

