/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Michael McIntosh (IBM Corporation) - initial API and implementation
 *******************************************************************************/ 

package org.eclipse.higgins.sts.xmlsecurity.apache;

/**
 * Used to access the SAML Assertion during signature processing
 * 
 * @author mikemci at us dot ibm dot com
 */
//TODO: Finish commenting this class
//TODO: Finish implementing this class
public class IDResolver
	extends org.apache.xml.security.utils.resolver.ResourceResolverSpi
{
	private org.w3c.dom.Document domDocument = null;
	
	public IDResolver(final org.w3c.dom.Document domDocument)
	{
		this.domDocument = domDocument;
	}
	
	public org.apache.xml.security.signature.XMLSignatureInput engineResolve
		(final org.w3c.dom.Attr uri,
		final String BaseURI)
		throws org.apache.xml.security.utils.resolver.ResourceResolverException
	{
		String strReference = uri.getValue();
		if (strReference.equals(""))
			return new org.apache.xml.security.signature.XMLSignatureInput
	    		(domDocument);
		// Get all the nodes
		org.w3c.dom.NodeList nl = domDocument.getElementsByTagName("*");
		if (nl == null)
			return null;
		org.w3c.dom.Element domResult = null;

		// look through the elements for attributes of the right type
		for (int i = 0; i < nl.getLength(); i++)
		{
			org.w3c.dom.Element domCandidate = (org.w3c.dom.Element) nl.item(i);
			org.w3c.dom.Attr attr = domCandidate.getAttributeNodeNS
				("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd",
				"Id");
			if (attr == null)
			{
				attr = domCandidate.getAttributeNode
					("Id");
				if (attr == null)
				{
					attr = domCandidate.getAttributeNode
						("ID");
					if (attr == null)
					{
						attr = domCandidate.getAttributeNode
							("AssertionID");
						if (attr == null)
						{
							continue;
						}
					}
				}
			}
			String strCandidateID = "#" + attr.getValue();
			if (strCandidateID.equals(strReference))
			{
				domResult = domCandidate;
				break;
			}
		}
	    return new org.apache.xml.security.signature.XMLSignatureInput
	    	(domResult);
	}

	public boolean engineCanResolve
	   	(final org.w3c.dom.Attr uri,
	   	final String BaseURI)
	{
		if (null != uri)
		{
			final String uriNodeValue = uri.getNodeValue();
			if (uriNodeValue.startsWith("#"))
				return true;
		}
		return false;
	}
}
