/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    static String dsPrefix = null;
    static String xmlnsDsPrefix = null;
    static Map namePrefixes = new HashMap();

    private XMLUtils() {
    }

    public static Element getNextElement(Node el) {
        while (el != null && el.getNodeType() != 1) {
            el = el.getNextSibling();
        }
        return (Element)el;
    }

    public static void getSet(Node rootNode, Set result, Node exclude, boolean com) {
        if (exclude != null && XMLUtils.isDescendantOrSelf(exclude, rootNode)) {
            return;
        }
        XMLUtils.getSetRec(rootNode, result, exclude, com);
    }

    static final void getSetRec(Node rootNode, Set result, Node exclude, boolean com) {
        if (rootNode == exclude) {
            return;
        }
        switch (rootNode.getNodeType()) {
            case 1: {
                result.add(rootNode);
                Element el = (Element)rootNode;
                if (el.hasAttributes()) {
                    NamedNodeMap nl = ((Element)rootNode).getAttributes();
                    int i = 0;
                    while (i < nl.getLength()) {
                        result.add(nl.item(i));
                        ++i;
                    }
                }
            }
            case 9: {
                Node r = rootNode.getFirstChild();
                while (r != null) {
                    if (r.getNodeType() == 3) {
                        result.add(r);
                        while (r != null && r.getNodeType() == 3) {
                            r = r.getNextSibling();
                        }
                        if (r == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec(r, result, exclude, com);
                    r = r.getNextSibling();
                }
                return;
            }
            case 8: {
                if (com) {
                    result.add(rootNode);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        result.add(rootNode);
    }

    public static void outputDOM(Node contextNode, OutputStream os) {
        XMLUtils.outputDOM(contextNode, os, false);
    }

    public static void outputDOM(Node contextNode, OutputStream os, boolean addPreamble) {
        try {
            if (addPreamble) {
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes("UTF-8"));
            }
            os.write(Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException ex) {
            ex.printStackTrace();
        }
        catch (CanonicalizationException ex) {
            ex.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node contextNode, OutputStream os) {
        try {
            os.write(Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException iOException) {
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
        }
        catch (CanonicalizationException canonicalizationException) {}
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        int i = 0;
        while (i < iMax) {
            Node curr = children.item(i);
            if (curr.getNodeType() == 3) {
                sb.append(((Text)curr).getData());
            }
            ++i;
        }
        return sb.toString();
    }

    public static Element createElementInSignatureSpace(Document doc, String elementName) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        if (dsPrefix == null || dsPrefix.length() == 0) {
            Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", elementName);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        String namePrefix = (String)namePrefixes.get(elementName);
        if (namePrefix == null) {
            StringBuffer tag = new StringBuffer(dsPrefix);
            tag.append(':');
            tag.append(elementName);
            namePrefix = tag.toString();
            namePrefixes.put(elementName, namePrefix);
        }
        Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", namePrefix);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", xmlnsDsPrefix, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String localName) {
        if (element == null || "http://www.w3.org/2000/09/xmldsig#" != element.getNamespaceURI()) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String localName) {
        if (element == null || "http://www.w3.org/2001/04/xmlenc#" != element.getNamespaceURI()) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(String.valueOf(I18n.translate((String)"endorsed.jdk1.4.0")) + " Original message was \"" + npe.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set xpathNodeSet) {
        NullPointerException npe = null;
        Iterator iterator = xpathNodeSet.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            short nodeType = node.getNodeType();
            if (nodeType == 9) {
                return (Document)node;
            }
            try {
                if (nodeType == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException e) {
                npe = e;
            }
        }
        throw new NullPointerException(String.valueOf(I18n.translate((String)"endorsed.jdk1.4.0")) + " Original message was \"" + (npe == null ? "" : npe.getMessage()) + "\"");
    }

    public static Element createDSctx(Document doc, String prefix, String namespace) {
        if (prefix == null || prefix.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element ctx = doc.createElementNS(null, "namespaceContext");
        ctx.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix.trim(), namespace);
        return ctx;
    }

    public static void addReturnToElement(Element e) {
    }

    public static Set convertNodelistToSet(NodeList xpathNodeSet) {
        if (xpathNodeSet == null) {
            return new HashSet();
        }
        int length = xpathNodeSet.getLength();
        HashSet<Node> set = new HashSet<Node>(length);
        int i = 0;
        while (i < length) {
            set.add(xpathNodeSet.item(i));
            ++i;
        }
        return set;
    }

    public static void circumventBug2650(Document doc) {
        Element documentElement = doc.getDocumentElement();
        Attr xmlnsAttr = documentElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (xmlnsAttr == null) {
            documentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(doc);
    }

    private static void circumventBug2650internal(Node node) {
        Node parent = null;
        Node sibling = null;
        while (true) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    if (!element.hasChildNodes()) break;
                    if (element.hasAttributes()) {
                        NamedNodeMap attributes = element.getAttributes();
                        int attributesLength = attributes.getLength();
                        Node child = element.getFirstChild();
                        while (child != null) {
                            if (child.getNodeType() == 1) {
                                Element childElement = (Element)child;
                                int i = 0;
                                while (i < attributesLength) {
                                    Attr currentAttr = (Attr)attributes.item(i);
                                    if ("http://www.w3.org/2000/xmlns/" == currentAttr.getNamespaceURI() && !childElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getLocalName())) {
                                        childElement.setAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getName(), currentAttr.getNodeValue());
                                    }
                                    ++i;
                                }
                            }
                            child = child.getNextSibling();
                        }
                    }
                }
                case 5: 
                case 9: {
                    parent = node;
                    sibling = node.getFirstChild();
                }
            }
            while (sibling == null && parent != null) {
                sibling = parent.getNextSibling();
                parent = parent.getParentNode();
            }
            if (sibling == null) {
                return;
            }
            node = sibling;
            sibling = node.getNextSibling();
        }
    }

    public static Element selectDsNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#" == sibling.getNamespaceURI()) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#" == sibling.getNamespaceURI()) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node sibling, String nodeName, int number) {
        Node n = XMLUtils.selectDsNode(sibling, nodeName, number);
        if (n == null) {
            return null;
        }
        n = n.getFirstChild();
        while (n != null && n.getNodeType() != 3) {
            n = n.getNextSibling();
        }
        return (Text)n;
    }

    public static Text selectNodeText(Node sibling, String uri, String nodeName, int number) {
        Node n = XMLUtils.selectNode(sibling, uri, nodeName, number);
        if (n == null) {
            return null;
        }
        n = n.getFirstChild();
        while (n != null && n.getNodeType() != 3) {
            n = n.getNextSibling();
        }
        return (Text)n;
    }

    public static Element selectNode(Node sibling, String uri, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && uri == sibling.getNamespaceURI()) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node sibling, String nodeName) {
        return XMLUtils.selectNodes(sibling, "http://www.w3.org/2000/09/xmldsig#", nodeName);
    }

    public static Element[] selectNodes(Node sibling, String uri, String nodeName) {
        int size = 20;
        Element[] a = new Element[size];
        int curr = 0;
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && uri == sibling.getNamespaceURI()) {
                a[curr++] = (Element)sibling;
                if (size <= curr) {
                    int cursize = size << 2;
                    Element[] cp = new Element[cursize];
                    System.arraycopy(a, 0, cp, 0, size);
                    a = cp;
                    size = cursize;
                }
            }
            sibling = sibling.getNextSibling();
        }
        Element[] af = new Element[curr];
        System.arraycopy(a, 0, af, 0, curr);
        return af;
    }

    public static Set excludeNodeFromSet(Node signatureElement, Set inputSet) {
        HashSet<Node> resultSet = new HashSet<Node>();
        Iterator iterator = inputSet.iterator();
        while (iterator.hasNext()) {
            Node inputNode = (Node)iterator.next();
            if (XMLUtils.isDescendantOrSelf(signatureElement, inputNode)) continue;
            resultSet.add(inputNode);
        }
        return resultSet;
    }

    public static boolean isDescendantOrSelf(Node ctx, Node descendantOrSelf) {
        if (ctx == descendantOrSelf) {
            return true;
        }
        Node parent = descendantOrSelf;
        while (parent != null) {
            if (parent == ctx) {
                return true;
            }
            if (parent.getNodeType() == 2) {
                parent = ((Attr)parent).getOwnerElement();
                continue;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

