/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

class CardInformationBinding {
    private IEntity dsUser = null;
    private IAttribute attCardinfo = null;
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$userprofile$idas$CardInformationBinding == null ? (class$org$eclipse$higgins$userprofile$idas$CardInformationBinding = CardInformationBinding.class$("org.eclipse.higgins.userprofile.idas.CardInformationBinding")) : class$org$eclipse$higgins$userprofile$idas$CardInformationBinding));
    private static ICache cardInfoCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.CardInformation");
    private static boolean isNoCache = cardInfoCache instanceof NOCache;
    static /* synthetic */ Class class$org$eclipse$higgins$userprofile$idas$CardInformationBinding;

    private void ensureInCache() throws Exception {
        if (isNoCache) {
            return;
        }
        UserCacheKey key = new UserCacheKey(this.dsUser.getEntityID());
        if (!cardInfoCache.isKeyInCache((ICacheKey)key)) {
            log.info((Object)("Load All CardInformation by userID:" + key.getKey().toString()));
            HashSet<CardInformation> cardInformationSet = new HashSet<CardInformation>();
            Iterator valsCCI = this.attCardinfo.getValues();
            while (valsCCI.hasNext()) {
                IAttributeValue val = (IAttributeValue)valsCCI.next();
                if (!val.isSimple()) {
                    CardInformation cardInformation = new CardInformation();
                    this.loadCardInformation((IComplexAttrValue)val, cardInformation);
                    cardInformationSet.add(cardInformation);
                    continue;
                }
                log.error((Object)("Complex value expected, but found " + this.attCardinfo.getModel().getType()));
            }
            cardInfoCache.put((ICacheKey)key, cardInformationSet);
            log.info((Object)(key.getKey().toString() + " card info cached."));
        }
    }

    private IComplexAttrValue getValCardInfo(CUID cuid) throws IdASException, UserProfileException {
        Iterator valsCCI = this.attCardinfo.getValues();
        IComplexAttrValue res = null;
        while (valsCCI.hasNext()) {
            IAttributeValue val = (IAttributeValue)valsCCI.next();
            if (!val.isSimple()) {
                String cuidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CC_cuid);
                if (!cuidFound.equals(cuid.toString())) continue;
                res = (IComplexAttrValue)val;
                break;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attCardinfo.getModel().getType());
        }
        if (res == null) {
            res = this.attCardinfo.addComplexValue(null);
            res.getAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
        }
        return res;
    }

    private void loadCardInfoByCUID(CUID cuid, CardInformation cardInfo) throws IdASException, UserProfileException, CardException {
        IComplexAttrValue val = this.getValCardInfo(cuid);
        if (val != null) {
            this.loadCardInformation(val, cardInfo);
        }
    }

    private void loadCardInformation(IComplexAttrValue valCardInfo, CardInformation cardInfo) throws UserProfileException, IdASException, CardException {
        cardInfo.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)valCardInfo, IdasCtxUris.CC_cuid)));
        this.loadCardCredential(valCardInfo, cardInfo);
    }

    private void loadCardCredential(IComplexAttrValue valCardInfo, CardInformation cardInfo) throws IdASException, UserProfileException {
        ISingleValuedAttribute attCardCred = valCardInfo.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
        IAttributeValue val = attCardCred.getValue();
        if (val != null) {
            CardCredential cc = new CardCredential();
            cc.setCredentialType((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_SC_type));
            cc.setTsAddress((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_SC_tsAddress));
            cc.setTsMetadataAddress((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_SC_tsMetadataAddress));
            cc.setUsername((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.UP_loginName));
            cc.setPassword((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.UP_password));
            ByteBuffer bb = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_SC_pinCode);
            cc.setPinCode(bb == null ? null : (bb.hasArray() ? bb.array() : null));
            cardInfo.setCardCredential(cc);
        } else {
            cardInfo.setCardCredential(null);
        }
    }

    private void saveCardCredential(IComplexAttrValue valCardInfo, CardInformation cardInfo) throws IdASException, UserProfileException {
        CardCredential cardCredential = cardInfo.getCardCredential();
        if (cardCredential == null) {
            return;
        }
        ISingleValuedAttribute attCardCred = valCardInfo.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
        IAttributeValue val = attCardCred.getValue();
        if (val == null) {
            val = attCardCred.addComplexValue(null);
        }
        if (val.isSimple()) {
            throw new UserProfileException("Complex value expected, but found " + attCardCred.getModel().getType());
        }
        IComplexAttrValue valCC = (IComplexAttrValue)val;
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_type).addSimpleValue(null, (Object)cardCredential.getCredentialType());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsAddress).addSimpleValue(null, (Object)cardCredential.getTsAddress());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsMetadataAddress).addSimpleValue(null, (Object)cardCredential.getTsMetadataAddress());
        valCC.getSingleValuedAttribute(IdasCtxUris.UP_loginName).addSimpleValue(null, (Object)cardCredential.getUsername());
        valCC.getSingleValuedAttribute(IdasCtxUris.UP_password).addSimpleValue(null, (Object)cardCredential.getPassword());
        valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_pinCode).addSimpleValue(null, cardCredential.getPinCode() == null ? null : ByteBuffer.wrap(cardCredential.getPinCode()));
    }

    private Set getCachedCardInformationSet(String userId) {
        UserCacheKey key = new UserCacheKey(userId);
        if (cardInfoCache.isKeyInCache((ICacheKey)key)) {
            return (Set)cardInfoCache.get((ICacheKey)key);
        }
        return null;
    }

    private CardInformation getCachedCardInformation(CUID cuid) throws UserProfileException, IdASException, MalformedURLException {
        block5: {
            try {
                this.ensureInCache();
                Set cardInformationSet = this.getCachedCardInformationSet(this.dsUser.getEntityID());
                if (cardInformationSet != null) {
                    if (cuid != null) {
                        Iterator iterator = cardInformationSet.iterator();
                        while (iterator.hasNext()) {
                            CardInformation cardInformationItem = (CardInformation)iterator.next();
                            if (!cuid.equals((Object)cardInformationItem.getCuid())) continue;
                            return cardInformationItem;
                        }
                    }
                    break block5;
                }
                CardInformation ci = new CardInformation();
                ci.setCuid(cuid);
                return ci;
            }
            catch (Exception e) {
                log.error((Object)"Errors :", (Throwable)e);
            }
        }
        return null;
    }

    public CardInformationBinding(IEntity dsUserProfile) throws Exception {
        this.dsUser = dsUserProfile;
        this.attCardinfo = this.dsUser.getAttribute(IdasCtxUris.UP_cardInformation);
        this.ensureInCache();
    }

    public CardInformation getCardInformation(CUID cuid) throws UserProfileException, IdASException, MalformedURLException, CardException {
        if (isNoCache) {
            CardInformation result = new CardInformation();
            result.setCuid(cuid);
            this.loadCardInfoByCUID(cuid, result);
            return result;
        }
        return this.getCachedCardInformation(cuid);
    }

    private void updateCachedCardInformation(CardInformation cardInfo) throws IdASException {
        try {
            Set cardInformationSet = this.getCachedCardInformationSet(this.dsUser.getEntityID());
            if (cardInformationSet != null) {
                if (cardInformationSet.contains(cardInfo)) {
                    cardInformationSet.remove(cardInfo);
                }
                cardInformationSet.add(cardInfo);
                cardInfoCache.update((ICacheKey)new UserCacheKey(this.dsUser.getEntityID()), (Object)cardInformationSet);
            }
        }
        catch (CacheException e) {
            log.error((Object)e);
        }
    }

    public void saveCardCredential(CUID cuid, CardCredential cardCredential) throws InvalidTypeException, NotSingleValuedAttributeException, IdASException, UserProfileException {
        CardInformation cardInfo = new CardInformation();
        cardInfo.setCuid(cuid);
        cardInfo.setCardCredential(cardCredential);
        if (!isNoCache) {
            this.updateCachedCardInformation(cardInfo);
        }
        this.saveCardCredential(this.getValCardInfo(cuid), cardInfo);
    }

    public void deleteCardCredential(CUID cuid) throws NotSingleValuedAttributeException, IdASException, UserProfileException {
        CardInformation cardInfo = new CardInformation();
        cardInfo.setCuid(cuid);
        cardInfo.setCardCredential(null);
        if (!isNoCache) {
            this.updateCachedCardInformation(cardInfo);
        }
        ISingleValuedAttribute attCardCred = this.getValCardInfo(cuid).getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
        attCardCred.remove();
    }

    public void applyUpdates() throws IdASException {
        this.dsUser.getContext().applyUpdates();
    }

    public void cancelUpdates() throws IdASException {
        this.dsUser.getContext().cancelUpdates();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

