/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.userprofile.ICardUsageManager;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.CardHistoryBinding;
import org.eclipse.higgins.userprofile.idas.CardUrlRelationBinding;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

public class CardUsageManager
implements ICardUsageManager {
    private static Log log;
    private IEntity dsUser_ = null;
    private CardUrlRelationBinding cuRelation_ = null;
    private CardHistoryBinding history_ = null;
    private CUID cuid_ = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.userprofile.idas.CardUsageManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    private CardHistoryBinding createHistory(CUID cuid) throws Exception {
        if (this.cuid_ == null || !this.cuid_.equals((Object)cuid)) {
            this.cuid_ = cuid;
            this.history_ = new CardHistoryBinding(this.dsUser_, cuid);
        }
        return this.history_;
    }

    public CardUsageManager() {
    }

    public CardUsageManager(IEntity dsUserProfile) throws Exception {
        this.dsUser_ = dsUserProfile;
        this.cuRelation_ = new CardUrlRelationBinding(this.dsUser_);
    }

    public CardUsage addCardHistory(CUID cuid, URI url) throws UserProfileException {
        try {
            if (cuid == null || url == null) {
                throw new IllegalArgumentException("Both cuid and site must be set!");
            }
            this.createHistory(cuid);
            CardUsage result = this.history_.saveHistoryEvent(url);
            this.cuRelation_.updateUsageSummary(result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public CardUsage addCardHistory(CUID cuid, WebForm form) throws UserProfileException {
        try {
            if (cuid == null || form == null) {
                throw new IllegalArgumentException("Both cuid and form must be set!");
            }
            this.createHistory(cuid);
            CardUsage result = this.history_.saveHistoryEvent(form);
            this.cuRelation_.updateUsageSummary(result);
            return result;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void clearCardHistory(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Card ID can not be null");
            }
            this.createHistory(cuid);
            this.history_.clearHistory();
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.clearLastUsedDate();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void clearCardHistory(CUID cuid, URI site) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Card ID can not be null");
            }
            if (site == null) {
                throw new IllegalArgumentException("Site url can not be null");
            }
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.clearLastUsedDate(new WebForm(site, null, null, null));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void clearCardHistory(CUID cuid, WebForm form) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Card ID can not be null");
            }
            if (form == null) {
                throw new IllegalArgumentException("Web form can not be null");
            }
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.clearLastUsedDate(form);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws UserProfileException {
        try {
            try {
                this.cuRelation_.finish();
                this.dsUser_.getContext().applyUpdates();
            }
            catch (Exception e) {
                log.error((Object)e);
                e.printStackTrace();
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            try {
                this.dsUser_.getContext().close();
                throw throwable;
            }
            catch (IdASException e) {
                log.error((Object)e);
                e.printStackTrace();
            }
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        try {}
        catch (IdASException e) {
            log.error((Object)e);
            e.printStackTrace();
            return;
        }
        this.dsUser_.getContext().close();
    }

    public CardUsage setUsedAlways(CUID cuid, URI url) throws UserProfileException {
        try {
            if (cuid == null || url == null) {
                throw new IllegalArgumentException("Both cuid and site must be set!");
            }
            CardUsage cardUsage = new CardUsage(cuid, url, null, Boolean.TRUE);
            cardUsage = this.cuRelation_.updateUsageSummary(cardUsage);
            return cardUsage;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public CardUsage setUsedAlways(CUID cuid, WebForm form) throws UserProfileException {
        try {
            if (cuid == null || form == null) {
                throw new IllegalArgumentException("Both cuid and form must be set!");
            }
            CardUsage cardUsage = new CardUsage(cuid, form, null, Boolean.TRUE);
            cardUsage = this.cuRelation_.updateUsageSummary(cardUsage);
            return cardUsage;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public CardUsage deleteUsedAlways(CUID cuid, URI url) throws UserProfileException {
        try {
            if (cuid == null || url == null) {
                throw new IllegalArgumentException("Both cuid and site must be set!");
            }
            CardUsage cardUsage = new CardUsage(cuid, url, null, Boolean.FALSE);
            cardUsage = this.cuRelation_.updateUsageSummary(cardUsage);
            return cardUsage;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public CardUsage deleteUsedAlways(CUID cuid, WebForm form) throws UserProfileException {
        try {
            if (cuid == null || form == null) {
                throw new IllegalArgumentException("Both cuid and form must be set!");
            }
            CardUsage cardUsage = new CardUsage(cuid, form, null, Boolean.FALSE);
            cardUsage = this.cuRelation_.updateUsageSummary(cardUsage);
            return cardUsage;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void setOptionalClaims(CUID cuid, URI site, Set optionalClaims) throws UserProfileException {
        try {
            if (cuid == null || site == null) {
                throw new IllegalArgumentException("Both cuid and site must be set!");
            }
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.setOptionalClaims(new WebForm(site, null, null, null), optionalClaims);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void setOptionalClaims(CUID cuid, WebForm form, Set optionalClaims) throws UserProfileException {
        try {
            if (cuid == null || form == null) {
                throw new IllegalArgumentException("Both cuid and form must be set!");
            }
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.setOptionalClaims(form, optionalClaims);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public Set getOptionalClaims(CUID cuid, URI site) throws UserProfileException {
        try {
            if (cuid == null || site == null) {
                throw new IllegalArgumentException("Both cuid and site must be set!");
            }
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getOptionalClaims(new WebForm(site, null, null, null));
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public Set getOptionalClaims(CUID cuid, WebForm form) throws UserProfileException {
        try {
            if (cuid == null || form == null) {
                throw new IllegalArgumentException("Both cuid and form must be set!");
            }
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getOptionalClaims(form);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void clearUsedAlwaysURLs(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Card ID can not be null");
            }
            this.cuRelation_.setCuid(cuid);
            this.cuRelation_.clearUsedAlwaysURLs();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getCardHistory(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            this.createHistory(cuid);
            return this.history_.getCardHistory();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getCardHistory(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            this.createHistory(cuid);
            return this.history_.getCardHistory(startFrom, size, orderBy, desc);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getCardUsageSummary(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cardCredentialInfo\" is null");
            }
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getCardUsageSummary();
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getCardUsageSummary(CUID cuid, int startFrom, int size, String orderBy, boolean desc) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cardCredentialInfo\" is null");
            }
            log.debug((Object)" *** CardUsageManager.getCardUsageSummary");
            log.debug((Object)(" *** " + cuid + ", " + startFrom + ", " + size + ", " + orderBy + ", " + desc));
            log.debug((Object)(" *** user " + this.dsUser_.getEntityID()));
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getCardUsageSummary(startFrom, size, orderBy, desc);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public int getHistoryTotalSize(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            this.createHistory(cuid);
            return this.history_.getTotalSize();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public int getSummaryTotalSize(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getTotalSize();
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public CUID getUsedAlwaysCard(URI url) throws UserProfileException {
        try {
            if (url == null) {
                throw new IllegalArgumentException("Parameter \"url\" is null");
            }
            return this.cuRelation_.getUsedAlwaysCard(new WebForm(url, null, null, null));
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public CUID getUsedAlwaysCard(WebForm form) throws UserProfileException {
        try {
            if (form == null) {
                throw new IllegalArgumentException("Parameter \"form\" is null");
            }
            return this.cuRelation_.getUsedAlwaysCard(form);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getUsedAlwaysURLs(CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            this.cuRelation_.setCuid(cuid);
            return this.cuRelation_.getUsedAlwaysUrls();
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getUsedCards(URI url) throws UserProfileException {
        try {
            if (url == null) {
                throw new IllegalArgumentException("Parameter \"url\" is null");
            }
            return this.cuRelation_.getUsedCards(new WebForm(url, null, null, null));
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public List getUsedCards(WebForm form) throws UserProfileException {
        try {
            if (form == null) {
                throw new IllegalArgumentException("Parameter \"form\" is null");
            }
            return this.cuRelation_.getUsedCards(form);
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public Map getClaimValuesMRU() throws UserProfileException {
        try {
            HashMap res = new HashMap();
            IAttribute attCV = this.dsUser_.getAttribute(IdasCtxUris.UP_claimValuesMRU);
            Iterator itValsCV = attCV.getValues();
            while (itValsCV.hasNext()) {
                IAttributeValue valCV = (IAttributeValue)itValsCV.next();
                if (!valCV.isSimple()) {
                    String claimType = (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCV), IdasCtxUris.CU_claimType);
                    IAttribute attMRUValues = ((IComplexAttrValue)valCV).getAttribute(IdasCtxUris.CU_claimValue);
                    Iterator itMRUValues = attMRUValues.getValues();
                    HashSet<String> resValues = new HashSet<String>();
                    while (itMRUValues.hasNext()) {
                        ISimpleAttrValue val = (ISimpleAttrValue)itMRUValues.next();
                        String sVal = (String)val.getData();
                        resValues.add(sVal);
                    }
                    res.put(claimType, resValues);
                    continue;
                }
                throw new UserProfileException("Attribute " + (attCV.getAttrID() != null ? attCV.getAttrID().toString() : "") + " contains simple value");
            }
            return res;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public Set getClaimValuesMRU(String claimType) throws UserProfileException {
        try {
            if (claimType == null) {
                throw new IllegalArgumentException("Parameter \"claimType\" is null");
            }
            HashSet<String> resValues = new HashSet<String>();
            IAttribute attCV = this.dsUser_.getAttribute(IdasCtxUris.UP_claimValuesMRU);
            Iterator itValsCV = attCV.getValues();
            while (itValsCV.hasNext()) {
                IAttributeValue valCV = (IAttributeValue)itValsCV.next();
                if (!valCV.isSimple()) {
                    if (!claimType.equals((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCV), IdasCtxUris.CU_claimType))) continue;
                    IAttribute attMRUValues = ((IComplexAttrValue)valCV).getAttribute(IdasCtxUris.CU_claimValue);
                    Iterator itMRUValues = attMRUValues.getValues();
                    while (itMRUValues.hasNext()) {
                        ISimpleAttrValue val = (ISimpleAttrValue)itMRUValues.next();
                        String sVal = (String)val.getData();
                        resValues.add(sVal);
                    }
                    break;
                }
                throw new UserProfileException("Attribute " + (attCV.getAttrID() != null ? attCV.getAttrID().toString() : "") + " contains simple value");
            }
            return resValues;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }

    public void setClaimValuesMRU(String claimType, Set claimValues) throws UserProfileException {
        try {
            IComplexAttrValue valCV;
            if (claimType == null) {
                throw new IllegalArgumentException("Parameter \"claimType\" is null");
            }
            IAttribute attCV = this.dsUser_.getAttribute(IdasCtxUris.UP_claimValuesMRU);
            Iterator itValsCV = attCV.getValues();
            while (itValsCV.hasNext()) {
                valCV = (IAttributeValue)itValsCV.next();
                if (!valCV.isSimple()) {
                    if (!claimType.equals((String)IdasUtils.getSimpleValueData((IHasAttributes)valCV, IdasCtxUris.CU_claimType))) continue;
                    IAttribute attMRUValues = valCV.getAttribute(IdasCtxUris.CU_claimValue);
                    attMRUValues.remove();
                    if (claimValues != null && claimValues.size() > 0) {
                        Iterator itMRUValues = claimValues.iterator();
                        while (itMRUValues.hasNext()) {
                            attMRUValues.addSimpleValue(null, (Object)((String)itMRUValues.next()));
                        }
                    } else {
                        valCV.remove();
                    }
                    return;
                }
                throw new UserProfileException("Attribute " + (attCV.getAttrID() != null ? attCV.getAttrID().toString() : "") + " contains simple value");
            }
            valCV = attCV.addComplexValue(IdasCtxUris.CU_ClaimValuesMRU);
            valCV.getAttribute(IdasCtxUris.CU_claimType).addSimpleValue(null, (Object)claimType);
            if (claimValues != null) {
                IAttribute attMRUValues = valCV.getAttribute(IdasCtxUris.CU_claimValue);
                Iterator itMRUValues = claimValues.iterator();
                while (itMRUValues.hasNext()) {
                    attMRUValues.addSimpleValue(null, (Object)((String)itMRUValues.next()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            throw new UserProfileException((Throwable)e);
        }
    }
}

