/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.common.ProviderConfiguration;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NoSuchEntityException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.userprofile.ICardUsageManager;
import org.eclipse.higgins.userprofile.IUserProfileService;
import org.eclipse.higgins.userprofile.UserProfileAuthenticationException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.entity.Category;
import org.eclipse.higgins.userprofile.entity.PolicyVersion;
import org.eclipse.higgins.userprofile.entity.UserProfile;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.CardInformationBinding;
import org.eclipse.higgins.userprofile.idas.CardUsageManager;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

public class IdasBasedUserProfileService
implements IUserProfileService {
    private String IDAS_CONTEXT_ID = "idasContext.id";
    private String DISCOVERY_FILE = "idasDiscovery.filename";
    private String IDAS_USER_NAME = "idasUser.name";
    private String IDAS_USER_PASSWORD = "idasUser.password";
    private static Log log;
    private String id_ = "org.eclipse.higgins.userprofile.idas";
    private IConfiguration config_;
    private IdASRegistry registry_;
    private String sCtx;
    private String sUser;
    private String sPassword;
    private static ICache userProfileCache;
    private static boolean isNoCache;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.higgins.userprofile.idas.IdasBasedUserProfileService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        userProfileCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.UserProfiles");
        isNoCache = userProfileCache instanceof NOCache;
    }

    private synchronized void loadConfig() {
        String sFactories = this.getConfiguration().getProperty(this.DISCOVERY_FILE, "contextfactories.xrds");
        FileDiscovery factories = new FileDiscovery(new File(sFactories));
        this.registry_ = IdASRegistry.getInstance();
        this.registry_.setDiscovery((IDiscovery)factories);
        this.sCtx = this.getConfiguration().getProperty(this.IDAS_CONTEXT_ID, "userProfileContext.xrds");
        this.sUser = this.getConfiguration().getProperty(this.IDAS_USER_NAME, "testUser");
        this.sPassword = this.getConfiguration().getProperty(this.IDAS_USER_PASSWORD, "testPassword");
    }

    private IContext getContext() throws IdASException, UserProfileException {
        IContext ctx;
        if (this.registry_ == null) {
            this.loadConfig();
        }
        if ((ctx = this.registry_.createContext(this.sCtx)) == null) {
            throw new UserProfileException("User profile context not found with ID " + this.sCtx);
        }
        ctx.open((Object)new AuthNNamePasswordMaterials(ctx, this.sUser, this.sPassword));
        return ctx;
    }

    private IEntity authenticate(CallbackHandler handler) throws UserProfileException, IdASException {
        UserCreds uc = new UserCreds(handler);
        IContext ctx = this.getContext();
        IEntity dsUser = null;
        try {
            dsUser = ctx.getEntity(uc.getUriName());
        }
        catch (NoSuchEntityException noSuchEntityException) {
            dsUser = null;
        }
        if (dsUser == null) {
            ctx.close();
            throw new UserProfileAuthenticationException("User Profile " + uc.getName() + " not found!");
        }
        if (!uc.isUserId()) {
            ByteBuffer newAuthHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
            if (newAuthHash != null && newAuthHash.hasArray()) {
                try {
                    uc.checkPasswordHash(newAuthHash);
                }
                catch (UserProfileAuthenticationException userProfileAuthenticationException) {
                    uc.checkPasswordHash((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash));
                }
            } else {
                uc.checkPasswordHash((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash));
            }
        }
        return dsUser;
    }

    private IEntity authenticate(String userId, byte[] passwordIsapMd5) throws UserProfileException, IdASException {
        IContext ctx = this.getContext();
        IEntity dsUser = null;
        try {
            dsUser = ctx.getEntity("urn:" + userId.replace(' ', '_'));
        }
        catch (NoSuchEntityException noSuchEntityException) {
            dsUser = null;
        }
        if (dsUser == null) {
            ctx.close();
            throw new UserProfileAuthenticationException("User Profile " + userId + " not found!");
        }
        ByteBuffer passwordIsapMd5stored = (ByteBuffer)IdasUtils.getSimpleValueData(dsUser, IdasCtxUris.UP_passwordIsapMd5);
        if (passwordIsapMd5stored != null && passwordIsapMd5stored.hasArray() && !passwordIsapMd5stored.position(0).equals(ByteBuffer.wrap(passwordIsapMd5).position(0))) {
            throw new UserProfileAuthenticationException("Invalid passwordIsapMd5! User " + userId);
        }
        return dsUser;
    }

    private void saveToDS_UP(UserProfile up, IEntity ds) throws Exception {
        try {
            ds.getAttribute(IdasCtxUris.UP_loginName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getLoginName());
            ds.getAttribute(IdasCtxUris.UP_firstName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getFirstName());
            ds.getAttribute(IdasCtxUris.UP_lastName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getLastName());
            ds.getAttribute(IdasCtxUris.UP_email).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getEmail());
            ds.getAttribute(IdasCtxUris.UP_modified).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)up.getModified());
            ds.getAttribute(IdasCtxUris.UP_status).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getStatus());
            ds.getAttribute(IdasCtxUris.UP_usedFrom).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getUsedFrom());
            ds.getAttribute(IdasCtxUris.UP_privateUserINumber).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getPrivateUserINumber());
            IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers), up.getPrivateSelectorINumbers());
            IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords), up.getOneTimePasswords());
            IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_blackListedSites), up.getBlackListedSites());
            ds.getAttribute(IdasCtxUris.UP_privateKey).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, up.getPrivateKey() == null ? null : ByteBuffer.wrap(up.getPrivateKey()));
            ds.getAttribute(IdasCtxUris.UP_passwordIsapMd5).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, up.getPasswordIsapMd5() == null ? null : ByteBuffer.wrap(up.getPasswordIsapMd5()));
            ds.getAttribute(IdasCtxUris.UP_sms).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getSms());
        }
        catch (Exception e) {
            ds.getContext().cancelUpdates();
            throw e;
        }
    }

    private UserProfile initFromDS_UP(IEntity ds) throws UserProfileException, IdASException {
        UserProfile up = new UserProfile();
        up.setLoginName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_loginName));
        up.setFirstName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_firstName));
        up.setLastName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_lastName));
        up.setEmail((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_email));
        up.setCreated((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_created));
        up.setModified((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_modified));
        up.setStatus((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_status));
        up.setUsedFrom((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_usedFrom));
        up.setPrivateUserINumber((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_privateUserINumber));
        up.setPrivateSelectorINumbers(IdasUtils.loadSimpleValueList(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers)));
        up.setOneTimePasswords(IdasUtils.loadSimpleValueList(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords)));
        up.setBlackListedSites(IdasUtils.loadSimpleValueSet(ds.getAttribute(IdasCtxUris.UP_blackListedSites)));
        up.setPrivateKey(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_privateKey));
        up.setPasswordIsapMd5(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_passwordIsapMd5));
        up.setSms((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_sms));
        up.setUserIdentifier(ds.getEntityID());
        return up;
    }

    private void saveToDS_cat(Category cat, IEntity ds) throws Exception {
        cat.setId(ds.getEntityID());
        ds.getAttribute(IdasCtxUris.CC_parentId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getParentId());
        ds.getAttribute(IdasCtxUris.CC_name).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getName());
        ds.getAttribute(IdasCtxUris.CC_icon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getIcon());
        ds.getAttribute(IdasCtxUris.CC_selectedIcon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getSelectedIcon());
        ds.getAttribute(IdasCtxUris.CC_idx).addSimpleValue(ITypedValue.INTEGER_TYPE_URI, (Object)new Integer(cat.getIdx()));
        ds.getAttribute(IdasCtxUris.CC_type).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getType());
        IAttribute attr = ds.getAttribute(IdasCtxUris.CC_cuid);
        attr.remove();
        if (cat.getCardList() != null && !cat.getCardList().isEmpty()) {
            Iterator iter = cat.getCardList().iterator();
            while (iter.hasNext()) {
                attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, iter.next());
            }
        }
    }

    private Category initFromDS_cat(IEntity ds) throws UserProfileException, IdASException {
        Category cat = new Category();
        cat.setId(ds.getEntityID());
        cat.setParentId((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_parentId));
        cat.setName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_name));
        cat.setIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_icon));
        cat.setSelectedIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_selectedIcon));
        Integer idx = (Integer)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_idx);
        if (idx == null) {
            cat.setIdx(0);
        } else {
            cat.setIdx(idx.intValue());
        }
        cat.setType((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_type));
        IAttribute att = ds.getAttribute(IdasCtxUris.CC_cuid);
        String cuid = null;
        ArrayList<String> cuids = new ArrayList<String>();
        if (att.getValues() != null) {
            Iterator iter = att.getValues();
            while (iter.hasNext()) {
                IAttributeValue v = (IAttributeValue)iter.next();
                if (!v.isSimple()) {
                    throw new UserProfileException("Attribute " + (att.getAttrID() != null ? att.getAttrID().toString() : "") + " contains non simple value");
                }
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                cuid = (String)sv.getData();
                cuids.add(cuid);
            }
        }
        cat.setCardList(cuids);
        return cat;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserProfile addUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException {
        try {
            UserCreds uc = new UserCreds(handler);
            if (this.userIdentifierExists(uc.getName())) {
                throw new UserProfileException("User with identifier \"" + uc.getName() + "\" already exists!");
            }
            if (userProfile == null) {
                throw new IllegalArgumentException("Parameter \"userProfile\" is null");
            }
            IEntity ds = this.getContext().addEntity(IdasCtxUris.UP_UserProfile, uc.getUriName());
            try {
                if (ds == null) {
                    throw new UserProfileException("UserProfile not added.");
                }
                userProfile.setCreated(new Date());
                userProfile.setUserIdentifier(ds.getEntityID());
                ds.getAttribute(IdasCtxUris.UP_created).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)userProfile.getCreated());
                ds.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(uc.password_));
                this.saveToDS_UP(userProfile, ds);
                ds.getContext().applyUpdates();
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                ds.getContext().close();
                throw throwable;
            }
            {
                Object var5_9 = null;
            }
            ds.getContext().close();
            if (isNoCache) return userProfile;
            CachedItem cached = new CachedItem();
            cached.userProfile = userProfile;
            cached.passwordHash = UserCreds.getPasswordHash(uc.password_);
            UserCacheKey key = new UserCacheKey(uc.getUriName());
            userProfileCache.put((ICacheKey)key, (Object)cached);
            return userProfile;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteUserProfile(CallbackHandler handler) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                this.deleteAllCategories(dsUser);
                dsUser.remove();
                dsUser.getContext().applyUpdates();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            dsUser.getContext().close();
            if (isNoCache) return;
            UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
            userProfileCache.remove((ICacheKey)key);
            return;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    private void deleteAllCategories(IEntity dsUser) throws IdASException, UserProfileException {
        IContext ctx = dsUser.getContext();
        IFilter filter = ctx.buildFilter();
        IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
        fas.includeSubtypes(true);
        fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        fas.setID(IdasCtxUris.CC_userIdentifier);
        ISimpleAttrValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
        fas.setAssertionValue((IAttributeValue)val);
        filter.setAssertion((IFilterAssertion)fas);
        Iterator subjList = ctx.getEntities(filter);
        while (subjList.hasNext()) {
            IEntity subj = (IEntity)subjList.next();
            subj.remove();
        }
    }

    private UserProfile loadUserProfile(CallbackHandler handler) throws UserProfileException, IdASException {
        UserProfile userProfile;
        IEntity ds = this.authenticate(handler);
        try {
            UserProfile up;
            userProfile = up = this.initFromDS_UP(ds);
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            ds.getContext().close();
            throw throwable;
        }
        ds.getContext().close();
        return userProfile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserProfile getUserProfile(CallbackHandler handler) throws UserProfileException {
        try {
            UserProfile userProfile;
            if (isNoCache) {
                return this.loadUserProfile(handler);
            }
            UserCreds userCreds = new UserCreds(handler);
            UserCacheKey key = new UserCacheKey(userCreds.getUriName());
            if (userProfileCache.isKeyInCache((ICacheKey)key)) {
                CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                UserProfile up = cached.userProfile;
                if (userCreds.isUserId()) return up;
                if (cached.newPasswordHash == null) {
                    userCreds.checkPasswordHash(cached.passwordHash);
                    return up;
                }
                try {
                    userCreds.checkPasswordHash(cached.newPasswordHash);
                    return up;
                }
                catch (UserProfileAuthenticationException userProfileAuthenticationException) {
                    userCreds.checkPasswordHash(cached.passwordHash);
                    return up;
                }
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CachedItem cached = new CachedItem();
                cached.userProfile = this.initFromDS_UP(dsUser);
                cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                cached.newPasswordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
                userProfileCache.put((ICacheKey)key, (Object)cached);
                userProfile = cached.userProfile;
                Object var6_11 = null;
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return userProfile;
        }
        catch (UserProfileAuthenticationException e) {
            log.error((Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserProfile modifyUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException {
        try {
            IEntity ds = this.authenticate(handler);
            try {
                if (userProfile == null) {
                    throw new IllegalArgumentException("Parameter \"userProfile\" can not be null");
                }
                userProfile.setModified(new Date());
                this.saveToDS_UP(userProfile, ds);
                ds.getContext().applyUpdates();
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                ds.getContext().close();
                throw throwable;
            }
            {
                Object var4_8 = null;
            }
            ds.getContext().close();
            if (isNoCache) return userProfile;
            UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
            CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
            cached.userProfile = userProfile;
            userProfileCache.put((ICacheKey)key, (Object)cached);
            return userProfile;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean userIdentifierExists(String userIdentifier) throws UserProfileException {
        IContext ctx = null;
        IEntity ds = null;
        try {
            block7: {
                try {
                    ctx = this.getContext();
                    ds = ctx.getEntity("urn:" + userIdentifier.replace(' ', '_'));
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (ctx != null) {
                        ctx.close();
                    }
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    if (ctx == null) break block7;
                }
                ctx.close();
            }
            return ds != null;
        }
        catch (NoSuchEntityException noSuchEntityException) {
            return false;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public String resetPassword(CallbackHandler handler) throws UserProfileException {
        throw new UserProfileException("Not implemented!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveUserIdentifier(String privateSelectorINumber) throws UserProfileException {
        try {
            IContext ctx;
            block5: {
                String string;
                ctx = this.getContext();
                try {
                    IFilter filter = ctx.buildFilter();
                    IFilterAttributeAssertion assertion = ctx.buildAttributeAssertion();
                    assertion.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
                    assertion.setID(IdasCtxUris.UP_privateSelectorINumbers);
                    assertion.setAssertionValue((IAttributeValue)ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)privateSelectorINumber));
                    filter.setAssertion((IFilterAssertion)assertion);
                    Iterator it = ctx.getEntities(filter);
                    if (!it.hasNext()) break block5;
                    IEntity e = (IEntity)it.next();
                    string = e.getEntityID().substring(4);
                    Object var7_9 = null;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    ctx.close();
                    throw throwable;
                }
                ctx.close();
                return string;
            }
            Object var7_11 = null;
            ctx.close();
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Category addCategory(CallbackHandler handler, Category category) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                if (category == null) {
                    throw new IllegalArgumentException("Parameter \"category\" is null");
                }
                IEntity ds = dsUser.getContext().addEntity(IdasCtxUris.CC_CardCategory, null);
                if (ds == null) {
                    throw new UserProfileException("Category " + category.getId() + " not added.");
                }
                ds.getAttribute(IdasCtxUris.CC_userIdentifier).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
                this.saveToDS_cat(category, ds);
                dsUser.getContext().applyUpdates();
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var5_8 = null;
                dsUser.getContext().close();
                return category;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteCategory(CallbackHandler handler, String categoryId) throws UserProfileException {
        IContext ctx = null;
        try {
            try {
                if (categoryId == null) throw new IllegalArgumentException("Parameter \"categoryId\" is null");
                if (categoryId.trim().length() == 0) {
                    throw new IllegalArgumentException("Parameter \"categoryId\" is null");
                }
                ctx = this.authenticate(handler).getContext();
                IEntity ds = ctx.getEntity(categoryId);
                if (ds == null) {
                    throw new UserProfileException("Category \"" + categoryId + "\" not found");
                }
                ds.remove();
                ctx.applyUpdates();
            }
            catch (IdASException e) {
                try {
                    ctx.cancelUpdates();
                }
                catch (IdASException e1) {
                    log.error((Object)e1);
                }
                log.error((Object)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                ctx.close();
                throw throwable;
            }
            catch (IdASException e) {
                log.error((Object)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IdASException e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
        ctx.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List getCategories(CallbackHandler handler) throws UserProfileException {
        try {
            ArrayList<Category> arrayList;
            IEntity dsUser = this.authenticate(handler);
            try {
                IFilter filter = dsUser.getContext().buildFilter();
                IFilterAttributeAssertion fas = dsUser.getContext().buildAttributeAssertion();
                fas.includeSubtypes(true);
                fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
                fas.setID(IdasCtxUris.CC_userIdentifier);
                ISimpleAttrValue val = dsUser.getContext().buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
                fas.setAssertionValue((IAttributeValue)val);
                filter.setAssertion((IFilterAssertion)fas);
                Iterator subjList = dsUser.getContext().getEntities(filter);
                ArrayList<Category> categories = new ArrayList<Category>();
                while (true) {
                    if (!subjList.hasNext()) {
                        arrayList = categories;
                        Object var10_12 = null;
                        break;
                    }
                    IEntity subj = (IEntity)subjList.next();
                    if (!IdasCtxUris.CC_CardCategory.equals(subj.getModel().getType())) continue;
                    Category category = this.initFromDS_cat(subj);
                    categories.add(category);
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return arrayList;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Category modifyCategory(CallbackHandler handler, Category category) throws UserProfileException {
        try {
            Category category2;
            IEntity dsUser = this.authenticate(handler);
            try {
                if (category == null) {
                    throw new IllegalArgumentException("Parameter \"category\" is null");
                }
                if (category.getId() == null || category.getId().trim().length() == 0) {
                    throw new IllegalArgumentException("Category ID can not be null");
                }
                IEntity ds = dsUser.getContext().getEntity(category.getId());
                if (ds == null) {
                    throw new UserProfileException("Category \"" + category.getId() + "\" not found!");
                }
                this.saveToDS_cat(category, ds);
                dsUser.getContext().applyUpdates();
                category2 = category;
                Object var5_7 = null;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return category2;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CardInformation setCardCredential(CallbackHandler handler, CUID cuid, CardCredential cardCredential) throws UserProfileException {
        try {
            CardInformation cardInformation;
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            if (cardCredential == null) {
                throw new IllegalArgumentException("Parameter \"cardCredential\" is null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CardInformationBinding cib = new CardInformationBinding(dsUser);
                try {
                    cib.saveCardCredential(cuid, cardCredential);
                    CardInformation ci = cib.getCardInformation(cuid);
                    cib.applyUpdates();
                    cardInformation = ci;
                }
                catch (Exception e) {
                    cib.cancelUpdates();
                    throw e;
                }
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return cardInformation;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CardInformation clearCardCredential(CallbackHandler handler, CUID cuid) throws UserProfileException {
        try {
            CardInformation cardInformation;
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CardInformationBinding cib = new CardInformationBinding(dsUser);
                try {
                    cib.deleteCardCredential(cuid);
                    CardInformation ci = cib.getCardInformation(cuid);
                    cib.applyUpdates();
                    cardInformation = ci;
                }
                catch (Exception e) {
                    cib.cancelUpdates();
                    throw e;
                }
                Object var6_9 = null;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return cardInformation;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CardInformation getCardInformation(CallbackHandler handler, CUID cuid) throws UserProfileException {
        try {
            CardInformation cardInformation;
            if (cuid == null || cuid.toString().length() == 0) {
                throw new IllegalArgumentException("Card ID can not be null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CardInformationBinding cib = new CardInformationBinding(dsUser);
                CardInformation ci = cib.getCardInformation(cuid);
                dsUser.getContext().applyUpdates();
                cardInformation = ci;
                Object var6_8 = null;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            dsUser.getContext().close();
            return cardInformation;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ICardUsageManager getCardUsageManager(CallbackHandler handler) throws UserProfileException {
        IEntity dsUser = null;
        try {
            dsUser = this.authenticate(handler);
            try {
                return new CardUsageManager(dsUser);
            }
            catch (Exception e) {
                log.warn((Object)("Closing context of User " + dsUser.getEntityID() + ", in result of Exception:"));
                log.warn((Object)e);
                dsUser.getContext().close();
                log.warn((Object)("Context might be closed. User " + dsUser.getEntityID()));
                return null;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyVersion getRPPolicyVersion(CallbackHandler handler, WebForm form) throws UserProfileException {
        try {
            IEntity dsUser;
            block7: {
                PolicyVersion policyVersion;
                block6: {
                    dsUser = this.authenticate(handler);
                    try {
                        IAttribute attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                        Iterator it = attPV.getValues();
                        while (it.hasNext()) {
                            IComplexAttrValue valPV = (IComplexAttrValue)it.next();
                            WebForm wfFound = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction));
                            if (!wfFound.equals((Object)form)) continue;
                            PolicyVersion pv = new PolicyVersion();
                            pv.setForm(wfFound);
                            pv.setPolicy(new String(((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_policy)).array(), "UTF-8"));
                            pv.setVersion((String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_version));
                            policyVersion = pv;
                            Object var9_11 = null;
                            break block6;
                        }
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        dsUser.getContext().close();
                        throw throwable;
                    }
                }
                dsUser.getContext().close();
                return policyVersion;
            }
            Object var9_13 = null;
            dsUser.getContext().close();
            return null;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRPPolicyVersion(CallbackHandler handler, PolicyVersion policyVersion) throws UserProfileException {
        try {
            IEntity dsUser;
            block10: {
                if (policyVersion == null) {
                    throw new IllegalArgumentException("Parameter \"policyVersion\" can not be null");
                }
                if (policyVersion.getForm() == null) {
                    throw new IllegalArgumentException("Parameter \"policyVersion.webForm\" can not be null");
                }
                if (policyVersion.getPolicy() == null) {
                    throw new IllegalArgumentException("Parameter \"policyVersion.policy\" can not be null");
                }
                if (policyVersion.getVersion() == null) {
                    throw new IllegalArgumentException("Parameter \"policyVersion.version\" can not be null");
                }
                dsUser = this.authenticate(handler);
                try {
                    IComplexAttrValue valPV;
                    WebForm wfFound;
                    IAttribute attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                    Iterator it = attPV.getValues();
                    do {
                        if (it.hasNext()) continue;
                        IComplexAttrValue valPV2 = attPV.addComplexValue(IdasCtxUris.PV_PolicyVersion);
                        valPV2.getAttribute(IdasCtxUris.CU_url).addSimpleValue(ITypedValue.ANYURI_TYPE_URI, (Object)policyVersion.getForm().getUrl());
                        valPV2.getAttribute(IdasCtxUris.CU_formAction).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormAction());
                        valPV2.getAttribute(IdasCtxUris.CU_formId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormId());
                        valPV2.getAttribute(IdasCtxUris.CU_formName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormName());
                        valPV2.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                        valPV2.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                        dsUser.getContext().applyUpdates();
                        break block10;
                    } while ((wfFound = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)(valPV = (IComplexAttrValue)it.next()), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction))) == null || !wfFound.equals((Object)policyVersion.getForm()));
                    valPV.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                    valPV.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                    dsUser.getContext().applyUpdates();
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    dsUser.getContext().close();
                    throw throwable;
                }
                dsUser.getContext().close();
                return;
            }
            Object var8_11 = null;
            dsUser.getContext().close();
            return;
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNewPassword(CallbackHandler handler, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                        cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                    }
                    cached.newPasswordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                dsUser.getContext().close();
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setNewPasswordByPasswordIsapMd5(String userId, byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(userId, passwordIsapMd5);
            try {
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey("urn:" + userId.replace(' ', '_'));
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                        cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                    }
                    cached.newPasswordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var7_10 = null;
                dsUser.getContext().close();
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteOldPassword(CallbackHandler handler) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                ByteBuffer newAuthHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
                if (newAuthHash == null) throw new UserProfileAuthenticationException("Can not delete old password! Set the new one first!");
                if (!newAuthHash.hasArray()) {
                    throw new UserProfileAuthenticationException("Can not delete old password! Set the new one first!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).remove();
                dsUser.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)newAuthHash);
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                    }
                    cached.newPasswordHash = null;
                    cached.passwordHash = newAuthHash;
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var6_9 = null;
                dsUser.getContext().close();
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            if (!(e instanceof UserProfileAuthenticationException)) throw new UserProfileException((Throwable)e);
            throw (UserProfileAuthenticationException)((Object)e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addSelectorAndSetPasswordByPasswordIsapMd5(String userId, String privateSelectorINumber, byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(userId, passwordIsapMd5);
            try {
                if (privateSelectorINumber == null) {
                    throw new IllegalArgumentException("Parameter \"privateSelectorINumber\" can not be null!");
                }
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                UserProfile up = this.initFromDS_UP(dsUser);
                ArrayList<String> listPSINum = up.getPrivateSelectorINumbers();
                if (listPSINum == null) {
                    listPSINum = new ArrayList<String>();
                }
                listPSINum.add(privateSelectorINumber);
                up.setPrivateSelectorINumbers(listPSINum);
                this.saveToDS_UP(up, dsUser);
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).remove();
                dsUser.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey("urn:" + userId.replace(' ', '_'));
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = up;
                    }
                    cached.newPasswordHash = null;
                    cached.passwordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                dsUser.getContext().close();
                throw throwable;
            }
            {
                Object var10_13 = null;
                dsUser.getContext().close();
                return;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    private class CachedItem {
        private UserProfile userProfile;
        private ByteBuffer passwordHash;
        private ByteBuffer newPasswordHash;

        private CachedItem() {
        }
    }

    private static class UserCreds {
        private String name_;
        private String password_;

        public UserCreds(CallbackHandler handler) throws UserProfileException {
            NameCallback nc = new NameCallback("User name: ");
            PasswordCallback pc = new PasswordCallback("Password: ", false);
            Callback[] callbacks = new Callback[]{nc, pc};
            try {
                handler.handle(callbacks);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new UserProfileException("Can't get user creds caused by " + e);
            }
            this.name_ = nc.getName();
            if (this.getName() == null || this.getName().trim().length() == 0) {
                throw new UserProfileException("Empty user name.");
            }
            if (!this.isUserId()) {
                this.password_ = new String(pc.getPassword());
                pc.clearPassword();
                if (this.password_ == null || this.password_.trim().length() == 0) {
                    throw new UserProfileException("Empty password.");
                }
            }
        }

        public boolean isUserId() {
            return this.name_.length() >= 4 ? this.name_.substring(0, 4).equals("urn:") : false;
        }

        public String getName() {
            return this.name_;
        }

        public String getUriName() {
            if (this.isUserId()) {
                return this.name_;
            }
            return "urn:" + this.name_.replace(' ', '_');
        }

        public static ByteBuffer getPasswordHash(String password) throws UserProfileException {
            if (password != null && password.length() > 0) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    return ByteBuffer.wrap(md.digest(password.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    log.error((Object)e);
                    throw new UserProfileException((Throwable)e);
                }
            }
            return null;
        }

        public void checkPasswordHash(ByteBuffer pwHash) throws UserProfileException {
            ByteBuffer testedHash = UserCreds.getPasswordHash(this.password_);
            if (!pwHash.position(0).equals(testedHash.position(0))) {
                throw new UserProfileAuthenticationException("Invalid password! User " + this.getName());
            }
        }
    }
}

