/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas.util;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;

public final class IdasUtils {
    private IdasUtils() {
    }

    private static Object getSVAttrValue(ISingleValuedAttribute attr) throws IdASException {
        IAttributeValue v;
        if (attr != null && (v = attr.getValue()) != null) {
            if (v.isSimple()) {
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                return sv.getData();
            }
            throw new IdASException("Attribute " + (attr.getAttrID() != null ? attr.getAttrID().toString() : "") + " contains non simple value");
        }
        return null;
    }

    public static Object getSimpleValueData(IHasAttributes ha, URI attribute) throws IdASException {
        ISingleValuedAttribute attr = ha.getSingleValuedAttribute(attribute);
        return IdasUtils.getSVAttrValue(attr);
    }

    public static ByteBuffer getSimpleValueDataAsByteBuffer(IHasAttributes ha, URI attribute) throws IdASException {
        return (ByteBuffer)IdasUtils.getSimpleValueData(ha, attribute);
    }

    public static byte[] getSimpleValueDataAsByteArray(IHasAttributes ha, URI attribure) throws IdASException {
        ByteBuffer bb = IdasUtils.getSimpleValueDataAsByteBuffer(ha, attribure);
        return bb != null && bb.hasArray() ? bb.array() : null;
    }

    public static void saveSimpleValueCollection(IAttribute att, Collection collection) throws IdASException {
        att.remove();
        if (collection != null && collection.size() > 0) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                att.addSimpleValue(ITypedValue.STRING_TYPE_URI, iterator.next());
            }
        }
    }

    public static List loadSimpleValueList(IAttribute att) throws IdASException {
        Iterator it;
        if (att != null && (it = att.getValues()).hasNext()) {
            ArrayList<Object> lst = new ArrayList<Object>();
            while (it.hasNext()) {
                lst.add(((ISimpleAttrValue)it.next()).getData());
            }
            return lst;
        }
        return null;
    }

    public static Set loadSimpleValueSet(IAttribute att) throws IdASException {
        Iterator it;
        if (att != null && (it = att.getValues()).hasNext()) {
            HashSet<Object> set = new HashSet<Object>();
            while (it.hasNext()) {
                set.add(((ISimpleAttrValue)it.next()).getData());
            }
            return set;
        }
        return null;
    }
}

