/** 
 * Copyright (c) 2007-2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */

package org.eclipse.higgins.userprofile.idas;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

public class CardUrlRelationBinding {
	private IContext ctx_;
	private IAttribute attCUR_;
	private IAttribute attUA_;
	private Set cardUrlRelationsAll_ = new HashSet(); //CardUrlRelation objects
	private Set oneCardUrlRelations_ = new HashSet();
	private Map useAlways = new HashMap(); //key is WebForm object and value is card cuid, ensures a site is used with only one card 
	private CUID cuid_ = null;
	
	private CardUsage cardUsageFromCUR(CardUrlRelation cur) {
		CardUsage cu = new CardUsage();
		cu.setCuid(cur.getCuid());
		cu.setForm(cur.getForm());
		cu.setDate(cur.getLastUsed());
		CUID thisSiteCard = (CUID) useAlways.get(cur.getForm());
		cu.setUseAlways(new Boolean(thisSiteCard != null && thisSiteCard.equals(cur.getCuid())));
		return cu;
	}

	public CardUrlRelationBinding(IEntity dsUserProfile) throws Exception {
		attCUR_ = dsUserProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
		attUA_ = dsUserProfile.getAttribute(IdasCtxUris.UP_useAlways);
		ctx_ = dsUserProfile.getContext();
		
		Iterator valsUA = attUA_.getValues();
		while (valsUA.hasNext()) {
			IAttributeValue valUA = (IAttributeValue) valsUA.next();
			if (!valUA.isSimple()) {
				WebForm wf = new WebForm();
				wf.setUrl((URI)IdasUtils.getSimpleValueData((IComplexAttrValue)valUA, IdasCtxUris.CU_url));
				wf.setFormAction((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valUA, IdasCtxUris.CU_formAction));
				wf.setFormId((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valUA, IdasCtxUris.CU_formId));
				wf.setFormName((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valUA, IdasCtxUris.CU_formName));
				useAlways.put(wf, new CUID((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valUA, IdasCtxUris.CC_cuid)));
			} else
				throw new UserProfileException("Complex value expected, but found " + attUA_.getModel().getType());
		}
		
		Iterator valsCUR = attCUR_.getValues();
		while (valsCUR.hasNext()) {
			IAttributeValue valCUR = (IAttributeValue) valsCUR.next();
			if (!valCUR.isSimple()) {
				CardUrlRelation cu = new CardUrlRelation();
				cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CC_cuid)));
				WebForm wf = new WebForm();
				wf.setUrl((URI)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_url));
				wf.setFormAction((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formAction));
				wf.setFormId((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formId));
				wf.setFormName((String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formName));
				cu.setForm(wf);
				cu.setLastUsed((Date) IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_lastUsed));
				IAttribute attOC = ((IComplexAttrValue) valCUR).getAttribute(IdasCtxUris.CU_optionalClaims);
				Set optionalClaims = new HashSet();
				for (Iterator it = attOC.getValues(); it.hasNext();) {
					IAttributeValue valOC = (IAttributeValue) it.next();
					if (valOC.isSimple())
						optionalClaims.add((String) ((ISimpleAttrValue) valOC).getData());
					else
						throw new UserProfileException("Simple value expected, but found " + attOC.getModel().getType());
				}
				if (optionalClaims.size() > 0)
					cu.setOptionalClaims(optionalClaims);
				
				cardUrlRelationsAll_.add(cu); //ensures uniqueness of the cuid+web form pair (see CardUrlRelation.hashCode() method)
			} else
				throw new UserProfileException("Complex value expected, but found " + attCUR_.getModel().getType());
		}
	}
	
	public CardUsage updateUsageSummary(CardUsage cardUsage) throws Exception {
		if (cardUsage.getCuid() == null || cardUsage.getForm() == null)
			throw new UserProfileException("Both cuid and form parameters must be set for usage summary");
		if (cardUsage.getForm().getUrl() == null)
			throw new UserProfileException("At least Web Form Url parameter must be set for usage summary");
		CardUrlRelation cuAdded = new CardUrlRelation();
		cuAdded.setCuid(cardUsage.getCuid());
		cuAdded.setForm(cardUsage.getForm());
		cuAdded.setLastUsed(cardUsage.getDate());
		
		if (cardUrlRelationsAll_.add(cuAdded)) {
			IComplexAttrValue valCUR = attCUR_.addComplexValue(null);
			valCUR.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, cuAdded.getCuid().toString());
			valCUR.getSingleValuedAttribute(IdasCtxUris.CU_url).addSimpleValue(null, cuAdded.getForm().getUrl());
			valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, cuAdded.getForm().getFormName());
			valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, cuAdded.getForm().getFormId());
			valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, cuAdded.getForm().getFormAction());
			valCUR.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, cuAdded.getLastUsed());
		} else { //there is already a record about the given cuid+form pair, so need to update it
			//TODO may be we might defer updating till end of work unit (finish()), so here just register changed item
			//implement when there will be statefullness
			for (Iterator it = cardUrlRelationsAll_.iterator(); it.hasNext();) {
				CardUrlRelation cur = (CardUrlRelation) it.next();
				if (cuAdded.equals(cur) && cuAdded.getLastUsed() != null) { //dont clear last used date WWM-893
					cur.setLastUsed(cuAdded.getLastUsed());
				}
			}
			Iterator valsCUR = attCUR_.getValues();
			CardUrlRelation cu = new CardUrlRelation();
			while (valsCUR.hasNext()) {
				IAttributeValue val = (IAttributeValue) valsCUR.next();
				if (!val.isSimple()) {
					cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CC_cuid)));
					WebForm wf = new WebForm((URI)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_url),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formName),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formId),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formAction));
					cu.setForm(wf);
					if (cuAdded.equals(cu) && cuAdded.getLastUsed() != null) { //found, than update, dont clear last used date WWM-893
						IComplexAttrValue cVal = (IComplexAttrValue) val; 
						cVal.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, cuAdded.getLastUsed());
						break;
					}
				} else {
					throw new UserProfileException("Complex value expected, but found " + attCUR_.getModel().getType());
				}
			}
		}
		
		if (cardUsage.getUseAlways() != null) {
			if (cardUsage.getUseAlways().booleanValue())
				useAlways.put(cuAdded.getForm(), cuAdded.getCuid());
			else
				useAlways.remove(cuAdded.getForm());
		}
		
		return cardUsage;
	}
	
	public void clearLastUsedDate() throws NotSingleValuedAttributeException, CardException, IdASException, UserProfileException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		//if UseAlways = false should also delete record
		Iterator it = oneCardUrlRelations_.iterator();
		while (it.hasNext()) {
			CardUrlRelation cu = (CardUrlRelation) it.next();
			cu.setLastUsed(null);
			CUID thisSiteCard = (CUID) useAlways.get(cu.getForm()); 
			if (thisSiteCard == null || !thisSiteCard.equals(cu.getCuid())) //cuid == null means UseAlways = false
				it.remove();
		}
		
		Iterator valsCUR = attCUR_.getValues();
		while (valsCUR.hasNext()) {
			IAttributeValue val = (IAttributeValue) valsCUR.next();
			if (!val.isSimple()) {
				if (cuid_.equals(new CUID((String)IdasUtils
						.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CC_cuid)))) {
					((IComplexAttrValue) val).getAttribute(IdasCtxUris.CU_lastUsed).remove();
					WebForm wf = new WebForm((URI)IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CU_url),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formName),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formId),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formAction));
					CUID thisSiteCard = (CUID) useAlways.get(wf);
					if (thisSiteCard == null || !thisSiteCard.equals(cuid_)) //cuid == null means UseAlways = false
						val.remove();
				}
			} else {
				throw new UserProfileException("Complex value expected, but found " + attCUR_.getModel().getType());
			}
		}
	}
	
	public void clearLastUsedDate(WebForm form) throws NotSingleValuedAttributeException, CardException, IdASException, UserProfileException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		CUID thisSiteCard = (CUID) useAlways.get(form);
		//if UseAlways = false should also delete record
		Iterator it = oneCardUrlRelations_.iterator();
		while (it.hasNext()) {
			CardUrlRelation cu = (CardUrlRelation) it.next();
			if (cu.getForm().equals(form)) {
				cu.setLastUsed(null);
				if (thisSiteCard == null || !thisSiteCard.equals(cuid_)) //cuid == null means UseAlways = false
					it.remove();
			}
		}
		
		Iterator valsCUR = attCUR_.getValues();
		while (valsCUR.hasNext()) {
			IAttributeValue val = (IAttributeValue) valsCUR.next();
			if (!val.isSimple()) {
				if (cuid_.equals(new CUID((String) IdasUtils
							.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CC_cuid)))
						&& form.equals(new WebForm((URI) IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_url),
								(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formName),
								(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formId),
								(String)IdasUtils.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CU_formAction)) )
					) {
					((IComplexAttrValue) val).getAttribute(IdasCtxUris.CU_lastUsed).remove();
					if (thisSiteCard == null || !thisSiteCard.equals(cuid_)) //cuid == null means UseAlways = false
						val.remove();
				}
			} else {
				throw new UserProfileException("Complex value expected, but found " + attCUR_.getModel().getType());
			}
		}
	}	
	
	public void clearUsedAlwaysURLs() throws UserProfileException, IdASException, CardException, IdASException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid()");
		
		for (Iterator it = useAlways.values().iterator(); it.hasNext();) {
			CUID cuid = (CUID) it.next();
			if (cuid.equals(cuid_))
				it.remove();
		} 
		
		/*Iterator valsCUR = attCUR_.getValues();
		while (valsCUR.hasNext()) {
			IAttributeValue val = (IAttributeValue) valsCUR.next();
			if (!val.isSimple()) {
				if (cuid_.equals(new CUID((String)IdasUtils
						.getSimpleValueData((IComplexAttrValue)val, IdasCtxUris.CC_cuid))))
					((IComplexAttrValue) val).getAttribute(IdasCtxUris.CU_useAlways).remove();
			} else {
				throw new UserProfileException("Complex value expected, but found " + val.getModel().getType());
			}
		}*/		
	}
	
	public void setCuid(CUID cuid) {
		if (cuid_ == null || !cuid_.equals(cuid)) {
			cuid_ = cuid;

			Iterator it = cardUrlRelationsAll_.iterator();
			oneCardUrlRelations_.clear();
			while (it.hasNext()) {
				CardUrlRelation cu = (CardUrlRelation) it.next();
				if (cuid_.equals(cu.getCuid()))
					oneCardUrlRelations_.add(cu);
			}
		}
	}
	

	public List getCardUsageSummary() throws UserProfileException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		List result = new ArrayList();
		for (Iterator it = oneCardUrlRelations_.iterator(); it.hasNext();) {
			result.add(cardUsageFromCUR((CardUrlRelation) it.next()));
		}
		return result;
	}
	
	public List getCardUsageSummary(int startFrom, int size, String orderBy, boolean desc) throws Exception {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		int fullSize = oneCardUrlRelations_.size();
		int to = startFrom + size;
		if (to > fullSize)
			to = fullSize;
		//WWM-1010 Method getCardUsageSummary() must return all cards history if "size" parameter is -1
		if (size == -1) { 
			startFrom = 0;
			to = fullSize;
		}
		
		List summaryList = getCardUsageSummary();
		Collections.sort(summaryList, new CardHistoryBinding.CardUsageComparator(orderBy, desc));
		return summaryList.subList(startFrom, to);
	}
	
	public int getTotalSize() throws UserProfileException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		return oneCardUrlRelations_.size();
	}
	
	public List getUsedCards(WebForm form) throws Exception {
		List result = new ArrayList();
		Iterator itCUs = cardUrlRelationsAll_.iterator();
		while (itCUs.hasNext()) {
			CardUrlRelation cur = (CardUrlRelation) itCUs.next();
			if (cur.getForm().equals(form))
				result.add(cardUsageFromCUR(cur));
		}
		return result;
	}
	
	public CUID getUsedAlwaysCard(WebForm form) {
		/*List summaryList = Arrays.asList(cardUrlRelationsAll_.toArray());
		Iterator itCUs = summaryList.iterator();
		while (itCUs.hasNext()) {
			CardUsage cu = (CardUsage) itCUs.next();
			if (cu.getSite().equals(uri) && cu.getUseAlways() != null 
					&& cu.getUseAlways().booleanValue())
				return cu.getCuid();
		}
		return null;*/
		return (CUID) useAlways.get(form);
	}
	
	public List getUsedAlwaysUrls() throws UserProfileException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		List result = new ArrayList();
		Iterator itCUR = oneCardUrlRelations_.iterator();
		while (itCUR.hasNext()) {
			CardUrlRelation cur = (CardUrlRelation) itCUR.next();
			CardUsage cu = cardUsageFromCUR(cur);
			if (cu.getUseAlways().booleanValue())
				result.add(cu);
		}
		return result;
	}

	public void finish() throws IdASException {
		attUA_.remove();
		for (Iterator it = useAlways.entrySet().iterator(); it.hasNext();) {
			Map.Entry e = (Map.Entry) it.next();
			IComplexAttrValue val = attUA_.addComplexValue(IdasCtxUris.UA_UseAlways);
			WebForm wf = (WebForm) e.getKey();
			val.getAttribute(IdasCtxUris.CU_url).addSimpleValue(null, wf.getUrl());
			val.getAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, e.getValue().toString());
			val.getAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, wf.getFormAction());
			val.getAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, wf.getFormId());
			val.getAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, wf.getFormName());
		}
	}

	public void setOptionalClaims(WebForm form, Set optionalClaims) throws Exception {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		if (oneCardUrlRelations_.size() == 0)
			updateUsageSummary(new CardUsage(cuid_, form, null, null));
		
		for (Iterator it = oneCardUrlRelations_.iterator(); it.hasNext();) {
			CardUrlRelation cur = (CardUrlRelation) it.next();
			if (cur.getForm().equals(form)) {
				cur.setOptionalClaims(optionalClaims);
				break;
			}
		}
		
		Iterator valsCUR = attCUR_.getValues();
		while (valsCUR.hasNext()) {
			IComplexAttrValue valCUR = (IComplexAttrValue) valsCUR.next();
			if ( ((String)IdasUtils.getSimpleValueData(valCUR, IdasCtxUris.CC_cuid)).equals(cuid_.toString()) &&
					form.equals(new WebForm((URI)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_url),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formName),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formId),
							(String)IdasUtils.getSimpleValueData((IComplexAttrValue)valCUR, IdasCtxUris.CU_formAction))) )  {
				IAttribute attOC = valCUR.getAttribute(IdasCtxUris.CU_optionalClaims);
				attOC.remove();
				for (Iterator it = optionalClaims.iterator(); it.hasNext();)
					attOC.addSimpleValue(ITypedValue.STRING_TYPE_URI, (String)it.next());
				break;
			}
		}
	}

	public Set getOptionalClaims(WebForm form) throws UserProfileException, IdASException {
		if (cuid_ == null)
			throw new UserProfileException("Card CUID must be set first. Call setCuid().");

		for (Iterator it = oneCardUrlRelations_.iterator(); it.hasNext();) {
			CardUrlRelation cur = (CardUrlRelation) it.next();
			if (cur.getForm().equals(form))
				return cur.getOptionalClaims();
		}
		return null;
	}

}
