/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

class CardHistoryBinding {
    private IContext ctx_;
    private IAttribute attCardUsage_;
    private List cardHistory_ = new ArrayList();
    private CUID cuid_;
    static /* synthetic */ Class class$org$eclipse$higgins$userprofile$entity$CardUsage;

    public CardHistoryBinding(IEntity dsUserProfile, CUID cuid) throws Exception {
        this.cuid_ = cuid;
        this.ctx_ = dsUserProfile.getContext();
        IAttribute attCCI = dsUserProfile.getAttribute(IdasCtxUris.UP_cardInformation);
        Iterator valsCCI = attCCI.getValues();
        IComplexAttrValue valCCI = null;
        while (valsCCI.hasNext()) {
            IAttributeValue val = (IAttributeValue)valsCCI.next();
            if (!val.isSimple()) {
                String cuidFound = (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CC_cuid);
                if (!cuidFound.equals(cuid.toString())) continue;
                valCCI = (IComplexAttrValue)val;
                break;
            }
            throw new UserProfileException("Complex value expected, but found " + attCCI.getModel().getType());
        }
        if (valCCI == null) {
            valCCI = attCCI.addComplexValue(null);
            valCCI.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuid.toString());
        }
        this.attCardUsage_ = valCCI.getAttribute(IdasCtxUris.CCI_cardUsage);
        Iterator valsCardUsage = this.attCardUsage_.getValues();
        while (valsCardUsage.hasNext()) {
            IAttributeValue val = (IAttributeValue)valsCardUsage.next();
            if (!val.isSimple()) {
                CardUsage cu = new CardUsage();
                cu.setCuid(cuid);
                cu.setForm(new WebForm(URI.create((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_CU_site)), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formAction)));
                cu.setDate((Date)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CCI_CU_date));
                this.cardHistory_.add(cu);
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attCardUsage_.getModel().getType());
        }
    }

    public CardUsage saveHistoryEvent(URI uri) throws Exception {
        CardUsage cardUsage = new CardUsage();
        cardUsage.setCuid(this.cuid_);
        cardUsage.setSite(uri);
        cardUsage.setDate(new Date());
        IComplexAttrValue valCU = this.attCardUsage_.addComplexValue(null);
        valCU.getSingleValuedAttribute(IdasCtxUris.CCI_CU_site).addSimpleValue(null, (Object)cardUsage.getSite().toString());
        valCU.getSingleValuedAttribute(IdasCtxUris.CCI_CU_date).addSimpleValue(null, (Object)cardUsage.getDate());
        return cardUsage;
    }

    public CardUsage saveHistoryEvent(WebForm form) throws Exception {
        CardUsage cardUsage = new CardUsage();
        cardUsage.setCuid(this.cuid_);
        cardUsage.setForm(form);
        cardUsage.setDate(new Date());
        IComplexAttrValue valCU = this.attCardUsage_.addComplexValue(null);
        valCU.getSingleValuedAttribute(IdasCtxUris.CCI_CU_site).addSimpleValue(null, (Object)cardUsage.getForm().getUrl().toString());
        valCU.getSingleValuedAttribute(IdasCtxUris.CCI_CU_date).addSimpleValue(null, (Object)cardUsage.getDate());
        valCU.getSingleValuedAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, (Object)cardUsage.getForm().getFormName());
        valCU.getSingleValuedAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, (Object)cardUsage.getForm().getFormId());
        valCU.getSingleValuedAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, (Object)cardUsage.getForm().getFormAction());
        return cardUsage;
    }

    public void clearHistory() throws IdASException {
        this.attCardUsage_.remove();
    }

    public List getCardHistory() {
        return this.cardHistory_;
    }

    public List getCardHistory(int startFrom, int size, String orderBy, boolean desc) throws Exception {
        int to = startFrom + size;
        int fullSize = this.cardHistory_.size();
        if (to > fullSize) {
            to = fullSize;
        }
        List historyList = this.getCardHistory();
        Collections.sort(historyList, new CardUsageComparator(orderBy, desc));
        return historyList.subList(startFrom, to);
    }

    public int getTotalSize() {
        return this.cardHistory_.size();
    }

    public void finish() throws IdASException {
        this.ctx_.applyUpdates();
        this.ctx_.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class CardUsageComparator
    implements Comparator {
        private String orderBy = null;
        private boolean desc = false;

        public CardUsageComparator(String orderBy, boolean desc) {
            this.orderBy = orderBy;
            this.desc = desc;
        }

        private void checkClassCast(Object cu1, Object cu2) {
            if (cu1.getClass() != (class$org$eclipse$higgins$userprofile$entity$CardUsage == null ? (class$org$eclipse$higgins$userprofile$entity$CardUsage = CardHistoryBinding.class$("org.eclipse.higgins.userprofile.entity.CardUsage")) : class$org$eclipse$higgins$userprofile$entity$CardUsage) | cu2.getClass() != (class$org$eclipse$higgins$userprofile$entity$CardUsage == null ? (class$org$eclipse$higgins$userprofile$entity$CardUsage = CardHistoryBinding.class$("org.eclipse.higgins.userprofile.entity.CardUsage")) : class$org$eclipse$higgins$userprofile$entity$CardUsage)) {
                throw new ClassCastException("Both arguments must be of type '" + (class$org$eclipse$higgins$userprofile$entity$CardUsage == null ? (class$org$eclipse$higgins$userprofile$entity$CardUsage = CardHistoryBinding.class$("org.eclipse.higgins.userprofile.entity.CardUsage")) : class$org$eclipse$higgins$userprofile$entity$CardUsage).getName() + "'");
            }
        }

        public int compare(Object arg0, Object arg1) {
            CardUsage cu2;
            CardUsage cu1;
            this.checkClassCast(arg0, arg1);
            if (!this.desc) {
                cu1 = (CardUsage)arg0;
                cu2 = (CardUsage)arg1;
            } else {
                cu2 = (CardUsage)arg0;
                cu1 = (CardUsage)arg1;
            }
            if (this.orderBy == "site") {
                return cu1.getForm().getUrl() == null && cu2.getForm().getUrl() == null ? 0 : (cu1.getForm().getUrl() == null ? -1 : (cu2.getForm().getUrl() == null ? 1 : cu1.getForm().getUrl().toString().compareTo(cu2.getForm().getUrl().toString())));
            }
            if (this.orderBy == "date") {
                return cu1.getDate() == null && cu2.getDate() == null ? 0 : (cu1.getDate() == null ? -1 : (cu2.getDate() == null ? 1 : cu1.getDate().compareTo(cu2.getDate())));
            }
            if (this.orderBy == "useAlways") {
                boolean b2;
                boolean b1 = cu1.getUseAlways() == null ? false : cu1.getUseAlways();
                boolean bl = b2 = cu2.getUseAlways() == null ? false : cu2.getUseAlways();
                return b1 == b2 ? 0 : (b1 ? 1 : -1);
            }
            return 0;
        }
    }
}

