/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.io.File;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.common.ProviderConfiguration;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IContextId;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IFilter;
import org.eclipse.higgins.idas.api.IFilterAssertion;
import org.eclipse.higgins.idas.api.IFilterAttributeAssertion;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.common.AuthNNamePasswordMaterials;
import org.eclipse.higgins.idas.registry.IdASRegistry;
import org.eclipse.higgins.idas.registry.contextid.ContextIdFactory;
import org.eclipse.higgins.idas.registry.discovery.FileDiscovery;
import org.eclipse.higgins.idas.registry.discovery.IDiscovery;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.userprofile.CategoryNotFoundException;
import org.eclipse.higgins.userprofile.ICardUsageManager;
import org.eclipse.higgins.userprofile.IUserProfileService;
import org.eclipse.higgins.userprofile.NoSuchEntityException;
import org.eclipse.higgins.userprofile.UserAlreadyExistsException;
import org.eclipse.higgins.userprofile.UserNotFoundException;
import org.eclipse.higgins.userprofile.UserProfileAuthenticationException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.WrongPasswordException;
import org.eclipse.higgins.userprofile.entity.Captcha;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.entity.Category;
import org.eclipse.higgins.userprofile.entity.PolicyVersion;
import org.eclipse.higgins.userprofile.entity.UserProfile;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.CardInformationBinding;
import org.eclipse.higgins.userprofile.idas.CardUsageManager;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

public class IdasBasedUserProfileService
implements IUserProfileService {
    private String IDAS_CONTEXT_ID = "idasContext.id";
    private String DISCOVERY_FILE = "idasDiscovery.filename";
    private String IDAS_USER_NAME = "idasUser.name";
    private String IDAS_USER_PASSWORD = "idasUser.password";
    private static Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$userprofile$idas$IdasBasedUserProfileService == null ? (class$org$eclipse$higgins$userprofile$idas$IdasBasedUserProfileService = IdasBasedUserProfileService.class$("org.eclipse.higgins.userprofile.idas.IdasBasedUserProfileService")) : class$org$eclipse$higgins$userprofile$idas$IdasBasedUserProfileService));
    private String id_ = "org.eclipse.higgins.userprofile.idas";
    private IConfiguration config_;
    private IdASRegistry registry_;
    private String sCtx;
    private IContextId ctxId;
    private String sUser;
    private String sPassword;
    private static ICache userProfileCache = CacheProviderFactory.getCacheProvider().getCache("UserProfile.UserProfiles");
    private static boolean isNoCache = userProfileCache instanceof NOCache;
    static /* synthetic */ Class class$org$eclipse$higgins$userprofile$idas$IdasBasedUserProfileService;

    private static String normalizeUserID(String userId) {
        return "urn:" + userId.replace(' ', '_');
    }

    private void loadConfig() throws IdASException {
        String sFactories = this.getConfiguration().getProperty(this.DISCOVERY_FILE, "contextfactories.xrds");
        FileDiscovery factories = new FileDiscovery(new File(sFactories));
        this.registry_ = IdASRegistry.getInstance();
        this.registry_.setDiscovery((IDiscovery)factories);
        this.sCtx = this.getConfiguration().getProperty(this.IDAS_CONTEXT_ID, "userProfileContext.xrds");
        this.ctxId = ContextIdFactory.fromString((String)this.sCtx);
        this.sUser = this.getConfiguration().getProperty(this.IDAS_USER_NAME, "testUser");
        this.sPassword = this.getConfiguration().getProperty(this.IDAS_USER_PASSWORD, "testPassword");
    }

    private IContext getContext() throws IdASException, UserProfileException {
        IContext ctx;
        if (this.registry_ == null) {
            this.loadConfig();
        }
        if ((ctx = this.registry_.createContext(this.ctxId)) == null) {
            throw new UserProfileException("User profile context not found with ID " + this.ctxId);
        }
        ctx.open((Object)new AuthNNamePasswordMaterials(ctx, this.sUser, this.sPassword));
        return ctx;
    }

    private IEntity authenticate(CallbackHandler handler) throws UserProfileException, IdASException {
        UserCreds uc = new UserCreds(handler);
        IContext ctx = this.getContext();
        IEntity dsUser = null;
        try {
            dsUser = ctx.getEntity(uc.getUriName());
        }
        catch (org.eclipse.higgins.idas.api.NoSuchEntityException e) {
            dsUser = null;
        }
        if (dsUser == null) {
            ctx.close();
            throw new UserNotFoundException("User Profile " + uc.getName() + " not found!");
        }
        if (!uc.isUserId()) {
            try {
                ByteBuffer newAuthHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
                if (newAuthHash != null && newAuthHash.hasArray()) {
                    try {
                        uc.checkPasswordHash(newAuthHash);
                    }
                    catch (UserProfileAuthenticationException e) {
                        uc.checkPasswordHash((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash));
                    }
                } else {
                    uc.checkPasswordHash((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash));
                }
            }
            catch (UserProfileException e) {
                ctx.close();
                throw e;
            }
        }
        return dsUser;
    }

    private IEntity getEntity(String userID) throws UserProfileException, IdASException {
        if (userID == null) {
            throw new UserProfileException("Parameter \"userID\" is null");
        }
        IContext ctx = this.getContext();
        IEntity dsUser = null;
        try {
            dsUser = ctx.getEntity(userID);
        }
        catch (org.eclipse.higgins.idas.api.NoSuchEntityException e) {
            dsUser = null;
        }
        if (dsUser == null) {
            ctx.close();
            throw new UserNotFoundException("User Profile " + userID + " not found!");
        }
        return dsUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserProfile loadUserProfile(String userID) throws UserProfileException, IdASException {
        IEntity ds = this.getEntity(userID);
        try {
            UserProfile up;
            UserProfile userProfile = up = this.initFromDS_UP(ds);
            return userProfile;
        }
        finally {
            ds.getContext().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserProfile(String userID) throws UserProfileException {
        UserProfile userProfile;
        String id = IdasBasedUserProfileService.normalizeUserID(userID);
        if (isNoCache) {
            return this.loadUserProfile(id);
        }
        UserCacheKey key = new UserCacheKey(id);
        if (userProfileCache.isKeyInCache((ICacheKey)key)) {
            CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
            UserProfile up = cached.userProfile;
            return up;
        }
        IEntity dsUser = this.getEntity(id);
        try {
            CachedItem cached = new CachedItem();
            cached.userProfile = this.initFromDS_UP(dsUser);
            cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
            cached.newPasswordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
            userProfileCache.put((ICacheKey)key, (Object)cached);
            userProfile = cached.userProfile;
        }
        catch (Throwable throwable) {
            try {
                dsUser.getContext().close();
                throw throwable;
            }
            catch (UserProfileAuthenticationException e) {
                log.error((Object)e, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        dsUser.getContext().close();
        return userProfile;
    }

    private IEntity authenticate(String userId, byte[] passwordIsapMd5) throws UserProfileException, IdASException {
        IContext ctx = this.getContext();
        IEntity dsUser = null;
        try {
            dsUser = ctx.getEntity("urn:" + userId.replace(' ', '_'));
        }
        catch (org.eclipse.higgins.idas.api.NoSuchEntityException e) {
            dsUser = null;
        }
        if (dsUser == null) {
            ctx.close();
            throw new UserNotFoundException("User Profile " + userId + " not found!");
        }
        ByteBuffer passwordIsapMd5stored = (ByteBuffer)IdasUtils.getSimpleValueData(dsUser, IdasCtxUris.UP_passwordIsapMd5);
        if (passwordIsapMd5stored != null && passwordIsapMd5stored.hasArray() && !passwordIsapMd5stored.position(0).equals(ByteBuffer.wrap(passwordIsapMd5).position(0))) {
            throw new WrongPasswordException("Invalid passwordIsapMd5! User " + userId);
        }
        return dsUser;
    }

    private void saveToDS_UP(UserProfile up, IEntity ds) throws Exception {
        try {
            ds.getAttribute(IdasCtxUris.UP_loginName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getLoginName());
            ds.getAttribute(IdasCtxUris.UP_firstName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getFirstName());
            ds.getAttribute(IdasCtxUris.UP_lastName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getLastName());
            ds.getAttribute(IdasCtxUris.UP_email).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getEmail());
            ds.getAttribute(IdasCtxUris.UP_modified).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)up.getModified());
            ds.getAttribute(IdasCtxUris.UP_status).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getStatus());
            ds.getAttribute(IdasCtxUris.UP_usedFrom).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getUsedFrom());
            ds.getAttribute(IdasCtxUris.UP_privateUserINumber).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getPrivateUserINumber());
            IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers), up.getPrivateSelectorINumbers());
            IdasUtils.saveComplexValueMap(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords), IdasCtxUris.OT_otpTimestamp, IdasCtxUris.OT_otpValue, up.getOneTimePasswords());
            IdasUtils.saveSimpleValueCollection(ds.getAttribute(IdasCtxUris.UP_blackListedSites), up.getBlackListedSites());
            ds.getAttribute(IdasCtxUris.UP_privateKey).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, up.getPrivateKey() == null ? null : ByteBuffer.wrap(up.getPrivateKey()));
            ds.getAttribute(IdasCtxUris.UP_passwordIsapMd5).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, up.getPasswordIsapMd5() == null ? null : ByteBuffer.wrap(up.getPasswordIsapMd5()));
            ds.getAttribute(IdasCtxUris.UP_sms).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getSms());
            ds.getAttribute(IdasCtxUris.UP_defaultPCardCUID).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getDefaultPCardCUID());
            ds.getAttribute(IdasCtxUris.UP_passphraseHash).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getPassphraseHash());
            ds.getAttribute(IdasCtxUris.UP_passwordResetCode).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)up.getPasswordResetCode());
            ds.getAttribute(IdasCtxUris.UP_resetCodeDate).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)up.getResetCodeDate());
        }
        catch (Exception e) {
            ds.getContext().cancelUpdates();
            throw e;
        }
    }

    private UserProfile initFromDS_UP(IEntity ds) throws UserProfileException, IdASException {
        UserProfile up = new UserProfile();
        up.setLoginName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_loginName));
        up.setFirstName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_firstName));
        up.setLastName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_lastName));
        up.setEmail((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_email));
        up.setCreated((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_created));
        up.setModified((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_modified));
        up.setStatus((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_status));
        up.setUsedFrom((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_usedFrom));
        up.setPrivateUserINumber((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_privateUserINumber));
        up.setPrivateSelectorINumbers(IdasUtils.loadSimpleValueList(ds.getAttribute(IdasCtxUris.UP_privateSelectorINumbers)));
        up.setOneTimePasswords(IdasUtils.loadComplexValueMap(ds.getAttribute(IdasCtxUris.UP_oneTimePasswords), IdasCtxUris.OT_otpTimestamp, IdasCtxUris.OT_otpValue));
        up.setBlackListedSites(IdasUtils.loadSimpleValueSet(ds.getAttribute(IdasCtxUris.UP_blackListedSites)));
        up.setPrivateKey(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_privateKey));
        up.setPasswordIsapMd5(IdasUtils.getSimpleValueDataAsByteArray((IHasAttributes)ds, IdasCtxUris.UP_passwordIsapMd5));
        up.setSms((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_sms));
        up.setDefaultPCardCUID((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_defaultPCardCUID));
        up.setPassphraseHash((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_passphraseHash));
        up.setPasswordResetCode((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_passwordResetCode));
        up.setResetCodeDate((Date)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.UP_resetCodeDate));
        up.setUserIdentifier(ds.getEntityID());
        return up;
    }

    private void saveToDS_cat(Category cat, IEntity ds) throws Exception {
        cat.setId(ds.getEntityID());
        ds.getAttribute(IdasCtxUris.CC_parentId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getParentId());
        ds.getAttribute(IdasCtxUris.CC_name).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getName());
        ds.getAttribute(IdasCtxUris.CC_icon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getIcon());
        ds.getAttribute(IdasCtxUris.CC_selectedIcon).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getSelectedIcon());
        ds.getAttribute(IdasCtxUris.CC_idx).addSimpleValue(ITypedValue.INTEGER_TYPE_URI, (Object)new Integer(cat.getIdx()));
        ds.getAttribute(IdasCtxUris.CC_type).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cat.getType());
        IAttribute attr = ds.getAttribute(IdasCtxUris.CC_cuid);
        attr.remove();
        if (cat.getCardList() != null && !cat.getCardList().isEmpty()) {
            Iterator iter = cat.getCardList().iterator();
            while (iter.hasNext()) {
                attr.addSimpleValue(ITypedValue.STRING_TYPE_URI, iter.next());
            }
        }
    }

    private Category initFromDS_cat(IEntity ds) throws UserProfileException, IdASException {
        Category cat = new Category();
        cat.setId(ds.getEntityID());
        cat.setParentId((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_parentId));
        cat.setName((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_name));
        cat.setIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_icon));
        cat.setSelectedIcon((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_selectedIcon));
        Integer idx = (Integer)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_idx);
        if (idx == null) {
            cat.setIdx(0);
        } else {
            cat.setIdx(idx.intValue());
        }
        cat.setType((String)IdasUtils.getSimpleValueData((IHasAttributes)ds, IdasCtxUris.CC_type));
        IAttribute att = ds.getAttribute(IdasCtxUris.CC_cuid);
        String cuid = null;
        ArrayList<String> cuids = new ArrayList<String>();
        if (att.getValues() != null) {
            Iterator iter = att.getValues();
            while (iter.hasNext()) {
                IAttributeValue v = (IAttributeValue)iter.next();
                if (!v.isSimple()) {
                    throw new UserProfileException("Attribute " + (att.getAttrID() != null ? att.getAttrID().toString() : "") + " contains non simple value");
                }
                ISimpleAttrValue sv = (ISimpleAttrValue)v;
                cuid = (String)sv.getData();
                cuids.add(cuid);
            }
        }
        cat.setCardList(cuids);
        return cat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile addUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException {
        try {
            UserCreds uc = new UserCreds(handler);
            if (this.userIdentifierExists(uc.getName())) {
                throw new UserAlreadyExistsException("User with identifier \"" + uc.getName() + "\" already exists!");
            }
            if (userProfile == null) {
                throw new IllegalArgumentException("Parameter \"userProfile\" is null");
            }
            IEntity ds = this.getContext().addEntity(IdasCtxUris.UP_UserProfile, uc.getUriName());
            try {
                if (ds == null) {
                    throw new UserProfileException("UserProfile not added.");
                }
                userProfile.setCreated(new Date());
                userProfile.setUserIdentifier(ds.getEntityID());
                ds.getAttribute(IdasCtxUris.UP_created).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)userProfile.getCreated());
                ds.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(uc.password_));
                this.saveToDS_UP(userProfile, ds);
                ds.getContext().applyUpdates();
            }
            finally {
                ds.getContext().close();
            }
            if (!isNoCache) {
                CachedItem cached = new CachedItem();
                cached.userProfile = userProfile;
                cached.passwordHash = UserCreds.getPasswordHash(uc.password_);
                UserCacheKey key = new UserCacheKey(uc.getUriName());
                userProfileCache.put((ICacheKey)key, (Object)cached);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUserProfile(CallbackHandler handler) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                this.deleteAllCategories(dsUser);
                dsUser.remove();
                dsUser.getContext().applyUpdates();
            }
            finally {
                dsUser.getContext().close();
            }
            if (!isNoCache) {
                UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                userProfileCache.remove((ICacheKey)key);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    private void deleteAllCategories(IEntity dsUser) throws IdASException, UserProfileException {
        IContext ctx = dsUser.getContext();
        IFilter filter = ctx.buildFilter();
        IFilterAttributeAssertion fas = ctx.buildAttributeAssertion();
        fas.includeSubtypes(true);
        fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
        fas.setID(IdasCtxUris.CC_userIdentifier);
        ISimpleAttrValue val = ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
        fas.setAssertionValue((IAttributeValue)val);
        filter.setAssertion((IFilterAssertion)fas);
        Iterator subjList = ctx.getEntities(filter);
        while (subjList.hasNext()) {
            IEntity subj = (IEntity)subjList.next();
            subj.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserProfile loadUserProfile(CallbackHandler handler) throws UserProfileException, IdASException {
        IEntity ds = this.authenticate(handler);
        try {
            UserProfile up;
            UserProfile userProfile = up = this.initFromDS_UP(ds);
            return userProfile;
        }
        finally {
            ds.getContext().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile getUserProfile(CallbackHandler handler) throws UserProfileException {
        UserProfile userProfile;
        if (isNoCache) {
            return this.loadUserProfile(handler);
        }
        UserCreds userCreds = new UserCreds(handler);
        UserCacheKey key = new UserCacheKey(userCreds.getUriName());
        if (userProfileCache.isKeyInCache((ICacheKey)key)) {
            CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
            UserProfile up = cached.userProfile;
            if (!userCreds.isUserId()) {
                if (cached.newPasswordHash != null) {
                    try {
                        userCreds.checkPasswordHash(cached.newPasswordHash);
                    }
                    catch (UserProfileAuthenticationException e) {
                        userCreds.checkPasswordHash(cached.passwordHash);
                    }
                } else {
                    userCreds.checkPasswordHash(cached.passwordHash);
                }
            }
            return up;
        }
        IEntity dsUser = this.authenticate(handler);
        try {
            CachedItem cached = new CachedItem();
            cached.userProfile = this.initFromDS_UP(dsUser);
            cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
            cached.newPasswordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
            userProfileCache.put((ICacheKey)key, (Object)cached);
            userProfile = cached.userProfile;
        }
        catch (Throwable throwable) {
            try {
                dsUser.getContext().close();
                throw throwable;
            }
            catch (UserProfileAuthenticationException e) {
                log.error((Object)e, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                return null;
            }
        }
        dsUser.getContext().close();
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile modifyUserProfile(CallbackHandler handler, UserProfile userProfile) throws UserProfileException {
        try {
            IEntity ds = this.authenticate(handler);
            try {
                if (userProfile == null) {
                    throw new IllegalArgumentException("Parameter \"userProfile\" can not be null");
                }
                userProfile.setModified(new Date());
                this.saveToDS_UP(userProfile, ds);
                ds.getContext().applyUpdates();
            }
            finally {
                ds.getContext().close();
            }
            if (!isNoCache) {
                UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                cached.userProfile = userProfile;
                userProfileCache.put((ICacheKey)key, (Object)cached);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserProfile modifyUserProfile(UserProfile userProfile) throws UserProfileException {
        try {
            String userId = userProfile.getUserIdentifier();
            IEntity ds = this.getEntity(userId);
            try {
                if (userProfile == null) {
                    throw new IllegalArgumentException("Parameter \"userProfile\" can not be null");
                }
                userProfile.setModified(new Date());
                this.saveToDS_UP(userProfile, ds);
                ds.getContext().applyUpdates();
            }
            finally {
                ds.getContext().close();
            }
            if (!isNoCache) {
                UserCacheKey key = new UserCacheKey(userId);
                CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                cached.userProfile = userProfile;
                userProfileCache.put((ICacheKey)key, (Object)cached);
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
        return userProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean userIdentifierExists(String userIdentifier) throws UserProfileException {
        IContext ctx = null;
        IEntity ds = null;
        try {
            try {
                ctx = this.getContext();
                ds = ctx.getEntity("urn:" + userIdentifier.replace(' ', '_'));
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
            return ds != null;
        }
        catch (org.eclipse.higgins.idas.api.NoSuchEntityException e) {
            return false;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public String resetPassword(CallbackHandler handler) throws UserProfileException {
        throw new UserProfileException("Not implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolveUserIdentifier(String privateSelectorINumber) throws UserProfileException {
        try {
            IContext ctx = this.getContext();
            try {
                IFilter filter = ctx.buildFilter();
                IFilterAttributeAssertion assertion = ctx.buildAttributeAssertion();
                assertion.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
                assertion.setID(IdasCtxUris.UP_privateSelectorINumbers);
                assertion.setAssertionValue((IAttributeValue)ctx.buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)privateSelectorINumber));
                filter.setAssertion((IFilterAssertion)assertion);
                Iterator it = ctx.getEntities(filter);
                if (!it.hasNext()) return null;
                IEntity e = (IEntity)it.next();
                String string = e.getEntityID().substring(4);
                return string;
            }
            finally {
                ctx.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category addCategory(CallbackHandler handler, Category category) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                if (category == null) {
                    throw new IllegalArgumentException("Parameter \"category\" is null");
                }
                IEntity ds = dsUser.getContext().addEntity(IdasCtxUris.CC_CardCategory, null);
                if (ds == null) {
                    throw new UserProfileException("Category " + category.getId() + " not added.");
                }
                ds.getAttribute(IdasCtxUris.CC_userIdentifier).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
                this.saveToDS_cat(category, ds);
                dsUser.getContext().applyUpdates();
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
        return category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCategory(CallbackHandler handler, String categoryId) throws UserProfileException {
        IContext ctx = null;
        try {
            try {
                if (categoryId == null || categoryId.trim().length() == 0) {
                    throw new IllegalArgumentException("Parameter \"categoryId\" is null");
                }
                ctx = this.authenticate(handler).getContext();
                IEntity ds = ctx.getEntity(categoryId);
                if (ds == null) {
                    throw new UserProfileException("Category \"" + categoryId + "\" not found");
                }
                ds.remove();
                ctx.applyUpdates();
            }
            catch (IdASException e) {
                try {
                    ctx.cancelUpdates();
                }
                catch (IdASException e1) {
                    log.error((Object)e1, (Throwable)e1);
                }
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
            throw throwable;
        }
        try {
            ctx.close();
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getCategories(CallbackHandler handler) throws UserProfileException {
        ArrayList<Category> arrayList;
        log.trace((Object)"IdasBasedUserProfileService.getCategories(CallbackHandler) started");
        IEntity dsUser = this.authenticate(handler);
        try {
            IFilter filter = dsUser.getContext().buildFilter();
            IFilterAttributeAssertion fas = dsUser.getContext().buildAttributeAssertion();
            fas.includeSubtypes(true);
            fas.setComparator("urn:org.eclipse.higgins.idas.api.comparator.attribute.equality");
            fas.setID(IdasCtxUris.CC_userIdentifier);
            ISimpleAttrValue val = dsUser.getContext().buildSimpleAttrValue(ITypedValue.STRING_TYPE_URI, (Object)dsUser.getEntityID());
            fas.setAssertionValue((IAttributeValue)val);
            filter.setAssertion((IFilterAssertion)fas);
            Iterator subjList = dsUser.getContext().getEntities(filter);
            ArrayList<Category> categories = new ArrayList<Category>();
            while (subjList.hasNext()) {
                IEntity subj = (IEntity)subjList.next();
                if (!IdasCtxUris.CC_CardCategory.equals(subj.getModel().getType())) continue;
                Category category = this.initFromDS_cat(subj);
                categories.add(category);
            }
            arrayList = categories;
        }
        catch (Throwable throwable) {
            try {
                dsUser.getContext().close();
                throw throwable;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        dsUser.getContext().close();
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Category modifyCategory(CallbackHandler handler, Category category) throws UserProfileException {
        Category category2;
        IEntity dsUser = this.authenticate(handler);
        try {
            if (category == null) {
                throw new IllegalArgumentException("Parameter \"category\" is null");
            }
            if (category.getId() == null || category.getId().trim().length() == 0) {
                throw new IllegalArgumentException("Category ID can not be null");
            }
            IEntity ds = dsUser.getContext().getEntity(category.getId());
            if (ds == null) {
                throw new CategoryNotFoundException("Category \"" + category.getId() + "\" not found!");
            }
            this.saveToDS_cat(category, ds);
            dsUser.getContext().applyUpdates();
            category2 = category;
        }
        catch (Throwable throwable) {
            try {
                dsUser.getContext().close();
                throw throwable;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        dsUser.getContext().close();
        return category2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CardInformation setCardCredential(CallbackHandler handler, CUID cuid, CardCredential cardCredential) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            if (cardCredential == null) {
                throw new IllegalArgumentException("Parameter \"cardCredential\" is null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CardInformationBinding cib = new CardInformationBinding(dsUser);
                try {
                    cib.saveCardCredential(cuid, cardCredential);
                    CardInformation ci = cib.getCardInformation(cuid);
                    cib.applyUpdates();
                    CardInformation cardInformation = ci;
                    return cardInformation;
                }
                catch (Exception e) {
                    cib.cancelUpdates();
                    throw e;
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CardInformation clearCardCredential(CallbackHandler handler, CUID cuid) throws UserProfileException {
        try {
            if (cuid == null) {
                throw new IllegalArgumentException("Parameter \"cuid\" is null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                CardInformationBinding cib = new CardInformationBinding(dsUser);
                try {
                    cib.deleteCardCredential(cuid);
                    CardInformation ci = cib.getCardInformation(cuid);
                    cib.applyUpdates();
                    CardInformation cardInformation = ci;
                    return cardInformation;
                }
                catch (Exception e) {
                    cib.cancelUpdates();
                    throw e;
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CardInformation getCardInformation(CallbackHandler handler, CUID cuid) throws UserProfileException {
        CardInformation cardInformation;
        if (cuid == null || cuid.toString().length() == 0) {
            throw new IllegalArgumentException("Card ID can not be null");
        }
        IEntity dsUser = this.authenticate(handler);
        try {
            CardInformationBinding cib = new CardInformationBinding(dsUser);
            CardInformation ci = cib.getCardInformation(cuid);
            dsUser.getContext().applyUpdates();
            cardInformation = ci;
        }
        catch (Throwable throwable) {
            try {
                dsUser.getContext().close();
                throw throwable;
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                throw new UserProfileException((Throwable)e);
            }
        }
        dsUser.getContext().close();
        return cardInformation;
    }

    public IConfiguration getConfiguration() {
        if (this.config_ == null) {
            this.config_ = new ProviderConfiguration(this.getID());
        }
        return this.config_;
    }

    public String getID() {
        return this.id_;
    }

    public void setID(String id) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ICardUsageManager getCardUsageManager(CallbackHandler handler) throws UserProfileException {
        IEntity dsUser = null;
        try {
            dsUser = this.authenticate(handler);
            try {
                return new CardUsageManager(dsUser);
            }
            catch (Exception e) {
                log.warn((Object)("Closing context of User " + dsUser.getEntityID() + ", in result of Exception:"));
                log.warn((Object)e);
                dsUser.getContext().close();
                log.warn((Object)("Context might be closed. User " + dsUser.getEntityID()));
                return null;
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolicyVersion getRPPolicyVersion(CallbackHandler handler, WebForm form) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                IComplexAttrValue valPV;
                WebForm wfFound;
                IAttribute attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                Iterator it = attPV.getValues();
                do {
                    if (!it.hasNext()) return null;
                } while (!(wfFound = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)(valPV = (IComplexAttrValue)it.next()), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction))).equals((Object)form));
                PolicyVersion pv = new PolicyVersion();
                pv.setForm(wfFound);
                pv.setPolicy(new String(((ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_policy)).array(), "UTF-8"));
                pv.setVersion((String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.PV_version));
                PolicyVersion policyVersion = pv;
                return policyVersion;
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRPPolicyVersion(CallbackHandler handler, PolicyVersion policyVersion) throws UserProfileException {
        try {
            if (policyVersion == null) {
                throw new IllegalArgumentException("Parameter \"policyVersion\" can not be null");
            }
            if (policyVersion.getForm() == null) {
                throw new IllegalArgumentException("Parameter \"policyVersion.webForm\" can not be null");
            }
            if (policyVersion.getPolicy() == null) {
                throw new IllegalArgumentException("Parameter \"policyVersion.policy\" can not be null");
            }
            if (policyVersion.getVersion() == null) {
                throw new IllegalArgumentException("Parameter \"policyVersion.version\" can not be null");
            }
            IEntity dsUser = this.authenticate(handler);
            try {
                IAttribute attPV = dsUser.getAttribute(IdasCtxUris.UP_policyVersion);
                Iterator it = attPV.getValues();
                while (it.hasNext()) {
                    IComplexAttrValue valPV = (IComplexAttrValue)it.next();
                    WebForm wfFound = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)valPV, IdasCtxUris.CU_formAction));
                    if (wfFound == null || !wfFound.equals((Object)policyVersion.getForm())) continue;
                    valPV.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                    valPV.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                    dsUser.getContext().applyUpdates();
                    return;
                }
                IComplexAttrValue valPV = attPV.addComplexValue(IdasCtxUris.PV_PolicyVersion);
                valPV.getAttribute(IdasCtxUris.CU_url).addSimpleValue(ITypedValue.ANYURI_TYPE_URI, (Object)policyVersion.getForm().getUrl());
                valPV.getAttribute(IdasCtxUris.CU_formAction).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormAction());
                valPV.getAttribute(IdasCtxUris.CU_formId).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormId());
                valPV.getAttribute(IdasCtxUris.CU_formName).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getForm().getFormName());
                valPV.getAttribute(IdasCtxUris.PV_policy).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)ByteBuffer.wrap(policyVersion.getPolicy().getBytes("UTF-8")));
                valPV.getAttribute(IdasCtxUris.PV_version).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)policyVersion.getVersion());
                dsUser.getContext().applyUpdates();
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewPassword(CallbackHandler handler, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                        cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                    }
                    cached.newPasswordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyPassword(String userId, String newPassword) throws UserProfileException {
        if (userId == null) {
            throw new UserProfileException("Parameter \"userId\" is null.");
        }
        String password = newPassword != null ? newPassword : "";
        String id = IdasBasedUserProfileService.normalizeUserID(userId);
        try {
            IEntity dsUser = this.getEntity(id);
            try {
                dsUser.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(password));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(id);
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                    }
                    cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewPasswordByPasswordIsapMd5(String userId, byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(userId, passwordIsapMd5);
            try {
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey("urn:" + userId.replace(' ', '_'));
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                        cached.passwordHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_authPasswordHash);
                    }
                    cached.newPasswordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteOldPassword(CallbackHandler handler) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(handler);
            try {
                ByteBuffer newAuthHash = (ByteBuffer)IdasUtils.getSimpleValueData((IHasAttributes)dsUser, IdasCtxUris.UP_newAuthPasswordHash);
                if (newAuthHash == null || !newAuthHash.hasArray()) {
                    throw new WrongPasswordException("Can not delete old password! Set the new one first!");
                }
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).remove();
                dsUser.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)newAuthHash);
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey(new UserCreds(handler).getUriName());
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = this.initFromDS_UP(dsUser);
                    }
                    cached.newPasswordHash = null;
                    cached.passwordHash = newAuthHash;
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (UserProfileAuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectorAndSetPasswordByPasswordIsapMd5(String userId, String privateSelectorINumber, byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
        try {
            IEntity dsUser = this.authenticate(userId, passwordIsapMd5);
            try {
                if (privateSelectorINumber == null) {
                    throw new IllegalArgumentException("Parameter \"privateSelectorINumber\" can not be null!");
                }
                if (newPassword == null) {
                    throw new IllegalArgumentException("Parameter \"newPassword\" can not be null!");
                }
                UserProfile up = this.initFromDS_UP(dsUser);
                ArrayList<String> listPSINum = up.getPrivateSelectorINumbers();
                if (listPSINum == null) {
                    listPSINum = new ArrayList<String>();
                }
                listPSINum.add(privateSelectorINumber);
                up.setPrivateSelectorINumbers(listPSINum);
                this.saveToDS_UP(up, dsUser);
                dsUser.getAttribute(IdasCtxUris.UP_newAuthPasswordHash).remove();
                dsUser.getAttribute(IdasCtxUris.UP_authPasswordHash).addSimpleValue(ITypedValue.BASE64BINARY_TYPE_URI, (Object)UserCreds.getPasswordHash(newPassword));
                dsUser.getContext().applyUpdates();
                if (!isNoCache) {
                    UserCacheKey key = new UserCacheKey("urn:" + userId.replace(' ', '_'));
                    CachedItem cached = (CachedItem)userProfileCache.get((ICacheKey)key);
                    if (cached == null) {
                        cached = new CachedItem();
                        cached.userProfile = up;
                    }
                    cached.newPasswordHash = null;
                    cached.passwordHash = UserCreds.getPasswordHash(newPassword);
                    userProfileCache.put((ICacheKey)key, (Object)cached);
                }
            }
            finally {
                dsUser.getContext().close();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public Captcha addCaptcha(Captcha captcha) throws UserProfileException {
        if (captcha == null) {
            throw new UserProfileException("Parameter \"captcha\" is null.");
        }
        if (captcha.getId() != null) {
            throw new UserProfileException("Passed captcha has been already stored.");
        }
        String cKey = captcha.getKey();
        if (cKey == null || cKey.trim().length() == 0) {
            throw new UserProfileException("Passed captcha contains no key.");
        }
        Date cDate = captcha.getDtCreation();
        if (cDate == null) {
            throw new UserProfileException("Passed captcha contains no creation date.");
        }
        IContext ctx = null;
        try {
            ctx = this.getContext();
            IEntity cEntity = ctx.addEntity(IdasCtxUris.UP_Captcha, null);
            cEntity.getAttribute(IdasCtxUris.UP_key).addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)cKey);
            cEntity.getAttribute(IdasCtxUris.UP_dtCreation).addSimpleValue(ITypedValue.DATETIME_TYPE_URI, (Object)cDate);
            ctx.applyUpdates();
            String newId = cEntity.getEntityID();
            captcha.setId(newId);
        }
        catch (IdASException e) {
            log.error((Object)e, (Throwable)e);
            this.cancelUpdates(ctx);
            throw new UserProfileException((Throwable)e);
        }
        finally {
            this.closeContext(ctx);
        }
        return captcha;
    }

    private void closeContext(IContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (IdASException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    private void cancelUpdates(IContext ctx) throws UserProfileException {
        try {
            if (ctx != null) {
                ctx.cancelUpdates();
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
    }

    public void deleteCaptcha(Captcha captcha) throws UserProfileException {
        if (captcha == null) {
            throw new UserProfileException("Parameter \"captcha\" is null.");
        }
        String id = captcha.getId();
        if (id != null) {
            IContext ctx = null;
            try {
                ctx = this.getContext();
                try {
                    IEntity cEntity = ctx.getEntity(id);
                    URI type = cEntity.getModel().getType();
                    if (!IdasCtxUris.UP_Captcha.equals(type)) {
                        throw new NoSuchEntityException("Entity with required ID has unexpected type " + type.toString());
                    }
                    cEntity.remove();
                }
                catch (org.eclipse.higgins.idas.api.NoSuchEntityException nee) {
                    log.error((Object)"Could not find IdAS entity by passed ID.", (Throwable)nee);
                    throw new NoSuchEntityException("Could not find IdAS entity by passed ID.");
                }
                ctx.applyUpdates();
            }
            catch (Exception e) {
                log.error((Object)e, (Throwable)e);
                this.cancelUpdates(ctx);
                throw new UserProfileException((Throwable)e);
            }
            finally {
                this.closeContext(ctx);
            }
        }
        throw new NoSuchEntityException("Passed captcha has no id.");
    }

    public Captcha getCaptcha(String captchaID) throws UserProfileException {
        if (captchaID == null) {
            throw new UserProfileException("Parameter \"captchaID\" is null.");
        }
        IContext ctx = null;
        try {
            ctx = this.getContext();
            IEntity cEntity = ctx.getEntity(captchaID);
            String id = cEntity.getEntityID();
            String key = (String)IdasUtils.getSimpleValueData((IHasAttributes)cEntity, IdasCtxUris.UP_key);
            Date dtCreation = (Date)IdasUtils.getSimpleValueData((IHasAttributes)cEntity, IdasCtxUris.UP_dtCreation);
            Captcha captcha = new Captcha();
            captcha.setDtCreation(dtCreation);
            captcha.setId(id);
            captcha.setKey(key);
            Captcha captcha2 = captcha;
            return captcha2;
        }
        catch (org.eclipse.higgins.idas.api.NoSuchEntityException nee) {
            log.error((Object)"Could not find IdAS entity by passed ID.", (Throwable)nee);
            throw new NoSuchEntityException("Could not find IdAS entity by passed ID.");
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
            throw new UserProfileException((Throwable)e);
        }
        finally {
            this.closeContext(ctx);
        }
    }

    public Captcha modifyCaptcha(Captcha captcha) throws UserProfileException {
        throw new UserProfileException("NOt implemented.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CachedItem {
        private UserProfile userProfile;
        private ByteBuffer passwordHash;
        private ByteBuffer newPasswordHash;

        private CachedItem() {
        }
    }

    private static class UserCreds {
        private String name_;
        private String password_;

        public UserCreds(CallbackHandler handler) throws UserProfileException {
            NameCallback nc = new NameCallback("User name: ");
            PasswordCallback pc = new PasswordCallback("Password: ", false);
            Callback[] callbacks = new Callback[]{nc, pc};
            try {
                handler.handle(callbacks);
            }
            catch (Exception e) {
                log.error((Object)e);
                throw new UserProfileAuthenticationException("Can't get user creds caused by " + e);
            }
            this.name_ = nc.getName();
            if (this.getName() == null || this.getName().trim().length() == 0) {
                throw new UserProfileAuthenticationException("Empty user name.");
            }
            if (!this.isUserId()) {
                this.password_ = new String(pc.getPassword());
                pc.clearPassword();
                if (this.password_ == null || this.password_.trim().length() == 0) {
                    throw new UserProfileAuthenticationException("Empty password.");
                }
            }
        }

        public boolean isUserId() {
            return this.name_.length() >= 4 ? this.name_.substring(0, 4).equals("urn:") : false;
        }

        public String getName() {
            return this.name_;
        }

        public String getUriName() {
            if (this.isUserId()) {
                return this.name_;
            }
            return IdasBasedUserProfileService.normalizeUserID(this.name_);
        }

        public static ByteBuffer getPasswordHash(String password) throws UserProfileException {
            if (password != null && password.length() > 0) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    return ByteBuffer.wrap(md.digest(password.getBytes("UTF-8")));
                }
                catch (Exception e) {
                    log.error((Object)e);
                    throw new UserProfileException((Throwable)e);
                }
            }
            return null;
        }

        public void checkPasswordHash(ByteBuffer pwHash) throws UserProfileException {
            ByteBuffer testedHash = UserCreds.getPasswordHash(this.password_);
            if (!pwHash.position(0).equals(testedHash.position(0))) {
                throw new WrongPasswordException("Invalid password! User " + this.getName());
            }
        }
    }
}

