/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.userprofile.idas;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IContext;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.WebForm;
import org.eclipse.higgins.userprofile.idas.CardHistoryBinding;
import org.eclipse.higgins.userprofile.idas.CardUrlRelation;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

public class CardUrlRelationBinding {
    private IContext ctx_;
    private IAttribute attCUR_;
    private IAttribute attUA_;
    private Set cardUrlRelationsAll_ = new HashSet();
    private Set oneCardUrlRelations_ = new HashSet();
    private Map useAlways = new HashMap();
    private CUID cuid_ = null;

    private CardUsage cardUsageFromCUR(CardUrlRelation cur) {
        CardUsage cu = new CardUsage();
        cu.setCuid(cur.getCuid());
        cu.setForm(cur.getForm());
        cu.setDate(cur.getLastUsed());
        CUID thisSiteCard = (CUID)this.useAlways.get(cur.getForm());
        cu.setUseAlways(new Boolean(thisSiteCard != null && thisSiteCard.equals((Object)cur.getCuid())));
        return cu;
    }

    public CardUrlRelationBinding(IEntity dsUserProfile) throws Exception {
        this.attCUR_ = dsUserProfile.getAttribute(IdasCtxUris.UP_cardUrlRelation);
        this.attUA_ = dsUserProfile.getAttribute(IdasCtxUris.UP_useAlways);
        this.ctx_ = dsUserProfile.getContext();
        Iterator valsUA = this.attUA_.getValues();
        while (valsUA.hasNext()) {
            IAttributeValue valUA = (IAttributeValue)valsUA.next();
            if (!valUA.isSimple()) {
                WebForm wf = new WebForm();
                wf.setUrl((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valUA), IdasCtxUris.CU_url));
                wf.setFormAction((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valUA), IdasCtxUris.CU_formAction));
                wf.setFormId((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valUA), IdasCtxUris.CU_formId));
                wf.setFormName((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valUA), IdasCtxUris.CU_formName));
                this.useAlways.put(wf, new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valUA), IdasCtxUris.CC_cuid)));
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attUA_.getModel().getType());
        }
        Iterator valsCUR = this.attCUR_.getValues();
        while (valsCUR.hasNext()) {
            IAttributeValue valCUR = (IAttributeValue)valsCUR.next();
            if (!valCUR.isSimple()) {
                CardUrlRelation cu = new CardUrlRelation();
                cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CC_cuid)));
                WebForm wf = new WebForm();
                wf.setUrl((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CU_url));
                wf.setFormAction((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CU_formAction));
                wf.setFormId((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CU_formId));
                wf.setFormName((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CU_formName));
                cu.setForm(wf);
                cu.setLastUsed((Date)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)valCUR), IdasCtxUris.CU_lastUsed));
                IAttribute attOC = ((IComplexAttrValue)valCUR).getAttribute(IdasCtxUris.CU_optionalClaims);
                HashSet<String> optionalClaims = new HashSet<String>();
                Iterator it = attOC.getValues();
                while (it.hasNext()) {
                    IAttributeValue valOC = (IAttributeValue)it.next();
                    if (valOC.isSimple()) {
                        optionalClaims.add((String)((ISimpleAttrValue)valOC).getData());
                        continue;
                    }
                    throw new UserProfileException("Simple value expected, but found " + attOC.getModel().getType());
                }
                if (optionalClaims.size() > 0) {
                    cu.setOptionalClaims(optionalClaims);
                }
                this.cardUrlRelationsAll_.add(cu);
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attCUR_.getModel().getType());
        }
    }

    public CardUsage updateUsageSummary(CardUsage cardUsage) throws Exception {
        if (cardUsage.getCuid() == null || cardUsage.getForm() == null) {
            throw new UserProfileException("Both cuid and form parameters must be set for usage summary");
        }
        if (cardUsage.getForm().getUrl() == null) {
            throw new UserProfileException("At least Web Form Url parameter must be set for usage summary");
        }
        CardUrlRelation cuAdded = new CardUrlRelation();
        cuAdded.setCuid(cardUsage.getCuid());
        cuAdded.setForm(cardUsage.getForm());
        cuAdded.setLastUsed(cardUsage.getDate());
        if (this.cardUrlRelationsAll_.add(cuAdded)) {
            IComplexAttrValue valCUR = this.attCUR_.addComplexValue(null);
            valCUR.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)cuAdded.getCuid().toString());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_url).addSimpleValue(null, (Object)cuAdded.getForm().getUrl());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, (Object)cuAdded.getForm().getFormName());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, (Object)cuAdded.getForm().getFormId());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, (Object)cuAdded.getForm().getFormAction());
            valCUR.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, (Object)cuAdded.getLastUsed());
        } else {
            Iterator it = this.cardUrlRelationsAll_.iterator();
            while (it.hasNext()) {
                CardUrlRelation cur = (CardUrlRelation)it.next();
                if (!cuAdded.equals(cur) || cuAdded.getLastUsed() == null) continue;
                cur.setLastUsed(cuAdded.getLastUsed());
            }
            Iterator valsCUR = this.attCUR_.getValues();
            CardUrlRelation cu = new CardUrlRelation();
            while (valsCUR.hasNext()) {
                IAttributeValue val = (IAttributeValue)valsCUR.next();
                if (!val.isSimple()) {
                    cu.setCuid(new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CC_cuid)));
                    WebForm wf = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formAction));
                    cu.setForm(wf);
                    if (!cuAdded.equals(cu) || cuAdded.getLastUsed() == null) continue;
                    IComplexAttrValue cVal = (IComplexAttrValue)val;
                    cVal.getSingleValuedAttribute(IdasCtxUris.CU_lastUsed).addSimpleValue(null, (Object)cuAdded.getLastUsed());
                    break;
                }
                throw new UserProfileException("Complex value expected, but found " + this.attCUR_.getModel().getType());
            }
        }
        if (cardUsage.getUseAlways() != null) {
            if (cardUsage.getUseAlways().booleanValue()) {
                this.useAlways.put(cuAdded.getForm(), cuAdded.getCuid());
            } else {
                this.useAlways.remove(cuAdded.getForm());
            }
        }
        return cardUsage;
    }

    public void clearLastUsedDate() throws NotSingleValuedAttributeException, CardException, IdASException, UserProfileException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        Iterator it = this.oneCardUrlRelations_.iterator();
        while (it.hasNext()) {
            CardUrlRelation cu = (CardUrlRelation)it.next();
            cu.setLastUsed(null);
            CUID thisSiteCard = (CUID)this.useAlways.get(cu.getForm());
            if (thisSiteCard != null && thisSiteCard.equals((Object)cu.getCuid())) continue;
            it.remove();
        }
        Iterator valsCUR = this.attCUR_.getValues();
        while (valsCUR.hasNext()) {
            IAttributeValue val = (IAttributeValue)valsCUR.next();
            if (!val.isSimple()) {
                if (!this.cuid_.equals((Object)new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CC_cuid)))) continue;
                ((IComplexAttrValue)val).getAttribute(IdasCtxUris.CU_lastUsed).remove();
                WebForm wf = new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formAction));
                CUID thisSiteCard = (CUID)this.useAlways.get(wf);
                if (thisSiteCard != null && thisSiteCard.equals((Object)this.cuid_)) continue;
                val.remove();
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attCUR_.getModel().getType());
        }
    }

    public void clearLastUsedDate(WebForm form) throws NotSingleValuedAttributeException, CardException, IdASException, UserProfileException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        CUID thisSiteCard = (CUID)this.useAlways.get(form);
        Iterator it = this.oneCardUrlRelations_.iterator();
        while (it.hasNext()) {
            CardUrlRelation cu = (CardUrlRelation)it.next();
            if (!cu.getForm().equals((Object)form)) continue;
            cu.setLastUsed(null);
            if (thisSiteCard != null && thisSiteCard.equals((Object)this.cuid_)) continue;
            it.remove();
        }
        Iterator valsCUR = this.attCUR_.getValues();
        while (valsCUR.hasNext()) {
            IAttributeValue val = (IAttributeValue)valsCUR.next();
            if (!val.isSimple()) {
                if (!this.cuid_.equals((Object)new CUID((String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CC_cuid))) || !form.equals((Object)new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)((IComplexAttrValue)val), IdasCtxUris.CU_formAction)))) continue;
                ((IComplexAttrValue)val).getAttribute(IdasCtxUris.CU_lastUsed).remove();
                if (thisSiteCard != null && thisSiteCard.equals((Object)this.cuid_)) continue;
                val.remove();
                continue;
            }
            throw new UserProfileException("Complex value expected, but found " + this.attCUR_.getModel().getType());
        }
    }

    public void clearUsedAlwaysURLs() throws UserProfileException, IdASException, CardException, IdASException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid()");
        }
        Iterator it = this.useAlways.values().iterator();
        while (it.hasNext()) {
            CUID cuid = (CUID)it.next();
            if (!cuid.equals((Object)this.cuid_)) continue;
            it.remove();
        }
    }

    public void setCuid(CUID cuid) {
        if (this.cuid_ == null || !this.cuid_.equals((Object)cuid)) {
            this.cuid_ = cuid;
            Iterator it = this.cardUrlRelationsAll_.iterator();
            this.oneCardUrlRelations_.clear();
            while (it.hasNext()) {
                CardUrlRelation cu = (CardUrlRelation)it.next();
                if (!this.cuid_.equals((Object)cu.getCuid())) continue;
                this.oneCardUrlRelations_.add(cu);
            }
        }
    }

    public List getCardUsageSummary() throws UserProfileException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        Iterator it = this.oneCardUrlRelations_.iterator();
        while (it.hasNext()) {
            result.add(this.cardUsageFromCUR((CardUrlRelation)it.next()));
        }
        return result;
    }

    public List getCardUsageSummary(int startFrom, int size, String orderBy, boolean desc) throws Exception {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        int to = startFrom + size;
        int fullSize = this.oneCardUrlRelations_.size();
        if (to > fullSize) {
            to = fullSize;
        }
        if (size == -1) {
            startFrom = 0;
            to = fullSize;
        }
        List summaryList = this.getCardUsageSummary();
        Collections.sort(summaryList, new CardHistoryBinding.CardUsageComparator(orderBy, desc));
        return summaryList.subList(startFrom, to);
    }

    public int getTotalSize() throws UserProfileException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        return this.oneCardUrlRelations_.size();
    }

    public List getUsedCards(WebForm form) throws Exception {
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        Iterator itCUs = this.cardUrlRelationsAll_.iterator();
        while (itCUs.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)itCUs.next();
            if (!cur.getForm().equals((Object)form)) continue;
            result.add(this.cardUsageFromCUR(cur));
        }
        return result;
    }

    public CUID getUsedAlwaysCard(WebForm form) {
        return (CUID)this.useAlways.get(form);
    }

    public List getUsedAlwaysUrls() throws UserProfileException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        ArrayList<CardUsage> result = new ArrayList<CardUsage>();
        Iterator itCUR = this.oneCardUrlRelations_.iterator();
        while (itCUR.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)itCUR.next();
            CardUsage cu = this.cardUsageFromCUR(cur);
            if (!cu.getUseAlways().booleanValue()) continue;
            result.add(cu);
        }
        return result;
    }

    public void finish() throws IdASException {
        this.attUA_.remove();
        Iterator it = this.useAlways.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            IComplexAttrValue val = this.attUA_.addComplexValue(IdasCtxUris.UA_UseAlways);
            WebForm wf = (WebForm)e.getKey();
            val.getAttribute(IdasCtxUris.CU_url).addSimpleValue(null, (Object)wf.getUrl());
            val.getAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, (Object)e.getValue().toString());
            val.getAttribute(IdasCtxUris.CU_formAction).addSimpleValue(null, (Object)wf.getFormAction());
            val.getAttribute(IdasCtxUris.CU_formId).addSimpleValue(null, (Object)wf.getFormId());
            val.getAttribute(IdasCtxUris.CU_formName).addSimpleValue(null, (Object)wf.getFormName());
        }
    }

    public void setOptionalClaims(WebForm form, Set optionalClaims) throws Exception {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        if (this.oneCardUrlRelations_.size() == 0) {
            this.updateUsageSummary(new CardUsage(this.cuid_, form, null, null));
        }
        Iterator it = this.oneCardUrlRelations_.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cur.getForm().equals((Object)form)) continue;
            cur.setOptionalClaims(optionalClaims);
            break;
        }
        Iterator valsCUR = this.attCUR_.getValues();
        while (valsCUR.hasNext()) {
            IComplexAttrValue valCUR = (IComplexAttrValue)valsCUR.next();
            if (!((String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CC_cuid)).equals(this.cuid_.toString()) || !form.equals((Object)new WebForm((URI)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_url), (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formName), (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formId), (String)IdasUtils.getSimpleValueData((IHasAttributes)valCUR, IdasCtxUris.CU_formAction)))) continue;
            IAttribute attOC = valCUR.getAttribute(IdasCtxUris.CU_optionalClaims);
            attOC.remove();
            Iterator it2 = optionalClaims.iterator();
            while (it2.hasNext()) {
                attOC.addSimpleValue(ITypedValue.STRING_TYPE_URI, (Object)((String)it2.next()));
            }
            break block1;
        }
    }

    public Set getOptionalClaims(WebForm form) throws UserProfileException, IdASException {
        if (this.cuid_ == null) {
            throw new UserProfileException("Card CUID must be set first. Call setCuid().");
        }
        Iterator it = this.oneCardUrlRelations_.iterator();
        while (it.hasNext()) {
            CardUrlRelation cur = (CardUrlRelation)it.next();
            if (!cur.getForm().equals((Object)form)) continue;
            return cur.getOptionalClaims();
        }
        return null;
    }
}

