/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.userprofile.idas;

import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.cache.CacheException;
import org.eclipse.higgins.cache.CacheProviderFactory;
import org.eclipse.higgins.cache.api.ICache;
import org.eclipse.higgins.cache.api.ICacheKey;
import org.eclipse.higgins.cache.api.key.UserCacheKey;
import org.eclipse.higgins.cache.nocache.NOCache;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.icard.CardException;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IEntity;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.idas.util.IdasCtxUris;
import org.eclipse.higgins.userprofile.idas.util.IdasUtils;

/**
 * @author PilipenkoYN
 *
 */
class CardInformationBinding {
	private IEntity dsUser = null;
	private IAttribute attCardinfo = null;
	
	private static Log log = LogFactory.getLog(CardInformationBinding.class);
	private static ICache	cardInfoCache	= CacheProviderFactory.getCacheProvider().getCache(
													"UserProfile.CardInformation");
	private static boolean isNoCache = cardInfoCache instanceof NOCache;

	/**
	 * Loads all CardInformationEntities of current user and put them in cache. 
	 * @param dsUserProfile
	 * @param cardInformationBinding
	 * @throws Exception sdfsdf
	 */
	private void ensureInCache() throws Exception {
		if (isNoCache) {
			return;
		}
		
		ICacheKey key = new UserCacheKey(dsUser.getEntityID());

		if (!cardInfoCache.isKeyInCache(key)) {
			log.info("Load All CardInformation by userID:" + key.getKey().toString());

			Set cardInformationSet = new HashSet();
			Iterator valsCCI = attCardinfo.getValues();
			while (valsCCI.hasNext()) {
				IAttributeValue val = (IAttributeValue) valsCCI.next();
				if (!val.isSimple()) {
					// add cardInformation to cache
					CardInformation cardInformation = new CardInformation();
					loadCardInformation((IComplexAttrValue) val, cardInformation);
					cardInformationSet.add(cardInformation);
				} else {
					log.error("Complex value expected, but found " + attCardinfo.getModel().getType());
				}
			}
			cardInfoCache.put(key, cardInformationSet);
			log.info(key.getKey().toString() + " card info cached.");
		}
	}	
	
	private IComplexAttrValue getValCardInfo(final CUID cuid) throws IdASException, UserProfileException {
		Iterator valsCCI = attCardinfo.getValues();
		IComplexAttrValue res = null;
		while (valsCCI.hasNext()) {
			IAttributeValue val = (IAttributeValue) valsCCI.next();
			if (!val.isSimple()) {
				String cuidFound = (String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CC_cuid);
				if (cuidFound.equals(cuid.toString())) {
					res = (IComplexAttrValue) val;
					break;
				}
			} else {
				throw new UserProfileException("Complex value expected, but found " + attCardinfo.getModel().getType());
			}
		}
		if (res == null) {
			res = attCardinfo.addComplexValue(null);
			res.getAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, cuid.toString());
		}
		return res;
	}
	
	private void loadCardInfoByCUID(final CUID cuid, final CardInformation cardInfo) throws IdASException, UserProfileException, CardException {
		IComplexAttrValue val = getValCardInfo(cuid);
		if (val != null) {
			loadCardInformation(val, cardInfo);
		}
	}
	
	private void loadCardInformation(final IComplexAttrValue valCardInfo, final CardInformation cardInfo) throws UserProfileException, IdASException, CardException {
		cardInfo.setCuid(new CUID((String) IdasUtils.getSimpleValueData(valCardInfo, IdasCtxUris.CC_cuid)));
		//loadUrls(valCardInfo, cardInfo);
		loadCardCredential(valCardInfo, cardInfo);
		//return cardInfo;
	}
	
	private void loadCardCredential(final IComplexAttrValue valCardInfo, final CardInformation cardInfo) throws IdASException, UserProfileException {
		ISingleValuedAttribute attCardCred = valCardInfo.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
		IAttributeValue val = attCardCred.getValue();
		if (val != null) {
			CardCredential cc = new CardCredential();
			cc.setCredentialType((String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CCI_SC_type));
			cc.setTsAddress((String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CCI_SC_tsAddress));
			cc.setTsMetadataAddress((String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CCI_SC_tsMetadataAddress));
			cc.setUsername((String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.UP_loginName));
			cc.setPassword((String) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.UP_password));
			ByteBuffer bb = (ByteBuffer) IdasUtils.getSimpleValueData((IComplexAttrValue) val, IdasCtxUris.CCI_SC_pinCode);
			cc.setPinCode(bb == null ? null : (bb.hasArray() ? bb.array() : null));
			cardInfo.setCardCredential(cc);
		} else {
			cardInfo.setCardCredential(null);
		}
	}
	
	private void saveCardCredential(final IComplexAttrValue valCardInfo, final CardInformation cardInfo) throws IdASException, UserProfileException {
		CardCredential cardCredential = cardInfo.getCardCredential();
		if (cardCredential == null) {
			return;
		}
		
		ISingleValuedAttribute attCardCred = valCardInfo.getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
		IAttributeValue val = attCardCred.getValue();
		if (val == null) {
			val = attCardCred.addComplexValue(null);
		}
		IComplexAttrValue valCC;
		if (!val.isSimple()) {
			valCC = (IComplexAttrValue) val;
		} else {
			throw new UserProfileException("Complex value expected, but found " + attCardCred.getModel().getType());
		}

		valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_type).addSimpleValue(null, cardCredential.getCredentialType());
		valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsAddress).addSimpleValue(null, cardCredential.getTsAddress());
		valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_tsMetadataAddress)
				.addSimpleValue(null, cardCredential.getTsMetadataAddress());
		valCC.getSingleValuedAttribute(IdasCtxUris.UP_loginName).addSimpleValue(null, cardCredential.getUsername());
		valCC.getSingleValuedAttribute(IdasCtxUris.UP_password).addSimpleValue(null, cardCredential.getPassword());
		valCC.getSingleValuedAttribute(IdasCtxUris.CCI_SC_pinCode).addSimpleValue(null,
				cardCredential.getPinCode() == null ? null : ByteBuffer.wrap(cardCredential.getPinCode()));
	}
	
	
	private Set getCachedCardInformationSet(final String userId) {
		ICacheKey key = new UserCacheKey(userId);
		if (cardInfoCache.isKeyInCache(key)) {
			return (Set) cardInfoCache.get(key);
		}
		return null;
	}
	
	private CardInformation getCachedCardInformation(final CUID cuid) throws UserProfileException, IdASException, MalformedURLException {
		try {
			ensureInCache();
			Set cardInformationSet = getCachedCardInformationSet(dsUser.getEntityID());

			if (cardInformationSet != null) { //hit in cache
				if (cuid != null) {
					for (Iterator iterator = cardInformationSet.iterator(); iterator.hasNext();) {
						CardInformation cardInformationItem = (CardInformation) iterator.next();
						if (cuid.equals(cardInformationItem.getCuid())) {
							return cardInformationItem;
						}
					}
				}
			} else {
				CardInformation ci = new CardInformation();
				ci.setCuid(cuid);
				return ci;
			}

		/*			// not found by CUID
					//dsUserProfile
					valCardInfo = dsUser_.getAttribute(IdasCtxUris.UP_cardInformation).addComplexValue(null);
					valCardInfo.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, cardInfo.getCuid().toString());
					return cardInfo;
					
				} else if (cardInfo.getUrls() != null && cardInfo.getUrls().length == 1) {
					URL url = cardInfo.getUrls()[0];

					for (Iterator iterator = cardInformationSet.iterator(); iterator.hasNext();) {
						CardInformation cardInformationItem = (CardInformation) iterator.next();
						URL[] urls = cardInformationItem.getUrls();
						if (urls != null) {
							for (int i = 0; i < urls.length; i++) {
								if (urls[i].equals(url)) {
									return cardInformationItem;
								}
							}
						}
					}*/
		} catch (Exception e) {
			log.error("Errors :", e);
		}
		return null;		
	}
	
	
	public CardInformationBinding(final IEntity dsUserProfile) throws Exception {
		dsUser = dsUserProfile;
		attCardinfo = dsUser.getAttribute(IdasCtxUris.UP_cardInformation); 
		
		ensureInCache();		
	}

/*	public CardInformationBinding(IEntity dsUserProfile, URL url) throws Exception {
		this.cardInfo = new CardInformation();
		this.dsUser_ = dsUserProfile;
		// TODO - make another methods for init by Url or Cuid, not constructors
		this.byUrl = true;

		if (url == null)
			throw new IllegalArgumentException("Parameter \"url\" is null");
		IAttribute attCardInfo = dsUserProfile.getAttribute(IdasCtxUris.UP_cardInformation);
		Iterator valsCCI = attCardInfo.getValues();
		while (valsCCI.hasNext()) {
			IAttributeValue val = (IAttributeValue) valsCCI.next();
			if (!val.isSimple()) {
				IAttribute attUrls = ((IComplexAttrValue) val).getAttribute(IdasCtxUris.CCI_SC_urls);
				Iterator valsUrl = attUrls.getValues();
				while (valsUrl.hasNext()) {
					ISimpleAttrValue valUrl = (ISimpleAttrValue) valsUrl.next();
					if (((String) valUrl.getData()).equals(url.toString())) {
						valCardInfo = (IComplexAttrValue) val;
						break;
					}
				}
			} else {
				throw new UserProfileException("Complex value expected, but found " + val.getModel().getType());
			}
		}
		if (valCardInfo == null)
			throw new UserProfileException("Card info not found by URL " + url);

		String cuid = (String) IdasUtils.getSimpleValueData(valCardInfo, IdasCtxUris.CC_cuid);
		cardInfo.setCuid(new CUID(cuid));
		//cardInfo.setUrls(new URL[] { url });
	}
*/
	
	public CardInformation getCardInformation(final CUID cuid) throws UserProfileException, IdASException,
			MalformedURLException, CardException {
		if (isNoCache) { // get from Idas
			CardInformation result = new CardInformation();
			result.setCuid(cuid);
			loadCardInfoByCUID(cuid, result);
			return result;
		} else {
			return getCachedCardInformation(cuid);
		}
		
		
/*		Set cardInformationSet = getCachedCardInformationSet(this.dsUser_.getEntityID());
		if (cardInformationSet != null) {
			for (Iterator iterator = cardInformationSet.iterator(); iterator.hasNext();) {
				CardInformation cardInformationItem = (CardInformation) iterator.next();
				if (cuid.equals(cardInformationItem.getCuid())) {
					// cardInformation was found, load for modify
					loadCardInfoByCUID(dsUserProfile.getAttribute(IdasCtxUris.UP_cardInformation), cuid);
					break;
				}
			}
		} else { 
			// cache is empty probably due to NOCacheProvider
			// load for modify
			loadCardInfoByCUID(dsUserProfile.getAttribute(IdasCtxUris.UP_cardInformation), cuid);
		}

		if (this.valCardInfo == null) {
			// cardInformation is not exist, create new one
			this.valCardInfo = dsUserProfile.getAttribute(IdasCtxUris.UP_cardInformation).addComplexValue(null);
			this.valCardInfo.getSingleValuedAttribute(IdasCtxUris.CC_cuid).addSimpleValue(null, cuid.toString());
		}

		this.cardInfo.setCuid(cuid);		
		
		if (!byUrl)
			loadUrls();
		
		loadCardCredential();*/
	}
	
/*	private void loadUrls(IComplexAttrValue valCardInfo, CardInformation cardInfo) throws UserProfileException, IdASException, MalformedURLException {
		try {
			IAttribute attUrls = valCardInfo.getAttribute(IdasCtxUris.CCI_SC_urls);
			Iterator valsUrl = attUrls.getValues();
			List lUrls = new ArrayList();
			while (valsUrl.hasNext()) {
				IAttributeValue val = (IAttributeValue) valsUrl.next();
				if (val.isSimple()) {
					ISimpleAttrValue sv = (ISimpleAttrValue) val;
					lUrls.add(new URL((String) sv.getData()));
				} else
					throw new UserProfileException("Attribute " + (attUrls.getAttrID() != null ? attUrls.getAttrID().toString() : "")
							+ " contains non simple value");
			}
			if (lUrls.size() > 0) {
				URL[] urls = new URL[lUrls.size()];
				lUrls.toArray(urls);

				cardInfo.setUrls(urls);
			} else
				cardInfo.setUrls(null);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
*/
/*	private void loadUrls() throws UserProfileException, IdASException, MalformedURLException {
		loadUrls(this.valCardInfo, this.cardInfo);
	}
*/

/*	private void loadCardCredential() throws IdASException, UserProfileException {
		loadCardCredential(this.valCardInfo, this.cardInfo);
	}
*/	

	
	private void updateCachedCardInformation(final CardInformation cardInfo) throws IdASException {
		try {
			Set cardInformationSet = getCachedCardInformationSet(dsUser.getEntityID());
			if (cardInformationSet != null) {
				if (cardInformationSet.contains(cardInfo)) {
					cardInformationSet.remove(cardInfo);
				}
				cardInformationSet.add(cardInfo);
				cardInfoCache.update(new UserCacheKey(dsUser.getEntityID()), cardInformationSet);
			}
		} catch (CacheException e) {
			log.error(e);
		}
	}

/*	public void saveUrls(URL[] urls) throws IdASException {
		IAttribute attUrls = valCardInfo.getAttribute(IdasCtxUris.CCI_SC_urls);
		attUrls.remove();
		if (urls != null && urls.length > 0)
			for (int i = 0; i < urls.length; i++) {
				attUrls.addSimpleValue(null, urls[i]);
			}
	}

	public void saveUrl(URL url) throws IdASException {
		IAttribute attUrls = valCardInfo.getAttribute(IdasCtxUris.CCI_SC_urls);
		attUrls.addSimpleValue(null, url.toString());
	}

	public void deleteUrl(URL url) throws IdASException {
		IAttribute attUrls = valCardInfo.getAttribute(IdasCtxUris.CCI_SC_urls);
		Iterator valsUrl = attUrls.getValues();
		while (valsUrl.hasNext()) {
			ISimpleAttrValue valUrl = (ISimpleAttrValue) valsUrl.next();
			String urlToDel = (String) valUrl.getData();
			if (urlToDel.equals(url.toString())) {
				valUrl.remove();
			}
		}
	}

	public void deleteUrls(URL[] urls) throws IdASException {
		IAttribute attUrls = valCardInfo.getAttribute(IdasCtxUris.CCI_SC_urls);
		Iterator valsUrl = attUrls.getValues();

		List list = new ArrayList();
		for (int i = 0; i < urls.length; i++)
			list.add(urls[i].toString());

		while (valsUrl.hasNext()) {
			ISimpleAttrValue valUrl = (ISimpleAttrValue) valsUrl.next();
			String urlToDel = (String) valUrl.getData();
			if (list.contains(urlToDel)) {
				valUrl.remove();
			}
		}
	}
*/
	
	public void saveCardCredential(final CUID cuid, final CardCredential cardCredential) throws InvalidTypeException,
			NotSingleValuedAttributeException, IdASException, UserProfileException {
		CardInformation cardInfo = new CardInformation();
		cardInfo.setCuid(cuid);
		cardInfo.setCardCredential(cardCredential);
		//update cache
		if (!isNoCache) {
			updateCachedCardInformation(cardInfo);
		}
		//update idas
		saveCardCredential(getValCardInfo(cuid), cardInfo);
	}

	public void deleteCardCredential(final CUID cuid) throws NotSingleValuedAttributeException, IdASException, UserProfileException {
		CardInformation cardInfo = new CardInformation();
		cardInfo.setCuid(cuid);
		cardInfo.setCardCredential(null);
		//update cache
		if (!isNoCache) {
			updateCachedCardInformation(cardInfo);
		}
		
		ISingleValuedAttribute attCardCred = getValCardInfo(cuid).getSingleValuedAttribute(IdasCtxUris.CCI_cardCred);
		attCardCred.remove();
	}

	public void applyUpdates() throws IdASException {
		dsUser.getContext().applyUpdates();
	}

	public void cancelUpdates() throws IdASException {
		dsUser.getContext().cancelUpdates();
	}

/*	*//**
	 * @return the cardInfo
	 *//*
	public CardInformation getCardInfo() {
		return this.cardInfo;
	}
*/
/*	*//**
	 * @param cardInfo
	 *            the cardInfo to set
	 *//*
	public void setCardInfo(CardInformation cardInfo) {
		this.cardInfo = cardInfo;
	}
*/
/*	*//**
	 * @return the byUrl
	 *//*
	public boolean isByUrl() {
		return this.byUrl;
	}

	public void setByUrl(boolean b) {
		this.byUrl = b;
	}
*/
}
