/** 
 * Copyright (c) 2007 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.userprofile.entity;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.userprofile.UserProfileException;

/**
 * @author PilipenkoYN
 *
 */
public class CardUsage implements Serializable {
	private static final long	serialVersionUID	= 1L;
	
	private CUID cuid;
	private WebForm form;
	private Date date;
	private Boolean useAlways;
	
	public static final String BY_SITE = "site";
	public static final String BY_DATE = "date";
	public static final String BY_USE = "useAlways";

	public CardUsage()
	{		
	}

	/**
	 * 
	 * @param cuid
	 * @param site
	 * @param date
	 * @param useAlways
	 * @throws UserProfileException 
	 * @deprecated
	 */
	public CardUsage(CUID cuid, URI site, Date date, Boolean useAlways) throws UserProfileException {
		super();
		this.cuid = cuid;
		this.form = new WebForm(site, null, null, null);
		this.date = date;
		this.useAlways = useAlways;
	}
	
	/**
	 * 
	 * @param cuid
	 * @param form
	 * @param date
	 * @param useAlways
	 */
	public CardUsage(CUID cuid, WebForm form, Date date, Boolean useAlways) {
		super();
		this.cuid = cuid;
		this.form = form;
		this.date = date;
		this.useAlways = useAlways;
	}
	
	public CUID getCuid() {
		return cuid;
	}
	public void setCuid(CUID cuid) {
		this.cuid = cuid;
	}	

	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	
	public Boolean getUseAlways() {
		return useAlways;
	}
	public void setUseAlways(Boolean useAlways) {
		this.useAlways = useAlways;
	}

	public WebForm getForm() {
		return form;
	}
	public void setForm(WebForm form) {
		this.form = form;
	}
	
	/**
	 * 
	 * @return
	 * @deprecated
	 */
	public URI getSite() {
		return form == null ? null : form.getUrl();
	}
	/**
	 * 
	 * @param site
	 * @throws UserProfileException 
	 * @deprecated
	 */
	public void setSite(URI site) throws UserProfileException {
		if (form == null)
			form = new WebForm(site, null, null, null);
		else
			form.setUrl(site);
	}

}
