/** 
 * Copyright (c) 2008 Parity Communications, Inc.  
 * All rights reserved. This program and the accompanying materials  
 * are made available under the terms of the Eclipse Public License v1.0  
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors: 
 *		Yuriy Pilipenko - API and implementation 
 * 
 */
package org.eclipse.higgins.userprofile.entity;

import java.io.Serializable;
import java.net.URI;

import org.eclipse.higgins.userprofile.UserProfileException;


/**
 * @author Pilipenko
 * 
 */
public class WebForm implements Serializable {
	private static final long serialVersionUID = 6945053966458865736L;

	private URI		url;
	private String	formName;
	private String	formId;
	private String	formAction;
	
	public WebForm() {
	}
	
	public WebForm(URI url, String formName, String formId, String formAction) throws UserProfileException {
		if (url == null)
			throw new UserProfileException("url can not be null!!!");
		this.url = url;
		this.formName = formName;
		this.formId = formId;
		this.formAction = formAction;
	}
	
	public URI getUrl() {
		return url;
	}
	public void setUrl(URI url) throws UserProfileException {
		if (url == null)
			throw new UserProfileException("url can not be null!!!");
		this.url = url;
	}

	public String getFormName() {
		return formName;
	}
	public void setFormName(String formName) {
		this.formName = formName;
	}
	
	public String getFormId() {
		return formId;
	}
	public void setFormId(String formId) {
		this.formId = formId;
	}
	
	public String getFormAction() {
		return formAction;
	}
	public void setFormAction(String formAction) {
		this.formAction = formAction;
	}
	
	public boolean equals(Object obj) {
		if (this == obj) {
		    return true;
		}
		if (obj instanceof WebForm) {
			WebForm wf = (WebForm) obj;
			return url.equals(wf.getUrl())
				&& (formName == null ? wf.formName == null : formName.equals(wf.formName))
				&& (formId == null ? wf.formId == null : formId.equals(wf.formId))
				&& (formAction == null ? wf.formAction == null : formAction.equals(wf.formAction));
		}
		return false;
	}

	public int hashCode() {
		return url.hashCode()
			^ (formName == null ? 7 : formName.hashCode())
			^ (formId == null ? 11 : formId.hashCode())
			^ (formAction == null ? 13 : formAction.hashCode());
	}

}
