package org.eclipse.higgins.userprofile.inmem;

import java.net.URI;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.icard.CUID;
import org.eclipse.higgins.registry.IConfiguration;
import org.eclipse.higgins.userprofile.ICardUsageManager;
import org.eclipse.higgins.userprofile.IUserProfileService;
import org.eclipse.higgins.userprofile.UserProfileException;
import org.eclipse.higgins.userprofile.entity.CardCredential;
import org.eclipse.higgins.userprofile.entity.CardInformation;
import org.eclipse.higgins.userprofile.entity.CardUsage;
import org.eclipse.higgins.userprofile.entity.Category;
import org.eclipse.higgins.userprofile.entity.PolicyVersion;
import org.eclipse.higgins.userprofile.entity.UserProfile;
import org.eclipse.higgins.userprofile.entity.WebForm;

public class MemoryUserProfileService implements IUserProfileService {
	private Log log = LogFactory.getLog(MemoryUserProfileService.class);
	private String id_ = "org.eclipse.higgins.icard.userprofile.default";

	private Map users_ = null; // <UserProfile>

	private class UserCreds {
		private String name_;
		private String password_;

		public UserCreds(CallbackHandler handler) throws UserProfileException {
			NameCallback nc = new NameCallback("User name: ");
			PasswordCallback pc = new PasswordCallback("Password: ", false);
			Callback[] callbacks = new Callback[] { nc, pc };
			try {
				handler.handle(callbacks);
			} catch (Exception e) {
				MemoryUserProfileService.this.log.error(e);
				throw new UserProfileException(
						"Can't get user creds caused by " + e);
			}
			this.name_ = nc.getName();
			this.password_ = new String(pc.getPassword());
			pc.clearPassword();
			if (getName() == null || getName().trim().length() == 0)
				throw new UserProfileException("Empty user name.");
			if (this.password_ == null || this.password_.trim().length() == 0)
				throw new UserProfileException("Empty password.");
			// return uc;
		}

		public String getName() {
			return this.name_;
		}

		public byte[] getPasswordHash() throws UserProfileException {
			if (this.password_ != null && this.password_.length() > 0)
				try {
					MessageDigest md = MessageDigest.getInstance("SHA-256");
					return md.digest(this.password_.getBytes("UTF-8"));
				} catch (Exception e) {
					MemoryUserProfileService.this.log.error(e);
					throw new UserProfileException(e);
				}
			else
				return null;
		}

		public void checkPasswordHash(byte[] pwHash)
				throws UserProfileException {
			byte[] testedHash = getPasswordHash();
			if (!Arrays.equals(pwHash, testedHash))
				throw new UserProfileException("Invalid password!");
		}
	}

	private class MemUserProfile extends UserProfile {
		/**
		 * 
		 */
		private static final long serialVersionUID = 1L;
		private String id;
		private byte[] userPasswordHash;
		private Map categories_ = null; // <Category>
		private Map cardInformations_ = null; // <CardInformation>
		//private Map cardURIRelations_ = null;

		public String getId() {
			return this.id;
		}

		public void setId(String id) {
			this.id = id;
		}

		public Map getCategories_() {
			if (this.categories_ == null)
				this.categories_ = new HashMap();
			return this.categories_;
		}

		public void setCategoties_(Map categories) {
			this.categories_ = categories;
		}

		public Map getCardInformations_() {
			if (this.cardInformations_ == null)
				this.cardInformations_ = new HashMap();
			return this.cardInformations_;
		}

		public void setCardInformations_(Map cardInformations_) {
			this.cardInformations_ = cardInformations_;
		}

		public byte[] getUserPasswordHash() {
			return this.userPasswordHash;
		}

		public void setUserPasswordHash(byte[] userPasswordHash) {
			this.userPasswordHash = userPasswordHash;
		}

		private void copy(UserProfile from, UserProfile to) {
			to.setCreated(from.getCreated());
			to.setEmail(from.getEmail());
			to.setFirstName(from.getFirstName());
			to.setLastName(from.getLastName());
			to.setLoginName(from.getLoginName());
			to.setModified(from.getModified());
			//to.setPassword(from.getPassword());
			to.setStatus(from.getStatus());
			to.setUsedFrom(from.getUsedFrom());
		}

		public MemUserProfile(UserProfile up) {
			super();
			copy(up, this);
		}

		public UserProfile toUserProfile() {
			UserProfile up = new UserProfile();
			copy(this, up);
			return up;
		}

		public void fromUserProfile(UserProfile up) {
			copy(up, this);
		}
	}

	private class MemCategory extends Category {
		private void copy(Category from, Category to) {
			to.setId(from.getId());
			to.setParentId(from.getParentId());
			to.setName(from.getName());
			to.setIcon(from.getIcon());
			to.setSelectedIcon(from.getSelectedIcon());
			to.setIdx(from.getIdx());
			ArrayList cl = (ArrayList) ((ArrayList) from.getCardList()).clone();
			to.setCardList(cl);
		}

		public MemCategory(Category category) {
			super();
			copy(category, this);
		}

		public Category toCategory() {
			Category cat = new Category();
			copy(this, cat);
			return cat;
		}

		public void fromCategory(Category cat) {
			copy(cat, this);
		}
	}

	private class MemCardInformation extends CardInformation {
		private List cardHistory;

		public List getCardHistory() {
			if (this.cardHistory == null)
				this.cardHistory = new ArrayList();
			return this.cardHistory;
		}

		public void setCardHistory(List cardHistory) {
			this.cardHistory = cardHistory;
		}

		private void copy(CardInformation from, CardInformation to) {
			try {
				if (from.getCuid() != null)
					to.setCuid(new CUID(from.getCuid().toString()));
			} catch (Exception e) {
				e.printStackTrace();
			}
			/*
			 * if (from.getURIs() != null)
			 * to.setURIs((URI[])from.getURIs().clone());
			 */

			CardCredential ccTo = new CardCredential();
			CardCredential ccFrom = from.getCardCredential();
			if (ccFrom == null)
				return;
			ccTo.setCredentialType(new String(ccFrom.getCredentialType()));
			ccTo.setTsAddress(new String(ccFrom.getTsAddress()));
			ccTo
					.setTsMetadataAddress(new String(ccFrom
							.getTsMetadataAddress()));
			ccTo.setUsername(new String(ccFrom.getUsername()));
			ccTo.setPassword(new String(ccFrom.getPassword()));
			ccTo.setPinCode((ccFrom.getPinCode() != null ? (byte[]) ccFrom
					.getPinCode().clone() : null));
			to.setCardCredential(ccTo);
		}

		public MemCardInformation(CardInformation cardInfo) {
			super();
			copy(cardInfo, this);
		}

	}

	private class MemCardUsage extends CardUsage {
		private void copy(CardUsage from, CardUsage to) {
			try {
				if (from.getCuid() != null)
					to.setCuid(new CUID(from.getCuid().toString()));
				if (from.getSite() != null)
					to.setSite(new URI(from.getSite().toString()));
				to.setDate(new Date(from.getDate().getTime()));
			} catch (Exception e) {
				MemoryUserProfileService.this.log.error(e);
			}
		}

		public MemCardUsage(CardUsage cardUsage) {
			super();
			copy(cardUsage, this);
		}

		public CardUsage toCardUsage() {
			CardUsage cu = new CardUsage();
			copy(this, cu);
			return cu;
		}
	}

	private class MemCardURIs {
		private URI uri_;
		private CUID card;
		private Date lastUsed;
		private Boolean saved;

		public URI getURI_() {
			return this.uri_;
		}

		public void setURI_(URI uri) {
			this.uri_ = uri;
		}

		public CUID getCard() {
			return this.card;
		}

		public void setCard(CUID card) {
			this.card = card;
		}

		public Date getLastUsed() {
			return this.lastUsed;
		}

		public void setLastUsed(Date lastUsed) {
			this.lastUsed = lastUsed;
		}

		public Boolean getSaved() {
			return this.saved;
		}

		public void setSaved(Boolean saved) {
			this.saved = saved;
		}
	}

	private Map getUsers_() {
		if (this.users_ == null)
			synchronized (this) {
				this.users_ = new HashMap();
			}
		return this.users_;
	}

	private MemUserProfile authenticate(CallbackHandler handler)
			throws UserProfileException {
		UserCreds uc = new UserCreds(handler);

		MemUserProfile upUser = (MemUserProfile) getUsers_().get(uc.getName());
		if (upUser == null)
			throw new UserProfileException("User Profile " + uc.getName()
					+ " not found!");
		uc.checkPasswordHash(upUser.getUserPasswordHash());

		return upUser;
	}

	public Category addCategory(CallbackHandler handler, Category category)
			throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);

			if (category == null)
				throw new IllegalArgumentException(
						"Parameter \"category\" is null");

			MemCategory catAdded = new MemCategory(category);
			catAdded.setId(org.apache.axiom.om.util.UUIDGenerator.getUUID()); // category
																				// id
																				// managed
																				// internally

			up.getCategories_().put(catAdded.getId(), catAdded);

			return catAdded.toCategory();
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public UserProfile addUserProfile(CallbackHandler handler,
			UserProfile userProfile) throws UserProfileException {
		try {
			MemUserProfile upAdded = new MemUserProfile(userProfile);

			UserCreds uc = new UserCreds(handler); // getUserCreds(handler);
			if (userIdentifierExists(uc.getName()))
				throw new UserProfileException("User with identifier \""
						+ uc.getName() + "\" already exists!");
			if (userProfile == null)
				throw new IllegalArgumentException(
						"Parameter \"userProfile\" is null");

			upAdded.setCreated(new Date());
			upAdded.setModified(null);
			upAdded.setUserPasswordHash(uc.getPasswordHash());
			upAdded.setId(uc.getName());

			getUsers_().put(uc.getName(), upAdded);

			return upAdded.toUserProfile();
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public CardInformation clearCardCredential(CallbackHandler handler,
			CUID cuid) throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

	public void deleteCategory(CallbackHandler handler, String categoryId)
			throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);

			if (categoryId == null || categoryId.trim().length() == 0)
				throw new IllegalArgumentException(
						"Parameter \"categoryId\" is null");

			MemCategory sCat = (MemCategory) up.getCategories_()
					.get(categoryId);
			if (sCat == null)
				throw new UserProfileException("Category \"" + categoryId
						+ "\" not found");

			up.getCategories_().remove(categoryId);
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public void deleteUserProfile(CallbackHandler handler)
			throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);

			getUsers_().remove(up.getId());
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public CardInformation getCardInformation(CallbackHandler handler, CUID cuid)
			throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

	public List getCategories(CallbackHandler handler)
			throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);

			Map mcat = up.getCategories_();
			List categories = new ArrayList();
			for (Iterator iterator = mcat.values().iterator(); iterator
					.hasNext();) {
				MemCategory sCat = (MemCategory) iterator.next();
				categories.add(sCat.toCategory());
			}

			return categories;
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public UserProfile getUserProfile(CallbackHandler handler)
			throws UserProfileException {
		try {
			return authenticate(handler).toUserProfile();
		} catch (Exception e) {
			this.log.error(e);
			return null;
		}
	}

	public Category modifyCategory(CallbackHandler handler, Category category)
			throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);

			if (category == null)
				throw new IllegalArgumentException(
						"Parameter \"category\" is null");
			if (category.getId() == null
					|| category.getId().trim().length() == 0)
				throw new IllegalArgumentException(
						"Category ID can not be null");

			MemCategory sCat = (MemCategory) up.getCategories_().get(
					category.getId());
			if (sCat == null)
				throw new UserProfileException("Category \"" + category.getId()
						+ "\" not found!");

			sCat.fromCategory(category);

			return sCat.toCategory();
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public UserProfile modifyUserProfile(CallbackHandler handler,
			UserProfile userProfile) throws UserProfileException {
		try {
			MemUserProfile up = authenticate(handler);
			if (userProfile == null)
				throw new IllegalArgumentException(
						"Parameter \"userProfile\" can not be null");
			// StoredUserProfile upMod = new StoredUserProfile(userProfile);

			Date dt = up.getCreated(); // prevent changes of creation time from
										// outside
			up.fromUserProfile(userProfile);
			up.setCreated(dt);
			up.setModified(new Date());

			// getUsers_().put(up.getId(), upMod);
			return up.toUserProfile();
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public String resetPassword(CallbackHandler handler)
			throws UserProfileException {
		throw new UserProfileException("Not implemented!");
	}

	public CardInformation setCardCredential(CallbackHandler handler,
			CUID cuid, CardCredential cardCredential)
			throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

	public boolean userIdentifierExists(String userIdentifier)
			throws UserProfileException {
		try {
			return getUsers_().containsKey(userIdentifier);
		} catch (Exception e) {
			this.log.error(e);
			throw new UserProfileException(e);
		}
	}

	public IConfiguration getConfiguration() {
		return null;
	}

	public String getID() {
		return this.id_;
	}

	public void setID(String id) throws Exception {
		throw new UnsupportedOperationException();
	}

	public ICardUsageManager getCardUsageManager(CallbackHandler handler)
			throws UserProfileException {
		// TODO Auto-generated method stub
		return new MemCardUsageManager();
	}

	public String resolveUserIdentifier(String privateSelectorINumber)
			throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

	public PolicyVersion getRPPolicyVersion(CallbackHandler handler, URI url)
			throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

	public void setRPPolicyVersion(CallbackHandler handler,
			PolicyVersion policyVersion) throws UserProfileException {
		// TODO Auto-generated method stub

	}

	public void deleteOldPassword(CallbackHandler handler) throws UserProfileException {
		// TODO Auto-generated method stub
		
	}

	public void setNewPassword(CallbackHandler handler, String newPassword) throws UserProfileException {
		// TODO Auto-generated method stub
		
	}

	public void setNewPasswordByPasswordIsapMd5(String userId, byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
		// TODO Auto-generated method stub
		
	}

	public void addSelectorAndSetPasswordByPasswordIsapMd5(String userId, String privateSelectorINumber,
			byte[] passwordIsapMd5, String newPassword) throws UserProfileException {
		// TODO Auto-generated method stub
		
	}

	public PolicyVersion getRPPolicyVersion(CallbackHandler handler, WebForm form) throws UserProfileException {
		// TODO Auto-generated method stub
		return null;
	}

}
