/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.idas.cp;

import java.net.URI;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IComplexAttrValue;
import org.eclipse.higgins.idas.api.IExtension;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeModel;
import org.eclipse.higgins.idas.spi.BasicAttribute;
import org.eclipse.higgins.util.idas.cp.AttributeValuesPDPIter;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;

public class BasicAttributePDP
implements IAttribute {
    private IAttributePDPs _attributePDP;
    private IAttributePDPs _attributeMetaAttrPDP;
    private IAttributePDPs _attributeValueMetaAttrPDP;
    private IAttribute _attr;
    private boolean _isProviderAttr;
    private boolean _mapForConsumer;
    private URI _attrID;
    private Log _log = LogFactory.getLog(this.getClass());

    public BasicAttributePDP(IAttributePDPs attributePDP, IAttributePDPs attributeMetaAttrPDP, IAttributePDPs attributeValueMetaAttrPDP, IAttribute attribute, boolean isProviderAttr) throws IdASException {
        this._log.debug((Object)attribute.getAttrID().toASCIIString());
        this._attributePDP = attributePDP;
        this._attributeMetaAttrPDP = attributeMetaAttrPDP;
        this._attributeValueMetaAttrPDP = attributeValueMetaAttrPDP;
        this._attr = attribute;
        this._isProviderAttr = isProviderAttr;
        this._mapForConsumer = isProviderAttr;
    }

    public IAttributeModel getModel() throws IdASException {
        return this._attr.getModel();
    }

    public IAttributeValue addValue(URI attrID) throws IdASException, InvalidTypeException {
        URI newAttrID = attrID;
        if (this._attributePDP != null) {
            if (this._isProviderAttr && this._mapForConsumer) {
                newAttrID = this._attributePDP.consumerIDToProvider(attrID);
            } else if (!this._isProviderAttr && !this._mapForConsumer) {
                newAttrID = this._attributePDP.providerIDToConsumer(attrID);
            }
        }
        IAttributeValue value = this._attr.addValue(newAttrID);
        return value;
    }

    public IAttributeValue addValue(IAttributeValue copyFrom) throws IdASException {
        return this._attr.addValue(copyFrom);
    }

    public URI getAttrID() throws IdASException {
        if (this._attrID == null) {
            if (this._attributePDP != null) {
                if (this._isProviderAttr && this._mapForConsumer) {
                    this._attrID = this._attributePDP.providerIDToConsumer(this._attr.getAttrID());
                } else if (!this._isProviderAttr && !this._mapForConsumer) {
                    this._attrID = this._attributePDP.consumerIDToProvider(this._attr.getAttrID());
                }
            }
            if (this._attrID == null) {
                this._attrID = this._attr.getAttrID();
            }
        }
        return this._attrID;
    }

    public boolean isSingleValued() throws IdASException {
        return this._attr.isSingleValued();
    }

    public IComplexAttrValue addComplexValue(URI arg0) throws IdASException, InvalidTypeException {
        return null;
    }

    public ISimpleAttrValue addSimpleValue(URI dataType, Object copyFrom) throws IdASException, InvalidTypeException {
        return this._attr.addSimpleValue(dataType, copyFrom);
    }

    public Iterator getValues() throws IdASException {
        return new AttributeValuesPDPIter(this._isProviderAttr && this._mapForConsumer ? this._attr.getAttrID() : this.getAttrID(), !this._isProviderAttr && !this._mapForConsumer ? this.getAttrID() : this._attr.getAttrID(), this._attributePDP, this._attributeValueMetaAttrPDP, this._attr.getValues(), this._isProviderAttr);
    }

    public Iterator getValues(IExtension[] extensions) throws IdASException {
        return new AttributeValuesPDPIter(this._isProviderAttr && this._mapForConsumer ? this._attr.getAttrID() : this.getAttrID(), !this._isProviderAttr && !this._mapForConsumer ? this.getAttrID() : this._attr.getAttrID(), this._attributePDP, this._attributeValueMetaAttrPDP, this._attr.getValues(extensions), this._isProviderAttr);
    }

    public void remove() throws IdASException {
        this._attr.remove();
    }

    public boolean equals(IAttribute attr) throws IdASException {
        BasicAttribute thisAttr = new BasicAttribute((IAttribute)this, null, null);
        return thisAttr.equals(attr);
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        if (this._attributeMetaAttrPDP != null) {
            IAttribute newMetadata = null;
            if (this._isProviderAttr && this._mapForConsumer) {
                newMetadata = this._attr.addAttribute(this._attributeMetaAttrPDP.consumerIDToProvider(attrID));
            } else if (!this._isProviderAttr && !this._mapForConsumer) {
                newMetadata = this._attr.addAttribute(this._attributeMetaAttrPDP.providerIDToConsumer(attrID));
            }
            return new BasicAttributePDP(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, newMetadata, false);
        }
        return this._attr.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            copyFrom = new BasicAttributePDP(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, copyFrom, false);
        }
        return this._attr.addAttribute(copyFrom);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        BasicAttribute thisAttr = new BasicAttribute((IAttribute)this, null, null);
        return thisAttr.equals(attributes);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderAttr);
                if (temp.getAttrID() != attrID) continue;
                return temp;
            }
            return null;
        }
        return this._attr.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            return new BasicAttributePDPIter(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attr.getAttributes(), this._isProviderAttr);
        }
        return this._attr.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        if (this._attributeMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderAttr);
                if (temp.getAttrID() != attrID) continue;
                return temp.getSingleValuedAttribute(attrID);
            }
            return null;
        }
        return this._attr.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeMetaAttrPDP, this._attributeMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderAttr);
                if (temp.getAttrID() != attrID) continue;
                temp.remove();
            }
            return;
        }
        this._attr.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            throw new NotImplementedException();
        }
        this._attr.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        if (this._attributeMetaAttrPDP != null) {
            throw new NotImplementedException();
        }
        this._attr.removeAttributeValue(attr);
    }
}

