/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.idas.cp;

import java.net.URI;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IHasAttributes;
import org.eclipse.higgins.idas.api.ISimpleAttrValue;
import org.eclipse.higgins.idas.api.ISingleValuedAttribute;
import org.eclipse.higgins.idas.api.ITypedValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.idas.api.InvalidTypeException;
import org.eclipse.higgins.idas.api.NotImplementedException;
import org.eclipse.higgins.idas.api.NotSingleValuedAttributeException;
import org.eclipse.higgins.idas.api.model.IAttributeSimpleValueModel;
import org.eclipse.higgins.idas.spi.BasicAttributeSet;
import org.eclipse.higgins.idas.spi.BasicSimpleValue;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDP;
import org.eclipse.higgins.util.idas.cp.BasicAttributePDPIter;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;

public class SimpleValuePDP
implements ISimpleAttrValue {
    private URI _providerAttrID;
    private URI _consumerAttrID;
    private URI _dataType;
    private ISimpleAttrValue _simpleValue;
    private IAttributePDPs _attributePDP;
    private IAttributePDPs _attributeValueMetaAttrPDP;
    private boolean _isProviderValue;
    private boolean _mapForConsumer;
    private Log _log;

    public SimpleValuePDP(URI providerAttrID, URI consumerAttrType, IAttributePDPs attributePDP, IAttributePDPs attributeValueMetaAttrPDP, ISimpleAttrValue value, boolean isProviderValue) {
        this._providerAttrID = providerAttrID;
        this._consumerAttrID = consumerAttrType;
        this._attributePDP = attributePDP;
        this._attributeValueMetaAttrPDP = attributeValueMetaAttrPDP;
        this._simpleValue = value;
        this._isProviderValue = isProviderValue;
        this._mapForConsumer = isProviderValue;
        this._log = LogFactory.getLog(this.getClass());
    }

    protected ITypedValue mapValue() throws IdASException {
        ISimpleAttrValue out = this._simpleValue;
        this._log.debug((Object)("Mapping simple value: " + this._simpleValue.getCanonical()));
        if (this._attributePDP != null) {
            if (this._isProviderValue && this._mapForConsumer) {
                this._log.debug((Object)"provider value");
                out = this._attributePDP.providerValueToConsumer(this._providerAttrID, this._simpleValue.getModel().getType(), this._consumerAttrID, this.getDataType(), (IAttributeValue)this._simpleValue);
            } else if (!this._isProviderValue && !this._mapForConsumer) {
                this._log.debug((Object)"consumer value");
                out = this._attributePDP.consumerValueToProvider(this._consumerAttrID, this._simpleValue.getModel().getType(), this._providerAttrID, this.getDataType(), (IAttributeValue)this._simpleValue);
            }
        }
        if (out != null && out.isSimple()) {
            return (ITypedValue)out;
        }
        throw new IdASException();
    }

    public String getCanonical() throws IdASException {
        return this.mapValue().getCanonical();
    }

    public String getLexical() throws IdASException {
        return this.mapValue().getLexical();
    }

    public void setData(Object copyFrom) throws IdASException {
        if (this._attributePDP != null) {
            URI tempType = null;
            tempType = this._isProviderValue && this._mapForConsumer ? this._attributePDP.providerTypeToConsumer(this._providerAttrID, this._simpleValue.getModel().getType()) : this._attributePDP.consumerTypeToProvider(this._consumerAttrID, this._simpleValue.getModel().getType());
            IAttributeValue out = null;
            BasicSimpleValue temp = new BasicSimpleValue(tempType, copyFrom);
            if (this._isProviderValue && this._mapForConsumer) {
                out = this._attributePDP.consumerValueToProvider(this._consumerAttrID, this._simpleValue.getModel().getType(), this._providerAttrID, this.getDataType(), (IAttributeValue)temp);
            } else if (!this._isProviderValue && !this._mapForConsumer) {
                out = this._attributePDP.providerValueToConsumer(this._consumerAttrID, this._simpleValue.getModel().getType(), this._providerAttrID, this.getDataType(), (IAttributeValue)temp);
            }
            if (out != null && out.isSimple()) {
                this._simpleValue.setData(((ISimpleAttrValue)out).getData());
            }
        } else {
            this._simpleValue.setData(copyFrom);
        }
    }

    public boolean isSimple() throws IdASException {
        return true;
    }

    public Object getData() throws IdASException {
        return this.mapValue().getData();
    }

    public URI getDataType() throws IdASException {
        return this.getValueType();
    }

    public URI getValueType() throws IdASException {
        if (this._dataType == null) {
            if (this._attributePDP != null) {
                if (this._isProviderValue && this._mapForConsumer) {
                    this._dataType = this._attributePDP.providerTypeToConsumer(this._providerAttrID, this._simpleValue.getModel().getType());
                } else if (!this._isProviderValue && !this._mapForConsumer) {
                    this._dataType = this._attributePDP.consumerTypeToProvider(this._consumerAttrID, this._simpleValue.getModel().getType());
                }
            }
            if (this._dataType == null) {
                this._dataType = this._simpleValue.getModel().getType();
            }
        }
        return this._dataType;
    }

    public void remove() throws IdASException {
        this._simpleValue.remove();
    }

    public boolean equals(IAttributeValue value) throws IdASException {
        BasicSimpleValue thisVal = new BasicSimpleValue(this.getDataType(), this.getData());
        return thisVal.equals(value);
    }

    public IAttributeSimpleValueModel getModel() throws IdASException {
        throw new NotImplementedException();
    }

    public IAttribute addAttribute(URI attrID) throws IdASException, InvalidTypeException {
        if (this._attributeValueMetaAttrPDP != null) {
            IAttribute newMetadata = null;
            if (this._isProviderValue && this._mapForConsumer) {
                newMetadata = this._simpleValue.addAttribute(this._attributeValueMetaAttrPDP.consumerIDToProvider(attrID));
            } else if (!this._isProviderValue && !this._mapForConsumer) {
                newMetadata = this._simpleValue.addAttribute(this._attributeValueMetaAttrPDP.providerIDToConsumer(attrID));
            }
            return new BasicAttributePDP(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, newMetadata, false);
        }
        return this._simpleValue.addAttribute(attrID);
    }

    public IAttribute addAttribute(IAttribute copyFrom) throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            copyFrom = new BasicAttributePDP(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, copyFrom, false);
        }
        return this._simpleValue.addAttribute(copyFrom);
    }

    public boolean equals(IHasAttributes attributes) throws IdASException {
        BasicAttributeSet thisMeta = new BasicAttributeSet(this.getAttributes(), null, null);
        return thisMeta.equals(attributes);
    }

    public IAttribute getAttribute(URI attrID) throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderValue);
                if (temp.getAttrID() != attrID) continue;
                return temp;
            }
            return null;
        }
        return this._simpleValue.getAttribute(attrID);
    }

    public Iterator getAttributes() throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            return new BasicAttributePDPIter(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._simpleValue.getAttributes(), this._isProviderValue);
        }
        return this._simpleValue.getAttributes();
    }

    public ISingleValuedAttribute getSingleValuedAttribute(URI attrID) throws IdASException, NotSingleValuedAttributeException {
        if (this._attributeValueMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderValue);
                if (temp.getAttrID() != attrID) continue;
                return temp.getSingleValuedAttribute(attrID);
            }
            return null;
        }
        return this._simpleValue.getSingleValuedAttribute(attrID);
    }

    public void removeAttribute(URI attrID) throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            Iterator itr = this.getAttributes();
            while (itr != null && itr.hasNext()) {
                BasicAttributePDP temp = new BasicAttributePDP(this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, this._attributeValueMetaAttrPDP, (IAttribute)itr.next(), this._isProviderValue);
                if (temp.getAttrID() != attrID) continue;
                temp.remove();
            }
            return;
        }
        this._simpleValue.removeAttribute(attrID);
    }

    public void removeAttributeValue(URI attrID, Object value) throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            throw new NotImplementedException();
        }
        this._simpleValue.removeAttributeValue(attrID, value);
    }

    public void removeAttributeValue(IAttribute attr) throws IdASException {
        if (this._attributeValueMetaAttrPDP != null) {
            throw new NotImplementedException();
        }
        this._simpleValue.removeAttributeValue(attr);
    }
}

