/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.idas.cp.jscript;

import java.net.URI;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.idas.api.IAttributeValue;
import org.eclipse.higgins.idas.api.IdASException;
import org.eclipse.higgins.util.idas.cp.IAttributePDPs;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.eclipse.higgins.util.jscript.JScriptExec;
import org.eclipse.higgins.util.jscript.JScriptExecHelper;
import org.eclipse.higgins.util.jscript.SingleObjectImmutableIterator;

public class JScriptCPMetadataPDPs
implements IAttributePDPs {
    public static final String genericParamName = "PARAM";
    public static final String genericResultName = "RESULT";
    public static final String consumerTypeParamName = "consumerType";
    public static final String providerTypeParamName = "providerType";
    public static final String consumerIDParamName = "consumerID";
    public static final String providerIDParamName = "providerID";
    private JScriptExec _consumerIDToProviderExec;
    private JScriptExec _providerIDToConsumerExec;
    private JScriptExec _consumerTypeToProviderExec;
    private JScriptExec _providerTypeToConsumerExec;
    private JScriptExec _consumerValueToProviderExec;
    private JScriptExec _providerValueToConsumerExec;
    private Log _log = LogFactory.getLog(this.getClass());

    public JScriptCPMetadataPDPs(JScriptExec consumerIDToProviderExec, JScriptExec providerIDToConsumerExec, JScriptExec consumerTypeToProviderExec, JScriptExec providerTypeToConsumerExec, JScriptExec consumerValueToProviderExec, JScriptExec providerValueToConsumerExec, boolean allowAsymmetricPDP) {
        this._consumerIDToProviderExec = consumerIDToProviderExec;
        this._providerIDToConsumerExec = providerIDToConsumerExec;
        this._consumerTypeToProviderExec = consumerTypeToProviderExec;
        this._providerTypeToConsumerExec = providerTypeToConsumerExec;
        this._consumerValueToProviderExec = consumerValueToProviderExec;
        this._providerValueToConsumerExec = providerValueToConsumerExec;
        if (!allowAsymmetricPDP) {
            if (this._consumerIDToProviderExec != this._providerIDToConsumerExec && (this._consumerIDToProviderExec == null || this._providerIDToConsumerExec == null)) {
                this._log.error((Object)("Asymmetric PDP definitions found, consumerIDToProvider is " + this._consumerIDToProviderExec == null ? "not" : (" set, providerIDToConsumer is " + this._providerIDToConsumerExec == null ? "not" : " set.")));
            }
            if (this._consumerTypeToProviderExec != this._providerTypeToConsumerExec && (this._consumerTypeToProviderExec == null || this._providerTypeToConsumerExec == null)) {
                this._log.error((Object)("Asymmetric PDP definitions found, consumerTypeToProvider is " + this._consumerTypeToProviderExec == null ? "not" : (" set, providerTypeToConsumer is " + this._providerTypeToConsumerExec == null ? "not" : " set.")));
            }
            if (this._consumerValueToProviderExec != this._providerValueToConsumerExec && (this._consumerValueToProviderExec == null || this._providerValueToConsumerExec == null)) {
                this._log.error((Object)("Asymmetric PDP definitions found, consumerValueToProvider is " + this._consumerValueToProviderExec == null ? "not" : (" set, providerValueToConsumer is " + this._providerValueToConsumerExec == null ? "not" : " set.")));
            }
        }
    }

    public URI providerIDToConsumer(URI providerID) throws IdASException {
        if (this._providerIDToConsumerExec != null) {
            try {
                return JScriptExecHelper.transformURI((JScriptExec)this._providerIDToConsumerExec, (String)providerIDParamName, (URI)providerID);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
        }
        return providerID;
    }

    public Iterator consumerIDToProviders(URI consumerID) throws IdASException {
        if (this._consumerIDToProviderExec != null) {
            try {
                return JScriptExecHelper.transformURItoMany((JScriptExec)this._consumerIDToProviderExec, (String)consumerIDParamName, (URI)consumerID);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
        return new SingleObjectImmutableIterator((Object)consumerID);
    }

    public URI consumerIDToProvider(URI consumerID) throws IdASException {
        if (this._consumerIDToProviderExec != null) {
            try {
                return JScriptExecHelper.transformURI((JScriptExec)this._consumerIDToProviderExec, (String)consumerIDParamName, (URI)consumerID);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
        }
        return consumerID;
    }

    public URI consumerTypeToProvider(URI consumerID, URI type) throws IdASException {
        String[] paramNames = new String[]{consumerIDParamName, consumerTypeParamName};
        if (this._consumerTypeToProviderExec != null) {
            try {
                URI[] params = new URI[]{consumerID, type};
                return JScriptExecHelper.transformURI((JScriptExec)this._consumerTypeToProviderExec, (String[])paramNames, (URI[])params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
        }
        return type;
    }

    public URI providerTypeToConsumer(URI providerID, URI type) throws IdASException {
        String[] paramNames = new String[]{providerIDParamName, providerTypeParamName};
        if (this._providerTypeToConsumerExec != null) {
            try {
                URI[] params = new URI[]{providerID, type};
                return JScriptExecHelper.transformURI((JScriptExec)this._providerTypeToConsumerExec, (String[])paramNames, (URI[])params);
            }
            catch (JScriptException e) {
                throw new IdASException((Throwable)e);
            }
        }
        return type;
    }

    public IAttributeValue consumerValueToProvider(URI consumerID, URI consumerType, URI providerID, URI providerType, IAttributeValue consumerValue) throws IdASException {
        String[] paramNamesConsumerValueToProvider = new String[]{consumerIDParamName, consumerTypeParamName, providerIDParamName, providerTypeParamName, genericParamName};
        if (this._consumerValueToProviderExec != null) {
            Object[] params = new Object[]{consumerID, consumerType, providerID, providerType, consumerValue};
            Object result = null;
            try {
                result = this._consumerValueToProviderExec.evaluate(paramNamesConsumerValueToProvider, params);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            return (IAttributeValue)result;
        }
        return consumerValue;
    }

    public IAttributeValue providerValueToConsumer(URI providerID, URI providerType, URI consumerID, URI consumerType, IAttributeValue providerValue) throws IdASException {
        String[] paramNamesProviderValueToConsumer = new String[]{providerIDParamName, providerTypeParamName, consumerIDParamName, consumerTypeParamName, genericParamName};
        if (this._providerValueToConsumerExec != null) {
            Object result;
            Object[] params = new Object[]{providerID, providerType, consumerID, consumerType, providerValue};
            try {
                result = this._providerValueToConsumerExec.evaluate(paramNamesProviderValueToConsumer, params);
            }
            catch (Exception e) {
                throw new IdASException((Throwable)e);
            }
            return (IAttributeValue)result;
        }
        return providerValue;
    }
}

