/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 *  	Tom Doman
 */

package org.eclipse.higgins.util.idas.cp;

import java.util.Iterator;
import java.util.NoSuchElementException;

import org.eclipse.higgins.idas.api.IAttribute;
import org.eclipse.higgins.idas.api.IdASException;

/**
 * Helper function for policy based <a
 * href="http://www.eclipse.org/higgins/">Higgins</a> Context providers. This
 * implementation allows for policy at critical points.
 * 
 * @author dbuss@novell.com
 */

public class BasicAttributePDPIter implements Iterator
{
	// the iterator we're wrapping
	private Iterator _realIterator;
	private IAttributePDPs _attributePDP;
	private IAttributePDPs _attributeMetadataPDP;
	private IAttributePDPs _attributeValueMetadataPDP;
	private boolean _areProviderAttrs;

	/**
	 * TODO: add documentation
	 * 
	 */
	public BasicAttributePDPIter(
		IAttributePDPs attributePDP,
		IAttributePDPs attributeMetadataPDP,
		IAttributePDPs attributeValueMetadataPDP,
		Iterator attrs,
		boolean areProviderAttrs)
	{
		_attributePDP = attributePDP;
		_attributeMetadataPDP = attributeMetadataPDP;
		_attributeValueMetadataPDP = attributeValueMetadataPDP;
		_realIterator = attrs;
		_areProviderAttrs = areProviderAttrs;
	}

		/**
		 * Standard hasNext method
		 */
		public boolean hasNext()
		{
			return _realIterator.hasNext();
		}

		/**
		 * Standard next method
		 */
		public Object next() throws NoSuchElementException
		{
			try
			{
				return new BasicAttributePDP(_attributePDP, _attributeMetadataPDP,
					 _attributeValueMetadataPDP, 
					(IAttribute) _realIterator.next(), _areProviderAttrs);
			}
			catch (IdASException e)
			{
				throw new NoSuchElementException();
			}
		}

		/**
		 * Makes sure that no one can remove any elements from the collection
		 */
		public void remove() throws UnsupportedOperationException
		{
			throw new UnsupportedOperationException();
		}
}
