/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *		Tom Doman
 */

package org.eclipse.higgins.util.idas.cp.jscript;

import java.util.Map;

import org.apache.axiom.om.OMElement;
import org.eclipse.higgins.util.jscript.JScriptScope;
import org.eclipse.higgins.configuration.api.ISettingDescriptor;
import org.eclipse.higgins.configuration.common.SettingDescriptor;
import org.eclipse.higgins.configuration.xml.ISettingHandler;

public class JScriptScopeSettingHandler implements ISettingHandler
{
	public Object getSetting(
		String strName,
		String strConfigurationBase,
		Map mapSettingHandlers,
		Map mapSettingsGlobal,
		Object settingsParent,
		ISettingDescriptor globalDescriptor,
		ISettingDescriptor settingDescriptor,
		OMElement omSetting) throws Exception
	{
		JScriptScope scope = new JScriptScope();
		scope.addToScope(omSetting.getText(), strName);
		if ( settingDescriptor == null ) { 
			settingDescriptor = new SettingDescriptor(strName, "htf:jscriptscope");
		}
		return scope;
	}
}
