/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.jscript;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.eclipse.higgins.util.jscript.JScriptObjectImmutableIterator;
import org.eclipse.higgins.util.jscript.JScriptScope;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

public class JScriptExec {
    private JScriptScope _jsSharedScope;
    private String scriptText;
    private Script script;
    private String _scriptID;
    private Log _log = LogFactory.getLog(this.getClass());
    private static int _unnamedScripts = 0;

    private JScriptException _handleException(Exception e, String scriptID) throws JScriptException {
        if (e instanceof WrappedException) {
            Throwable x = ((WrappedException)e).getWrappedException();
            if (this._log != null) {
                this._log.error((Object)("Error evaluating script " + this._scriptID), x);
            }
            throw new JScriptException(x);
        }
        if (this._log != null) {
            this._log.error((Object)("Error evaluating script " + this._scriptID), (Throwable)e);
        }
        throw new JScriptException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JScriptExec(JScriptScope sharedScope, String script, String scriptID) throws JScriptException {
        this.scriptText = script;
        this._jsSharedScope = sharedScope;
        this._scriptID = scriptID == null ? "executable script: " + ++_unnamedScripts : scriptID;
        Context cx = Context.enter();
        try {
            this.script = cx.compileString(this.scriptText, scriptID, 1, null);
        }
        catch (Exception e) {
            this._handleException(e, scriptID);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String[] paramNames, Object[] params) throws JScriptException {
        Context cx = Context.enter();
        ScriptableObject sharedScope = this.getSharedScope();
        try {
            Scriptable localScope = cx.newObject((Scriptable)sharedScope);
            localScope.setPrototype((Scriptable)sharedScope);
            localScope.setParentScope(null);
            if (paramNames != null) {
                for (int count = 0; count < paramNames.length; ++count) {
                    Object wrappedObj = Context.javaToJS((Object)params[count], (Scriptable)localScope);
                    ScriptableObject.putProperty((Scriptable)localScope, (String)paramNames[count], (Object)wrappedObj);
                }
            }
            Object evalResult = this.script.exec(cx, localScope);
            Object result = localScope.get("RESULT", localScope);
            Object retVal = null;
            if (result == Scriptable.NOT_FOUND || result instanceof Undefined) {
                if (evalResult != Scriptable.NOT_FOUND && !(evalResult instanceof Undefined)) {
                    retVal = evalResult;
                }
            } else {
                retVal = result;
            }
            if (retVal instanceof Wrapper) {
                retVal = ((Wrapper)retVal).unwrap();
            }
            if (retVal instanceof NativeArray) {
                retVal = new JScriptObjectImmutableIterator((NativeArray)retVal);
            } else if (retVal instanceof Iterator) {
                retVal = new JScriptObjectImmutableIterator((Iterator)retVal);
            } else if (retVal instanceof Map) {
                retVal = new JScriptObjectImmutableIterator((Map)retVal);
            } else if (retVal instanceof HashSet) {
                retVal = new JScriptObjectImmutableIterator((HashSet)retVal);
            }
            Object object = retVal;
            return object;
        }
        catch (Exception e) {
            JScriptException jScriptException = this._handleException(e, this._scriptID);
            return jScriptException;
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String[] paramNames, Object[] params, String[] outputNames, Object[] outputObjects) throws JScriptException {
        Context cx = Context.enter();
        ScriptableObject sharedScope = this.getSharedScope();
        try {
            Scriptable localScope = cx.newObject((Scriptable)sharedScope);
            localScope.setPrototype((Scriptable)sharedScope);
            localScope.setParentScope(null);
            for (int count = 0; count < paramNames.length; ++count) {
                Object wrappedObj = Context.javaToJS((Object)params[count], (Scriptable)localScope);
                ScriptableObject.putProperty((Scriptable)localScope, (String)paramNames[count], (Object)wrappedObj);
            }
            Object evalResult = this.script.exec(cx, localScope);
            for (int count = 0; count < outputNames.length; ++count) {
                Object wrappedObj = localScope.get(outputNames[count], localScope);
                outputObjects[count] = wrappedObj instanceof Wrapper ? ((Wrapper)wrappedObj).unwrap() : wrappedObj;
            }
            Object result = localScope.get("RESULT", localScope);
            Object retVal = null;
            if (result == Scriptable.NOT_FOUND || result instanceof Undefined) {
                if (evalResult != Scriptable.NOT_FOUND && !(evalResult instanceof Undefined)) {
                    retVal = evalResult;
                }
            } else {
                retVal = result;
            }
            if (retVal instanceof Wrapper) {
                retVal = ((Wrapper)retVal).unwrap();
            }
            Object object = retVal;
            return object;
        }
        catch (Exception e) {
            JScriptException jScriptException = this._handleException(e, this._scriptID);
            return jScriptException;
        }
        finally {
            Context.exit();
        }
    }

    public Object evaluate(String ParamName, Object Param) throws JScriptException {
        String[] paramNames = new String[]{ParamName};
        Object[] params = new Object[]{Param};
        return this.evaluate(paramNames, params);
    }

    private synchronized ScriptableObject getSharedScope() {
        if (this._jsSharedScope == null) {
            this._jsSharedScope = new JScriptScope();
        }
        return this._jsSharedScope.getScope();
    }
}

