/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.jscript;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.higgins.util.jscript.JScriptException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JScriptScope {
    private ScriptableObject _jsSharedScope;
    private String _scriptID;
    private Log _log;
    private static int _unnamedScripts = 0;
    private static RuntimeException earlyException;

    public JScriptScope() {
        if (earlyException != null) {
            throw earlyException;
        }
        this._log = LogFactory.getLog(this.getClass());
        this.getScope();
    }

    public synchronized void addToScope(String scriptText, String scriptID) throws JScriptException {
        if (earlyException != null) {
            throw earlyException;
        }
        this._scriptID = scriptID == null ? "shared script: " + ++_unnamedScripts : scriptID;
        Context cx = Context.enter();
        ScriptableObject sharedScope = this.getScope();
        try {
            Script script = cx.compileString(scriptText, scriptID, 1, null);
            script.exec(cx, (Scriptable)sharedScope);
        }
        catch (Exception e) {
            if (this._log != null) {
                this._log.error((Object)("Error adding script to shared scope, script: " + this._scriptID), (Throwable)e);
            }
            throw new JScriptException(e);
        }
        finally {
            Context.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ScriptableObject getScope() {
        if (this._jsSharedScope == null) {
            Context cx = Context.enter();
            try {
                this._jsSharedScope = new ImporterTopLevel(cx, true);
                Object wrappedObj = Context.javaToJS((Object)System.out, (Scriptable)this._jsSharedScope);
                ScriptableObject.putProperty((Scriptable)this._jsSharedScope, (String)"out", (Object)wrappedObj);
            }
            finally {
                Context.exit();
            }
        }
        return this._jsSharedScope;
    }

    static {
        try {
            ContextFactory.initGlobal((ContextFactory)new DynamicScopeFactory());
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }

    static class DynamicScopeFactory
    extends ContextFactory {
        DynamicScopeFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }
}

