/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 *  	Tom Doman
 */

package org.eclipse.higgins.util.jscript;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * Random helper functions for dealing with Java - JavaScript 
 * conversion and storage.
 * 
 * 
 * @author dbuss@novell.com
 */

public class JScriptHelper
{
	/**
	 * Convert a dom element to a string value, this routine 
	 * knows about and handles when the root node a &lt;SCRIPT&gt;
	 * or the single child node is a &lt;SCRIPT&gt; element.<p>
	 * 
	 * Note that when JavaScript is stored in XML then the proper 
	 * formating rules must be followed for example, &quot; instead 
	 * of a quote charachter.  An alternative to mucking with indidual 
	 * chars throughout the script is to enclose the entire script
	 * in &lt;![CDATA[  ...script... ]]&gt;
	 * 
	 * @param root node containing javascript
	 * @return String or null if no valid data found
	 */
	public static String convertNodeToScriptString(Node root)
	{
		Node dataNode = root;
		if (!dataNode.hasChildNodes())
			return null;

		if ( !dataNode.getLocalName().equals("SCRIPT"))	{
			NodeList list = root.getChildNodes();
			for (int i=0; i < list.getLength(); i++) {
				Node subnode = list.item(i);
				if (subnode.getNodeType() == Node.ELEMENT_NODE) {
					dataNode = subnode;
					break;
				}
			}
		}

		NodeList list = dataNode.getChildNodes();
		StringBuffer result = new StringBuffer();

		for (int i=0; i < list.getLength(); i++) {
			Node subnode = list.item(i);
			if (subnode.getNodeType() == Node.TEXT_NODE) {
				result.append(subnode.getNodeValue());
			}
			else if (subnode.getNodeType() == Node.CDATA_SECTION_NODE) {
				result.append(subnode.getNodeValue());
			}
			else if (subnode.getNodeType() == Node.ENTITY_REFERENCE_NODE) { 
				// Recurse into the subtree for text (and ignore comments)
				result.append(convertNodeToScriptString(subnode));
			}
		}
		if (result.length() > 0)
			return result.toString();
		else
			return null;
	}
}
