/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 *  	Tom Doman
 */

package org.eclipse.higgins.util.jscript;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * Allows single objects to be viewed as an iterator 
 * 
 * This is a version of Iterator that overrides the <code>remove</code>
 * method so that items can't be taken out of the bag.
 *  @author dbuss@novell.com
 */

public class SingleObjectImmutableIterator implements Iterator {

	// the object we're wrapping
	private Object obj;

	// iterator state
	boolean haveReturned;
	/**
	 * Create a new ImmutableIterator
	 */
	public SingleObjectImmutableIterator(Object obj) {
   	 haveReturned = false;
   	 this.obj = obj;
	}
	       
	/**
	 * Standard hasNext method
	 */
	public boolean hasNext() {
		if ( haveReturned )
			return false;
		else 
			return true;
	}

	/**
	 * Standard next method
	 */
	public Object next() throws NoSuchElementException {
		if ( haveReturned )
			return null;

		haveReturned = true;
		return obj;
	}

	/**
	 * Makes sure that no one can remove any elements from the collection
	 */
	public void remove() throws UnsupportedOperationException {
		throw new UnsupportedOperationException();
	}
}		
