/**
 * Copyright (c) 2007 Novell, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *  	Duane Buss
 *  	Tom Doman
 */

package org.eclipse.higgins.util.jscript;

public class JScriptException extends Exception
{
   /**
	 * 
	 */
	private static final long serialVersionUID = 104631703434984L;

	/**
    * Constructs a new <code>ProcessingException</code> with no message
    * or cause.
    */
   public JScriptException() {

   }

   /**
    * Constructs a new <code>ProcessingException</code> with a message,
    * but no cause. The message is saved for later retrieval by the
    * {@link java.lang#Throwable.getMessage() Throwable.getMessage()}
    * method.
    *
    * @param message the detail message (<code>null</code> if nonexistent
    *                or unknown)
    */
   public JScriptException(String message) {
       super(message);
   }

   /**
    * Constructs a new <code>JScriptException</code> with a cause,
    * but no message. The cause is saved for later retrieval by the
    * {@link java.lang#Throwable.getCause() Throwable.getCause()}
    * method.
    *
    * @param cause the cause (<code>null</code> if nonexistent
    *              or unknown)
    */
   public JScriptException(Throwable cause) {
       super(cause);
   }

   /**
    * Constructs a new <code>JScriptException</code> with a message
    * and a cause. The message and cause are saved for later retrieval
    * by the
    * {@link java.lang#Throwable.getMessage() Throwable.getMessage()} and
    * {@link java.lang#Throwable.getCause() Throwable.getCause()}
    * methods.
    *
    * @param message the detail message (<code>null</code> if nonexistent
    *                or unknown)
    * @param cause the cause (<code>null</code> if nonexistent
    *              or unknown)
    */
   public JScriptException(String message, Throwable cause) {
       super(message, cause);
   }
}
