/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAML2AuthnStatement;
import org.eclipse.higgins.util.saml.SAML2Conditions;
import org.eclipse.higgins.util.saml.SAML2Subject;
import org.eclipse.higgins.util.saml.SAMLConstants;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2Assertion
extends XMLElement {
    public SAML2Assertion(Document document) {
        super(document, SAMLConstants.PREFIX_SAML_ASSERTION, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
    }

    public SAML2Assertion() {
        this((Document)null);
    }

    public SAML2Assertion(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2Assertion(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2Assertion(Document document, Element element) {
        super(document, element);
    }

    public String getVersion() {
        return this.element.getAttribute("Version");
    }

    public void setVersion(String value) {
        this.element.setAttribute("Version", value);
    }

    public Date getIssueInstant() {
        try {
            return SAML2Assertion.fromXMLDate(this.element.getAttribute("IssueInstant"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setIssueInstant(Date value) {
        this.element.setAttribute("IssueInstant", SAML2Assertion.toXMLDate(value));
    }

    private Element getIssuerElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Issuer").item(0);
        }
        return element;
    }

    public String getIssuer() {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            return null;
        }
        return SAML2Assertion.getTextContent(elementIssuer);
    }

    public void setIssuer(String value) {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            elementIssuer = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
            elementIssuer.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementIssuer);
        }
        SAML2Assertion.setTextContent(elementIssuer, value);
    }

    private Element getAuthnStatementElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AuthnStatement").item(0);
        }
        return element;
    }

    public SAML2AuthnStatement getSAMLAuthnStatement() {
        Element elementAuthnStatement = this.getAuthnStatementElement();
        if (elementAuthnStatement == null) {
            return null;
        }
        return new SAML2AuthnStatement(this.document, elementAuthnStatement);
    }

    public void setSAMLAuthnStatement(SAML2AuthnStatement samlAuthnStatement) {
        Element elementAuthnStatement = this.getAuthnStatementElement();
        if (elementAuthnStatement != null) {
            this.element.replaceChild(elementAuthnStatement, samlAuthnStatement.getElement());
        } else {
            this.element.appendChild(samlAuthnStatement.getElement());
        }
    }

    private Element getSubjectElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Subject").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Subject").item(0);
        }
        return element;
    }

    public SAML2Subject getSubject() {
        Element elementSubject = this.getSubjectElement();
        if (elementSubject == null) {
            return null;
        }
        return new SAML2Subject(this.document, elementSubject);
    }

    public void setSAMLSubject(SAML2Subject samlSubject) {
        Element elementSubject = this.getAuthnStatementElement();
        if (elementSubject != null) {
            this.element.replaceChild(elementSubject, samlSubject.getElement());
        } else {
            this.element.appendChild(samlSubject.getElement());
        }
    }

    private Element getConditionsElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Conditions").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Conditions").item(0);
        }
        return element;
    }

    public SAML2Conditions getConditions() {
        Element elementConditions = this.getConditionsElement();
        if (elementConditions == null) {
            return null;
        }
        return new SAML2Conditions(this.document, elementConditions);
    }

    public void setSAMLConditions(SAML2Conditions samlConditions) {
        Element elementConditions = this.getConditionsElement();
        if (elementConditions != null) {
            this.element.replaceChild(elementConditions, samlConditions.getElement());
        } else {
            this.element.appendChild(samlConditions.getElement());
        }
    }
}

