package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.Reader;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML1Assertion extends XMLElement
{
	/**
	 * 
	 * @param document
	 */
	public SAML1Assertion(
		Document document)
	{
		super(document, SAMLConstants.PREFIX_SAML_ASSERTION, SAMLConstants.NS_SAML_1_ASSERTION, "Assertion");
	}

	/**
	 * 
	 * @param reader
	 * @throws SAXException
	 * @throws IOException
	 */
	public SAML1Assertion(
		Reader reader) throws SAXException, IOException
	{
		super(reader);
	}

	private Element getSubjectElement()
	{
		Element element = (Element) this.element.getElementsByTagNameNS(SAMLConstants.NS_SAML_1_ASSERTION, "Subject").item(0);
		if (element == null) element = (Element) this.element.getElementsByTagName("Subject").item(0);

		return(element);
	}

	public SAML1Subject getSubject()
	{
		Element elementSubject = this.getSubjectElement();
		if (elementSubject == null) return(null);

		return(new SAML1Subject(this.document, elementSubject));
	}
}
