/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAMLConstants;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2AuthnRequest
extends XMLElement {
    public SAML2AuthnRequest(Document document) {
        super(document, "samlp", "urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest");
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
    }

    public SAML2AuthnRequest() {
        this((Document)null);
    }

    public SAML2AuthnRequest(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2AuthnRequest(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2AuthnRequest(Document document, Element element) {
        super(document, element);
    }

    public String getDestination() {
        return this.element.getAttribute("Destination");
    }

    public void setDestination(String value) {
        this.element.setAttribute("Destination", value);
    }

    public String getVersion() {
        return this.element.getAttribute("Version");
    }

    public void setVersion(String value) {
        this.element.setAttribute("Version", value);
    }

    public Date getIssueInstant() {
        try {
            return SAML2AuthnRequest.fromXMLDate(this.element.getAttribute("IssueInstant"));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void setIssueInstant(Date value) {
        this.element.setAttribute("IssueInstant", SAML2AuthnRequest.toXMLDate(value));
    }

    public String getProtocolBinding() {
        return this.element.getAttribute("ProtocolBinding");
    }

    public void setProtocolBinding(String value) {
        this.element.setAttribute("ProtocolBinding", value);
    }

    public String getProviderName() {
        return this.element.getAttribute("ProviderName");
    }

    public void setProviderName(String value) {
        this.element.setAttribute("ProviderName", value);
    }

    public String getAssertionConsumerServiceURL() {
        return this.element.getAttribute("AssertionConsumerServiceURL");
    }

    public void setAssertionConsumerServiceURL(String value) {
        this.element.setAttribute("AssertionConsumerServiceURL", value);
    }

    private Element getIssuerElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Issuer").item(0);
        }
        return element;
    }

    public String getIssuer() {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            return null;
        }
        return SAML2AuthnRequest.getTextContent(elementIssuer);
    }

    public void setIssuer(String value) {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            elementIssuer = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
            elementIssuer.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementIssuer);
        }
        SAML2AuthnRequest.setTextContent(elementIssuer, value);
    }

    private Element getNameIDPolicyElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameIDPolicy").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("NameIDPolicy").item(0);
        }
        return element;
    }

    public Boolean getNameIDPolicyAllowCreate() {
        Element elementNameIDPolicy = this.getNameIDPolicyElement();
        if (elementNameIDPolicy == null) {
            return null;
        }
        Attr attrAllowCreate = elementNameIDPolicy.getAttributeNode("AllowCreate");
        if (attrAllowCreate == null) {
            return null;
        }
        return new Boolean(attrAllowCreate.getValue());
    }

    public void setNameIDPolicyAllowCreate(boolean value) {
        Element elementNameIDPolicy = this.getNameIDPolicyElement();
        if (elementNameIDPolicy == null) {
            elementNameIDPolicy = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameIDPolicy");
            elementNameIDPolicy.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementNameIDPolicy);
        }
        elementNameIDPolicy.setAttribute("AllowCreate", Boolean.toString(value));
    }

    public String getNameIDPolicyFormat() {
        Element elementNameIDPolicy = this.getNameIDPolicyElement();
        if (elementNameIDPolicy == null) {
            return null;
        }
        Attr attrFormat = elementNameIDPolicy.getAttributeNode("Format");
        if (attrFormat == null) {
            return null;
        }
        return attrFormat.getValue();
    }

    public void setNameIDPolicyFormat(String value) {
        Element elementNameIDPolicy = this.getNameIDPolicyElement();
        if (elementNameIDPolicy == null) {
            elementNameIDPolicy = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "NameIDPolicy");
            elementNameIDPolicy.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementNameIDPolicy);
        }
        elementNameIDPolicy.setAttribute("Format", value);
    }
}

