/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAMLConstants;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2AuthnStatement
extends XMLElement {
    public SAML2AuthnStatement(Document document) {
        super(document, SAMLConstants.PREFIX_SAML_ASSERTION, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement");
        this.setAuthnInstant(new Date());
    }

    public SAML2AuthnStatement() {
        this((Document)null);
    }

    public SAML2AuthnStatement(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAML2AuthnStatement(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAML2AuthnStatement(Document document, Element element) {
        super(document, element);
    }

    public Date getAuthnInstant() {
        try {
            return SAML2AuthnStatement.fromXMLDate(this.element.getAttribute("AuthnInstant"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setAuthnInstant(Date value) {
        this.element.setAttribute("AuthnInstant", SAML2AuthnStatement.toXMLDate(value));
    }

    private Element getAuthnContextElement() {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContext").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AuthnContext").item(0);
        }
        return element;
    }

    private Element getAuthnContextClassRefElement(Element elementAuthnContext) {
        Element element = (Element)this.element.getElementsByTagNameNS("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnContextClassRef").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AuthnContextClassRef").item(0);
        }
        return element;
    }

    public String getAuthnContextClassRef() {
        Element elementAuthnContext = this.getAuthnContextElement();
        if (elementAuthnContext == null) {
            return null;
        }
        Element elementAuthnContextClassRef = this.getAuthnContextClassRefElement(elementAuthnContext);
        if (elementAuthnContextClassRef == null) {
            return null;
        }
        return SAML2AuthnStatement.getTextContent(elementAuthnContextClassRef);
    }

    public void setAuthnContextClassRef(String value) {
        Element elementAuthnContextClassRef;
        Element elementAuthnContext = this.getAuthnContextElement();
        if (elementAuthnContext == null) {
            elementAuthnContext = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContext");
            elementAuthnContext.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementAuthnContext);
        }
        if ((elementAuthnContextClassRef = this.getAuthnContextClassRefElement(elementAuthnContext)) == null) {
            elementAuthnContextClassRef = this.document.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef");
            elementAuthnContextClassRef.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            elementAuthnContext.appendChild(elementAuthnContextClassRef);
        }
        SAML2AuthnStatement.setTextContent(elementAuthnContextClassRef, value);
    }
}

