/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.higgins.util.saml.SAMLConstants;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLSubject
extends XMLElement {
    public SAMLSubject(Document document, String nameSpace) {
        super(document, SAMLConstants.PREFIX_SAML_ASSERTION, nameSpace, "Subject");
    }

    public SAMLSubject(String nameSpace) {
        this(null, nameSpace);
        this.nameSpace = nameSpace;
    }

    public SAMLSubject(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAMLSubject(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAMLSubject(Document document, Element element) {
        super(document, element);
    }

    protected Element getNameIDElement() {
        String id = this.nameSpace.equals("urn:oasis:names:tc:SAML:1.0:assertion") ? "NameIdentifier" : "NameID";
        Element element = (Element)this.element.getElementsByTagNameNS(this.nameSpace, id).item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName(id).item(0);
        }
        return element;
    }

    public String getNameIDFormat() {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            return null;
        }
        Attr attrFormat = elementNameID.getAttributeNode("Format");
        if (attrFormat == null) {
            return null;
        }
        return attrFormat.getValue();
    }

    public void setNameIDFormat(String value) {
        String id = this.nameSpace.equals("urn:oasis:names:tc:SAML:1.0:assertion") ? "NameIdentifier" : "NameID";
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            elementNameID = this.document.createElementNS(this.nameSpace, id);
            elementNameID.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementNameID);
        }
        elementNameID.setAttribute("Format", value);
    }

    public String getNameID() {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            return null;
        }
        return SAMLSubject.getTextContent(elementNameID);
    }

    public void setNameID(String value) {
        Element elementNameID = this.getNameIDElement();
        if (elementNameID == null) {
            String id = this.nameSpace.equals("urn:oasis:names:tc:SAML:1.0:assertion") ? "NameIdentifier" : "NameID";
            elementNameID = this.document.createElementNS(this.nameSpace, id);
            elementNameID.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementNameID);
        }
        SAMLSubject.setTextContent(elementNameID, value);
    }

    protected Element getSubjectConfirmationElement() {
        Element element = (Element)this.element.getElementsByTagNameNS(this.nameSpace, "SubjectConfirmation").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("SubjectConfirmation").item(0);
        }
        return element;
    }

    public String getSubjectConfirmationMethod() {
        Element elementSubjectConfirmation = this.getSubjectConfirmationElement();
        if (elementSubjectConfirmation == null) {
            return null;
        }
        if (this.nameSpace.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
            Element element = (Element)elementSubjectConfirmation.getElementsByTagNameNS("urn:oasis:names:tc:SAML:1.0:assertion", "ConfirmationMethod").item(0);
            if (element == null) {
                element = (Element)elementSubjectConfirmation.getElementsByTagName("ConfirmationMethod").item(0);
            }
            if (element == null) {
                return null;
            }
            return SAMLSubject.getTextContent(element);
        }
        Attr attrFormat = elementSubjectConfirmation.getAttributeNode("Method");
        if (attrFormat == null) {
            return null;
        }
        return attrFormat.getValue();
    }

    public void setSubjectConfirmationMethod(String value) {
        Element elementSubjectConfirmation = this.getSubjectConfirmationElement();
        if (elementSubjectConfirmation == null) {
            elementSubjectConfirmation = this.document.createElementNS(this.nameSpace, "SubjectConfirmation");
            elementSubjectConfirmation.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementSubjectConfirmation);
        }
        if (this.nameSpace.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
            Element elementConfirmationMethod = this.document.createElementNS(this.nameSpace, "ConfirmationMethod");
            elementConfirmationMethod.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            SAMLSubject.setTextContent(elementConfirmationMethod, value);
            elementSubjectConfirmation.appendChild(elementConfirmationMethod);
        } else {
            elementSubjectConfirmation.setAttribute("Method", value);
        }
    }
}

