/*******************************************************************************
 * Copyright (c) 2007 Google
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Markus Sabadello - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAML2Assertion extends SAMLAssertion {

	public SAML2Assertion(Document document) {

		super(document, SAMLConstants.PREFIX_SAML_ASSERTION, SAMLConstants.NS_SAML_ASSERTION, "Assertion");

		this.setVersion("2.0");
		this.setIssueInstant(new Date());
	}

	public SAML2Assertion() {

		this((Document) null);
	}

	public SAML2Assertion(InputStream stream) throws SAXException, IOException {

		super(stream);
	}

	public SAML2Assertion(Reader reader) throws SAXException, IOException {

		super(reader);
	}

	public SAML2Assertion(Document document, Element element) {

		super(document, element);
	}


	private Element getAuthnStatementElement() {

		Element element = (Element) this.element.getElementsByTagNameNS(SAMLConstants.NS_SAML_ASSERTION, "AuthnStatement").item(0);
		if (element == null) element = (Element) this.element.getElementsByTagName("AuthnStatement").item(0);

		return(element);
	}

	public SAML2AuthnStatement getSAMLAuthnStatement() {

		Element elementAuthnStatement = this.getAuthnStatementElement();
		if (elementAuthnStatement == null) return(null);

		return(new SAML2AuthnStatement(this.document, elementAuthnStatement));
	}

	public void setSAMLAuthnStatement(SAML2AuthnStatement samlAuthnStatement) {

		Element elementAuthnStatement = this.getAuthnStatementElement();

		if (elementAuthnStatement != null) {

			this.element.replaceChild(elementAuthnStatement, samlAuthnStatement.getElement());
		} else {

			this.element.appendChild(samlAuthnStatement.getElement());
		}
	}

}
