/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.SAMLAttributes;
import org.eclipse.higgins.util.saml.SAMLConditions;
import org.eclipse.higgins.util.saml.SAMLConstants;
import org.eclipse.higgins.util.saml.SAMLSubject;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLAssertion
extends XMLElement {
    public SAMLAssertion(Document document, String prefix, String namespaceURI, String localName) {
        super(document, prefix, namespaceURI, localName);
    }

    public SAMLAssertion(Document document) {
        super(document, SAMLConstants.PREFIX_SAML_ASSERTION, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        this.setVersion("2.0");
        this.setIssueInstant(new Date());
    }

    public SAMLAssertion() {
        this((Document)null);
    }

    public SAMLAssertion(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAMLAssertion(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAMLAssertion(Document document, Element element) {
        super(document, element);
    }

    public String getVersion() {
        return this.element.getAttribute("Version");
    }

    public void setVersion(String value) {
        this.element.setAttribute("Version", value);
    }

    public Date getIssueInstant() {
        try {
            return SAMLAssertion.fromXMLDate(this.element.getAttribute("IssueInstant"));
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setIssueInstant(Date value) {
        this.element.setAttribute("IssueInstant", SAMLAssertion.toXMLDate(value));
    }

    private Element getIssuerElement() {
        Element element = (Element)this.element.getElementsByTagNameNS(this.getNameSpace(), "Issuer").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Issuer").item(0);
        }
        return element;
    }

    public String getIssuer() {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            return null;
        }
        return SAMLAssertion.getTextContent(elementIssuer);
    }

    public void setIssuer(String value) {
        Element elementIssuer = this.getIssuerElement();
        if (elementIssuer == null) {
            elementIssuer = this.document.createElementNS(this.getNameSpace(), "Issuer");
            elementIssuer.setPrefix(SAMLConstants.PREFIX_SAML_ASSERTION);
            this.element.appendChild(elementIssuer);
        }
        SAMLAssertion.setTextContent(elementIssuer, value);
    }

    private Element getSubjectElement() {
        Element element = (Element)this.element.getElementsByTagNameNS(this.getNameSpace(), "Subject").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Subject").item(0);
        }
        return element;
    }

    public SAMLSubject getSubject() {
        Element elementSubject = this.getSubjectElement();
        if (elementSubject == null) {
            return null;
        }
        return new SAMLSubject(this.document, elementSubject);
    }

    public void setSAMLSubject(SAMLSubject samlSubject) {
        Element elementSubject = this.getSubjectElement();
        if (elementSubject != null) {
            this.element.replaceChild(elementSubject, samlSubject.getElement());
        } else {
            this.element.appendChild(samlSubject.getElement());
        }
    }

    private Element getConditionsElement() {
        Element element = (Element)this.element.getElementsByTagNameNS(this.getNameSpace(), "Conditions").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("Conditions").item(0);
        }
        return element;
    }

    public SAMLConditions getConditions() {
        Element elementConditions = this.getConditionsElement();
        if (elementConditions == null) {
            return null;
        }
        return new SAMLConditions(this.document, elementConditions);
    }

    public void setSAMLConditions(SAMLConditions samlConditions) {
        Element elementConditions = this.getConditionsElement();
        if (elementConditions != null) {
            this.element.replaceChild(elementConditions, samlConditions.getElement());
        } else {
            this.element.appendChild(samlConditions.getElement());
        }
    }

    public SAMLAttributes getAttributes() {
        return new SAMLAttributes(this.document, this.element);
    }
}

