/*******************************************************************************
 * Copyright (c) Novell Inc.   2008
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Duane Buss - Initial API and implementation
 *******************************************************************************/
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Vector;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
 * 
 *
 */
public class SAMLAttributes extends XMLElement {

	public SAMLAttributes(Document document) {

		super(document, SAMLConstants.PREFIX_SAML_ASSERTION, SAMLConstants.NS_SAML_ASSERTION, "Attribute");
	}

	public SAMLAttributes() {

		this((Document) null);
	}

	public SAMLAttributes(InputStream stream) throws SAXException, IOException {

		super(stream);
	}

	public SAMLAttributes(Reader reader) throws SAXException, IOException {

		super(reader);
	}

	/**
	 * 
	 * @param document doc containing the saml assertion
	 * @param element of the root most element of the saml assertion
	 */
	public SAMLAttributes(Document document, Element element) {

		super(document, element);
	}
	
	/**
	 * 
	 * @return Vector of SAMLAttributes
	 */
	public Vector getAttributes() {
		Vector attributes  = new Vector();
		NodeList nl = this.element.getElementsByTagNameNS(nameSpace, "Attribute");
		if ( nl == null)
			nl = this.element.getElementsByTagName("Attribute");
		
		if (nl != null && nl.getLength() >= 1)
		{
			for (int index = 0; index < nl.getLength(); index++)
				attributes.add(	new SAMLAttribute(this.document, (Element)nl.item(index)));
		}
		return attributes;	
	}
}
