/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SAMLAttribute
extends XMLElement {
    protected String nameSpace;

    public SAMLAttribute(Document document) {
        super(document, "saml", "urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
    }

    public SAMLAttribute() {
        this((Document)null);
    }

    public SAMLAttribute(InputStream stream) throws SAXException, IOException {
        super(stream);
        this.nameSpace = this.element.getNamespaceURI();
    }

    public SAMLAttribute(Reader reader) throws SAXException, IOException {
        super(reader);
        this.nameSpace = this.element.getNamespaceURI();
    }

    public SAMLAttribute(Document document, Element element) {
        super(document, element);
        this.nameSpace = element.getNamespaceURI();
    }

    public String getNameID() {
        return this.element.getAttribute("AttributeName");
    }

    public void setNameID(String value) {
        this.element.setAttribute("AttributeName", value);
    }

    public String getNameSpace() {
        return this.element.getAttribute("AttributeNamespace");
    }

    public void setNameSpace(String value) {
        this.element.setAttribute("AttributeNamespace", value);
    }

    public URI getFullName() {
        try {
            return new URI(this.getNameSpace() + '/' + this.getNameID());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean isSimpleSingleValuedValue() {
        NodeList nl = this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue");
        if (nl == null) {
            nl = this.element.getElementsByTagName("AttributeValue");
        }
        return nl == null || nl != null && nl.getLength() <= 1;
    }

    public String getValue() {
        if (!this.isSimpleSingleValuedValue()) {
            return null;
        }
        Element element = (Element)this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AttributeValue").item(0);
        }
        if (element == null) {
            return null;
        }
        return SAMLAttribute.getTextContent(element);
    }

    public Vector getSimpleValues() {
        Vector<String> claimValues = new Vector<String>();
        NodeList nl = this.element.getElementsByTagNameNS(this.nameSpace, "AttributeValue");
        if (nl == null) {
            nl = this.element.getElementsByTagName("AttributeValue");
        }
        if (nl != null && nl.getLength() >= 1) {
            for (int index = 0; index < nl.getLength(); ++index) {
                claimValues.add(SAMLAttribute.getTextContent((Element)nl.item(index)));
            }
        }
        return claimValues;
    }
}

