/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.ParseException;
import java.util.Date;
import org.eclipse.higgins.util.saml.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SAMLConditions
extends XMLElement {
    public SAMLConditions(Document document) {
        super(document, "saml", "urn:oasis:names:tc:SAML:2.0:assertion", "Conditions");
    }

    public SAMLConditions() {
        this((Document)null);
    }

    public SAMLConditions(InputStream stream) throws SAXException, IOException {
        super(stream);
    }

    public SAMLConditions(Reader reader) throws SAXException, IOException {
        super(reader);
    }

    public SAMLConditions(Document document, Element element) {
        super(document, element);
    }

    public Date getNotBefore() {
        try {
            return SAMLConditions.fromXMLDate(this.element.getAttribute("NotBefore"));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void setNotBefore(Date value) {
        this.element.setAttribute("NotBefore", SAMLConditions.toXMLDate(value));
    }

    public Date getNotOnOrAfter() {
        try {
            return SAMLConditions.fromXMLDate(this.element.getAttribute("NotOnOrAfter"));
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void setNotOnOrAfter(Date value) {
        this.element.setAttribute("NotOnOrAfter", SAMLConditions.toXMLDate(value));
    }

    private Element getAudienceRestrictionElement() {
        Element element = (Element)this.element.getElementsByTagNameNS(this.nameSpace, "AudienceRestriction").item(0);
        if (element == null) {
            element = (Element)this.element.getElementsByTagName("AudienceRestriction").item(0);
        }
        return element;
    }

    protected Element getAudienceRestrictionAudienceElement() {
        Element element = this.getAudienceRestrictionElement();
        if ((element = (Element)element.getElementsByTagNameNS(this.nameSpace, "Audience").item(0)) == null) {
            element = (Element)this.element.getElementsByTagName("Audience").item(0);
        }
        return element;
    }

    public void setAudienceRestrictionAudience(String value) {
        Element elementAudienceRestriction = this.getAudienceRestrictionElement();
        if (elementAudienceRestriction == null) {
            elementAudienceRestriction = this.document.createElementNS(this.nameSpace, "AudienceRestriction");
            elementAudienceRestriction.setPrefix("saml");
            this.element.appendChild(elementAudienceRestriction);
        }
        Element elementAudienceRestrictionAudience = this.document.createElementNS(this.nameSpace, "Audience");
        elementAudienceRestrictionAudience.setPrefix("saml");
        elementAudienceRestriction.appendChild(elementAudienceRestrictionAudience);
        SAMLConditions.setTextContent(elementAudienceRestrictionAudience, value);
    }
}

