/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Random;
import java.util.TimeZone;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.eclipse.higgins.util.saml.KeyValueKeySelector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLElement {
    private static final Log log = LogFactory.getLog((Class)(class$org$eclipse$higgins$util$saml$XMLElement == null ? (class$org$eclipse$higgins$util$saml$XMLElement = XMLElement.class$("org.eclipse.higgins.util.saml.XMLElement")) : class$org$eclipse$higgins$util$saml$XMLElement));
    public static final String PROVIDER_JSR105 = "org.jcp.xml.dsig.internal.dom.XMLDSigRI";
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;
    private static TransformerFactory transformerFactory = null;
    private static Transformer transformer = null;
    private static XMLSignatureFactory signatureFactory = null;
    private static KeyInfoFactory keyInfoFactory = null;
    private static Random random = null;
    protected Document document;
    protected Element element;
    protected String nameSpace;
    static /* synthetic */ Class class$org$eclipse$higgins$util$saml$XMLElement;

    protected XMLElement(Document document, String prefix, String namespaceURI, String localName) {
        if (document == null) {
            this.document = documentBuilder.newDocument();
            this.element = this.document.createElementNS(namespaceURI, localName);
            this.element.setPrefix(prefix);
            this.document.appendChild(this.element);
            XMLElement.addNamespaceAttributes(this.document);
        } else {
            this.document = document;
            this.element = this.document.createElementNS(namespaceURI, localName);
            this.element.setPrefix(prefix);
        }
        this.setID(XMLElement.createID());
        this.nameSpace = this.element.getNamespaceURI();
    }

    protected XMLElement(InputStream stream) throws SAXException, IOException {
        InputSource inputSource = new InputSource(stream);
        this.document = documentBuilder.parse(inputSource);
        this.element = this.document.getDocumentElement();
        this.nameSpace = this.element.getNamespaceURI();
    }

    protected XMLElement(Reader reader) throws SAXException, IOException {
        InputSource inputSource = new InputSource(reader);
        this.document = documentBuilder.parse(inputSource);
        this.element = this.document.getDocumentElement();
        this.nameSpace = this.element.getNamespaceURI();
    }

    protected XMLElement(Document document, Element element) {
        this.document = document;
        this.element = element;
        this.nameSpace = this.element.getNamespaceURI();
    }

    public Document getDocument() {
        return this.document;
    }

    public Element getElement() {
        return this.element;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public String dump() throws IOException {
        return this.dump(false);
    }

    public String dump(boolean omitXMLDeclaration) throws IOException {
        StringWriter writer = new StringWriter();
        OutputFormat format = new OutputFormat("XML", "UTF-8", true);
        format.setIndenting(false);
        format.setOmitDocumentType(omitXMLDeclaration);
        format.setOmitXMLDeclaration(true);
        XMLSerializer serializer = new XMLSerializer((Writer)writer, format);
        serializer.asDOMSerializer();
        serializer.serialize(this.element);
        writer.close();
        String str = writer.getBuffer().toString();
        log.debug((Object)("DUMP: " + str));
        return str;
    }

    public String toString() {
        try {
            return this.dump();
        }
        catch (IOException ex) {
            return "[SERIALIZATION PROBLEM: " + ex.getMessage();
        }
    }

    public boolean hasSignature() {
        Element signatureElement = (Element)this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        return signatureElement != null;
    }

    public boolean hasKeyInfo() {
        Element signatureElement = (Element)this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        if (signatureElement == null) {
            return false;
        }
        Element keyInfoElement = (Element)signatureElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo").item(0);
        return keyInfoElement != null;
    }

    /*
     * WARNING - void declaration
     */
    private void sign(PrivateKey privateKey, KeyInfo keyInfo, Node nextSibling) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, KeyException {
        void var8_8;
        SignatureMethod signatureMethod;
        DigestMethod digestMethod = signatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null);
        Transform transform = signatureFactory.newTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature", (TransformParameterSpec)null);
        Reference reference = signatureFactory.newReference("#" + this.getID(), digestMethod, Collections.singletonList(transform), null, null);
        CanonicalizationMethod canonicalizationMethod = signatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (C14NMethodParameterSpec)null);
        if (privateKey instanceof DSAPrivateKey) {
            signatureMethod = signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null);
        } else if (privateKey instanceof RSAPrivateKey) {
            signatureMethod = signatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null);
        } else {
            throw new IllegalArgumentException("Invalid key type (must be DSA or RSA).");
        }
        SignedInfo signedInfo = signatureFactory.newSignedInfo(canonicalizationMethod, (SignatureMethod)var8_8, Collections.singletonList(reference));
        DOMSignContext signContext = new DOMSignContext(privateKey, (Node)this.element);
        signContext.setNextSibling(nextSibling);
        signContext.setIdAttributeNS(this.element, null, "ID");
        XMLSignature signature = signatureFactory.newXMLSignature(signedInfo, keyInfo);
        signature.sign(signContext);
    }

    private void sign(PrivateKey privateKey, KeyInfo keyInfo) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, KeyException {
        this.sign(privateKey, keyInfo, this.element.getFirstChild());
    }

    public void sign(PrivateKey privateKey, PublicKey publicKey, Node nextSibling) throws KeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        KeyValue keyValue = keyInfoFactory.newKeyValue(publicKey);
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
        this.sign(privateKey, keyInfo, nextSibling);
    }

    public void sign(PrivateKey privateKey, PublicKey publicKey) throws KeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        this.sign(privateKey, publicKey, this.element.getFirstChild());
    }

    public void sign(PrivateKey privateKey, Certificate certificate, Node nextSibling) throws KeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        X509Data certificateData = keyInfoFactory.newX509Data(Collections.singletonList(certificate));
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(certificateData));
        this.sign(privateKey, keyInfo, nextSibling);
    }

    public void sign(PrivateKey privateKey, Certificate certificate) throws KeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException {
        this.sign(privateKey, certificate, this.element.getFirstChild());
    }

    public void sign(PrivateKey privateKey, Node nextSibling) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, KeyException {
        this.sign(privateKey, (KeyInfo)null, nextSibling);
    }

    public void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, MarshalException, XMLSignatureException, KeyException {
        this.sign(privateKey, (KeyInfo)null, this.element.getFirstChild());
    }

    public void verify(PublicKey publicKey) throws MarshalException, XMLSignatureException, VerificationException {
        Element signatureElement = (Element)this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        if (signatureElement == null) {
            throw new IllegalStateException("No XML Signature found to verify.");
        }
        DOMValidateContext validateContext = new DOMValidateContext(publicKey, (Node)signatureElement);
        XMLSignature signature = signatureFactory.unmarshalXMLSignature(validateContext);
        if (!signature.getSignatureValue().validate(validateContext)) {
            throw new VerificationException("Invalid signature value.");
        }
        Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
        while (i.hasNext()) {
            Reference reference = i.next();
            if (reference.validate(validateContext)) continue;
            throw new VerificationException("Invalid reference: URI=" + reference.getURI() + ", Type=" + reference.getType() + ", ID=" + reference.getId());
        }
        if (!signature.validate(validateContext)) {
            throw new VerificationException("Invalid signature.");
        }
    }

    public void verifyFromKeyInfo() throws MarshalException, XMLSignatureException, VerificationException {
        Element signatureElement = (Element)this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature").item(0);
        if (signatureElement == null) {
            throw new IllegalStateException("No XML Signature found to verify.");
        }
        DOMValidateContext validateContext = new DOMValidateContext(new KeyValueKeySelector(), (Node)signatureElement);
        XMLSignature signature = signatureFactory.unmarshalXMLSignature(validateContext);
        if (!signature.getSignatureValue().validate(validateContext)) {
            throw new VerificationException("Invalid signature value.");
        }
        Iterator<Reference> i = signature.getSignedInfo().getReferences().iterator();
        while (i.hasNext()) {
            Reference reference = i.next();
            if (reference.validate(validateContext)) continue;
            throw new VerificationException("Invalid reference: URI=" + reference.getURI() + ", Type=" + reference.getType() + ", ID=" + reference.getId());
        }
        if (!signature.validate(validateContext)) {
            throw new VerificationException("Invalid signature.");
        }
    }

    public static String getTextContent(Element element) {
        StringBuffer buffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 3) continue;
            buffer.append(node.getNodeValue());
        }
        return buffer.toString();
    }

    public static void setTextContent(Element element, String value) {
        if (element.hasChildNodes()) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 3) continue;
                element.removeChild(nodeList.item(i));
            }
        }
        Text text = element.getOwnerDocument().createTextNode(value);
        element.appendChild(text);
    }

    public String getID() {
        return this.element.getAttribute("ID");
    }

    public void setID(String value) {
        this.element.setAttribute("ID", value);
    }

    public void deleteID() {
        this.element.removeAttribute("ID");
    }

    public static String createID() {
        char[] hex = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        char[] chars = new char[40];
        int pos = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int hi = bytes[i] >> 4 & 0xF;
            int lo = bytes[i] & 0xF;
            chars[pos++] = hex[hi];
            chars[pos++] = hex[lo];
        }
        return String.valueOf(chars);
    }

    public static Date fromXMLDate(String date) throws ParseException {
        int dot = date.indexOf(46);
        SimpleDateFormat format = dot > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.parse(date);
    }

    public static String toXMLDate(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return format.format(date);
    }

    public static void addNamespaceAttributes(Document document) {
        XMLElement.addNamespaceAttributes(document.getDocumentElement());
    }

    public static void addNamespaceAttributes(Element element) {
        if ("samlp" != null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:2.0:protocol");
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:protocol");
        }
        if ("saml" != null) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:2.0:assertion");
        } else {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:assertion");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            transformerFactory = TransformerFactory.newInstance();
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("indent", "no");
            signatureFactory = XMLSignatureFactory.getInstance("DOM", (Provider)Class.forName(System.getProperty("jsr105Provider", PROVIDER_JSR105)).newInstance());
            keyInfoFactory = signatureFactory.getKeyInfoFactory();
            random = new Random();
        }
        catch (Exception ex) {
            throw new RuntimeException("Cannot initialize XML.", ex);
        }
    }

    public class VerificationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public VerificationException(String message) {
            super(message);
        }
    }
}

