/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.higgins.util.socket;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Security;
import javax.naming.NamingException;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HigginsSSLSocketFactory
extends SSLSocketFactory {
    private static final Object KEYSTORE_SYNC_OBJECT = new Object();
    private KeyStore _keyStore;
    private File _keyStoreFile;
    private String _keyStorePassword;

    public static SocketFactory getDefault() {
        return new HigginsSSLSocketFactory();
    }

    private HigginsSSLSocketFactory() {
    }

    public void setKeyStore(File keyStoreFile, String keyStorePassword) {
        this._keyStoreFile = keyStoreFile;
        this._keyStorePassword = keyStorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadKeyStore() throws NamingException {
        try {
            Object object = KEYSTORE_SYNC_OBJECT;
            synchronized (object) {
                this._initializeKeyStore(true);
            }
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
        }
    }

    public String[] getDefaultCipherSuites() {
        return new String[0];
    }

    public String[] getSupportedCipherSuites() {
        return new String[0];
    }

    private void _initializeKeyStore(boolean bRefresh) throws Exception {
        if (this._keyStore == null || bRefresh) {
            this._keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            if (this._keyStoreFile != null && this._keyStoreFile.exists()) {
                FileInputStream fis = new FileInputStream(this._keyStoreFile);
                this._keyStore.load(fis, null);
                fis.close();
            } else {
                this._keyStore.load(null, null);
            }
        }
    }

    private SSLContext _createSSLContext() throws IOException {
        SSLContext sslContext = null;
        try {
            this._initializeKeyStore(false);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(Security.getProperty("ssl.KeyManagerFactory.algorithm"));
            kmf.init(this._keyStore, this._keyStorePassword.toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(Security.getProperty("ssl.TrustManagerFactory.algorithm"));
            tmf.init(this._keyStore);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return sslContext;
    }

    private SSLContext _getSSLContext() throws IOException {
        return this._createSSLContext();
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return this._getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
    }

    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        return this._getSSLContext().getSocketFactory().createSocket(inetAddress, i, inetAddress1, i1);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this._getSSLContext().getSocketFactory().createSocket(host, port);
    }

    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        return this._getSSLContext().getSocketFactory().createSocket(inetAddress, i);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this._getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }
}

