/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.sample.loganalyzer;

import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.loaders.util.XMLLoader;
import org.eclipse.hyades.log.ui.internal.wizards.LocalLogParserLoader;
import org.eclipse.hyades.logging.parsers.LogParserException;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.ui.internal.navigator.INavigator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class AnalyzeCorrelateOperation
implements IRunnableWithProgress {
    private String projectName;
    protected INavigator fViewer;
    private String tcMonitor = null;
    private TRCMonitor tRCMonitor;
    private TRCAgent _agent;
    private String logFilePath = null;
    private static final String APACHE_VERSION = "V1.3.20";
    private Parser parser;
    private String name;

    public AnalyzeCorrelateOperation(Parser parser, String name) {
        this.parser = parser;
        this.name = name;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Node node;
        try {
            node = NodeFactory.createNode((String)"localhost");
        }
        catch (UnknownHostException e) {
            throw new InterruptedException(e.getMessage());
        }
        TRCProcessProxy _process = null;
        IContainer container = PDCoreUtil.createContainer((IPath)new Path(this.projectName));
        this.tRCMonitor = PDCoreUtil.createMonitor((IContainer)container, (String)this.tcMonitor);
        String portNb = UIPlugin.getDefault().getPreferenceStore().getString("localhost_port");
        TRCNode trcNode = PDCoreUtil.createNode((TRCMonitor)this.tRCMonitor, (String)node.getName(), (String)portNb);
        _process = this.createProcess(container, trcNode);
        TRCAgent trcAgent = this._agent = this.createAgent(container, _process, this.name);
        TRCProcessProxy trcProcess = _process;
        monitor.worked(1);
        try {
            XMLLoader xmlLoader = new XMLLoader(trcAgent);
            xmlLoader.loadEvent("<CommonBaseEvents>".getBytes(), "<CommonBaseEvents>".getBytes().length);
            Hashtable<String, String> input = new Hashtable<String, String>();
            input.put("file_path", this.logFilePath);
            input.put("APACHE_VERSION", APACHE_VERSION);
            LocalLogParserLoader parserLoader = new LocalLogParserLoader(this.parser, input);
            parserLoader.setXMLLoader(xmlLoader);
            parserLoader.startParsing();
            xmlLoader.loadEvent("</CommonBaseEvents>".getBytes(), "</CommonBaseEvents>".getBytes().length);
            try {
                xmlLoader.cleanUp();
            }
            catch (Exception exc) {}
        }
        catch (LogParserException l) {
            throw new InterruptedException(l.getMessage());
        }
        monitor.worked(1);
        this.fViewer.selectReveal((ISelection)new StructuredSelection((Object)trcAgent.getAgentProxy()));
        monitor.done();
    }

    public void dispose() {
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String string) {
        this.projectName = string;
    }

    public INavigator getFViewer() {
        return this.fViewer;
    }

    public void setFViewer(INavigator explorer) {
        this.fViewer = explorer;
    }

    private TRCProcessProxy createProcess(IContainer container, TRCNode node) {
        int pID = 0;
        String logPath = "";
        Hashtable<String, String> elems = new Hashtable<String, String>();
        elems.put("file_path", this.logFilePath);
        elems.put("APACHE_VERSION", APACHE_VERSION);
        ArrayList<String> index = new ArrayList<String>();
        index.add("file_path");
        index.add("APACHE_VERSION");
        Iterator iterator = index.iterator();
        if (iterator.hasNext()) {
            logPath = logPath + elems.get(iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            logPath = logPath + " " + elems.get(iterator.next()).toString();
        }
        TRCProcessProxy process = null;
        EList processes = node.getProcessProxies();
        Iterator i = processes.iterator();
        int counter = 0;
        while (i.hasNext()) {
            process = (TRCProcessProxy)i.next();
            ++counter;
            if (process.getName() == null || !process.getName().equals(logPath)) continue;
            return process;
        }
        TRCMonitor monitor = node.getMonitor();
        String rID = new Date().toString();
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        String processName = node.getMonitor().getName() + "_" + node.getName() + "_" + counter + "_" + pID;
        String fileName = processName + "." + "trcpxmi";
        IPath path = container.getFullPath().append(fileName);
        URI uri = URI.createURI((String)("platform:/resource" + path.toString()));
        Resource pDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        pDoc.setModified(true);
        EList pExt = pDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)pDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        process = factory.createTRCProcessProxy();
        process.setPid(pID);
        process.setRuntimeId(String.valueOf(pID));
        process.setName(logPath);
        process.setLaunchMode(0);
        process.setNode(node);
        pExt.add((Object)process);
        ProfileEvent event = UIPlugin.getDefault().getProfileEvent();
        event.setSource((Object)process);
        event.setType(128);
        UIPlugin.getDefault().notifyProfileEventListener(event);
        return process;
    }

    private TRCAgent createAgent(IContainer container, TRCProcessProxy process, String name) {
        String timestamp;
        TRCAgentProxy agent = null;
        String type = "Logging";
        EList agents = process.getAgentProxies();
        Iterator i = agents.iterator();
        while (i.hasNext()) {
            agent = (TRCAgentProxy)i.next();
            if (!agent.getName().equals(name)) continue;
            agent.getAgent().getDefaultEvents().clear();
            return agent.getAgent();
        }
        String rID = timestamp = DateFormat.getDateTimeInstance(0, 0).format(new Date());
        rID = HyadesUtil.change((String)rID, (String)" ", (String)"");
        rID = HyadesUtil.change((String)rID, (String)":", (String)"");
        String agentName = process.getNode().getMonitor().getName() + "_" + process.getNode().getName() + "_" + process.getPid() + "_" + rID + "_" + name;
        agentName = HyadesUtil.change((String)agentName, (String)" ", (String)"");
        String pPath = process.eResource().getURI().toString();
        Path path = new Path(pPath);
        if (path.segmentCount() > 1) {
            pPath = path.removeLastSegments(1).toString();
        }
        String fileName = agentName + "." + "trcaxmi";
        IPath filePath = new Path(pPath).append(fileName);
        URI uri = URI.createURI((String)filePath.toString());
        Resource agDoc = Resource.Factory.Registry.INSTANCE.getFactory(uri).createResource(uri);
        agDoc.setModified(true);
        EList agExt = agDoc.getContents();
        UIPlugin.getDefault().getResourceSet().getResources().add((Object)agDoc);
        HierarchyFactory factory = UIPlugin.getDefault().getPerftraceFactory();
        agent = factory.createTRCAgentProxy();
        agent.setName(name);
        agent.setType(type);
        agent.setProcessProxy(process);
        process.getAgentProxies().add((Object)agent);
        TRCAgent ag = factory.createTRCAgent();
        ag.setAgentProxy(agent);
        ag.setType(type);
        agExt.add((Object)ag);
        return ag;
    }

    public TRCMonitor getTRCMonitor() {
        return this.tRCMonitor;
    }

    public String getTcMonitor() {
        return this.tcMonitor;
    }

    public void setTcMonitor(String string) {
        this.tcMonitor = string;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public void setLogFilePath(String string) {
        this.logFilePath = string;
    }

    public TRCAgent getAgent() {
        return this._agent;
    }

    public void setAgent(TRCAgent agent) {
        this._agent = agent;
    }
}

