/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.hyades.collection.threadanalyzer.StkEntry;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;

public class StkEntryNative
extends StkEntry
implements Externalizable {
    private static int _curVersion = 1;
    private int _version = -1;
    public String _function;
    public String _hexAddress;

    public StkEntryNative(String function, String hexAddress) {
        this._version = _curVersion;
        this._function = function;
        this._hexAddress = hexAddress;
    }

    public String format(int indent) {
        String sIndent = "";
        String sRet = "";
        for (int i = 0; i < indent; ++i) {
            sIndent = sIndent + "   ";
        }
        sRet = this._function == null ? sIndent + "      " + this._hexAddress : sIndent + "      " + this._hexAddress + " " + TAUtils.getNLSValue("ta.string.in", "in") + " " + this._function;
        return sRet;
    }

    public void print(int indent) {
        System.out.println(this.format(indent));
    }

    public String getFQName() {
        return this._function;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._version);
        out.writeObject(this._method);
        out.writeObject(this._pkg);
        out.writeObject(this._module);
        out.writeInt(this._lineno);
        out.writeBoolean(this._isNative);
        out.writeObject(this._function);
        out.writeObject(this._hexAddress);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._version = in.readInt();
        this._method = (String)in.readObject();
        this._pkg = (String)in.readObject();
        this._module = (String)in.readObject();
        this._lineno = in.readInt();
        this._isNative = in.readBoolean();
        this._function = (String)in.readObject();
        this._hexAddress = (String)in.readObject();
    }

    public StkEntryNative() {
    }
}

