/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.collection.threadanalyzer.dumpparser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.SwingUtilities;
import org.eclipse.hyades.collection.threadanalyzer.DumpData;
import org.eclipse.hyades.collection.threadanalyzer.TAUtils;
import org.eclipse.hyades.collection.threadanalyzer.ThreadDump;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserHP;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux131;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserLinux131_Suse_cxppc;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserNT;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserSolaris;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParserSolaris40;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_a118_20010215a;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca122_20001026b;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca131_20020722;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_ca1411_20031011;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn130_20010502;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn131_20020223;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cn131_20021012;
import org.eclipse.hyades.collection.threadanalyzer.dumpparser.DumpParser_cxia32131_20021023;

public class DumpParser {
    private static DumpParser instance = null;
    private boolean cmdLine = false;
    protected boolean newDump = false;
    protected boolean recordLineFlag = true;
    protected static String[] _validArgNames = new String[]{"streamIn", "streamOut", "dumpIn", "detailXML", "logLevel", "reportOut", "reportType", "analyze", "dumpInType"};
    public static final int DEBUG = 4;
    public static final int DETAIL = 3;
    public static final int INFO = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 0;
    protected static int _logLevel = 2;
    private static final int LINUX130 = 1;
    private static final int AIX = 2;
    private static final int SOLARIS35 = 3;
    private static final int NT = 4;
    private static final int HPUX = 5;
    private static final int INTERNAL = 6;
    private static final int ca122_20001026b = 7;
    private static final int a118_20010215a = 8;
    private static final int a118_20000411 = 9;
    private static final int cn130_20010502 = 10;
    private static final int cn122_20001026 = 11;
    private static final int cn131_20020223 = 12;
    private static final int ca131_20020722 = 13;
    private static final int cn131_20021012 = 14;
    private static final int ca1411_20031011 = 18;
    private static final int cn1411_20031011 = 19;
    private static final int LINUX131 = 15;
    private static final int LINUX131_2 = 16;
    private static final int LINUX131_CXPPC = 17;
    private static final int UNKNOWN = 99;
    protected int _lineNo = 0;
    protected BufferedReader _r;
    protected static Hashtable _args = new Hashtable();
    protected static String _dumpInName;
    protected static String _dumpingJvmName;

    public DumpParser() {
        this.cmdLine = false;
    }

    public DumpParser(boolean cmdLine) {
        this.cmdLine = cmdLine;
    }

    public static void main(String[] args) {
        instance = new DumpParser(true);
        instance.doIt(args);
    }

    public void doIt(String[] args) {
        DumpParser d = null;
        this.parseArgs(args);
        boolean fWriteReport = !DumpParser.getArg("reportType").equalsIgnoreCase("none");
        String streamInName = DumpParser.getArg("streamIn");
        String dumpInName = DumpParser.getArg("dumpIn");
        if (streamInName != null && dumpInName != null) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.SpecifyOnlyOne", "Must specify only one of { streamIn or dumpIn }"));
            DumpParser.syntax();
        }
        if (streamInName == null && dumpInName == null) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.MustSpecifyDumpIn", "Must specify dumpIn"));
            DumpParser.syntax();
        }
        String reportOutName = DumpParser.getArg("reportOut");
        String streamOutName = DumpParser.getArg("streamOut");
        String reportType = DumpParser.getArg("reportType");
        if (!(reportType.equalsIgnoreCase("html") || reportType.equalsIgnoreCase("text") || reportType.equalsIgnoreCase("none"))) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ReportTypeMustBe", "reportType must be either 'html', 'text' or 'none'"));
            DumpParser.syntax();
        }
        if (dumpInName != null) {
            DumpData data = null;
            try {
                d = DumpParser.create(dumpInName);
                DumpParser.logDebug("dumpName=\t" + dumpInName);
                DumpParser.logDebug("DumpParser=\t" + d.getClass().getName());
                _dumpInName = new String(dumpInName);
                data = new DumpData();
                data.setDumpParserClassName(d.getClass().getName());
                data.setInputFilename(dumpInName);
                data.setLogLevel(DumpParser.logLevelFromArgs());
                if (DumpParser.extraCarriageReturns(dumpInName)) {
                    String dumpFile = dumpInName;
                    Runnable showErrorDialog = new Runnable(){

                        public void run() {
                        }
                    };
                    SwingUtilities.invokeLater(showErrorDialog);
                    return;
                }
                d.parse(data);
                if (!this.cmdLine) {
                    if (streamOutName != null) {
                        // empty if block
                    }
                } else {
                    DumpParser.logInfo("Successfully parsed: " + dumpInName);
                }
            }
            catch (Exception e) {
                if (_logLevel >= 4) {
                    e.printStackTrace();
                }
                String dumpFile = dumpInName;
                String lineNo = e.getMessage();
                if (!this.cmdLine) {
                    Runnable showErrorDialog = new Runnable(){

                        public void run() {
                        }
                    };
                    SwingUtilities.invokeLater(showErrorDialog);
                } else {
                    DumpParser.logErr("Errors occurred parsing: " + dumpFile);
                }
                return;
            }
            if (d._r != null) {
                try {
                    d._r.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (streamOutName == null && fWriteReport) {
                DumpParser.logDebug("streamOutName == null & fWriteReport");
                if (DumpParser.getArg("reportOut").equalsIgnoreCase("DEFAULT")) {
                    data.print();
                } else {
                    data.print(DumpParser.getArg("reportOut"));
                }
            } else if (streamOutName != null) {
                try {
                    DumpParser.logDebug("DumpParser.main()  trying to write to: " + streamOutName);
                    data.writeTo(streamOutName);
                }
                catch (Throwable e1) {
                    DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred."));
                    e1.printStackTrace();
                }
            }
        } else {
            try {
                DumpData data = DumpData.readFrom(streamInName);
                data.setLogLevel(DumpParser.logLevelFromArgs());
                if (fWriteReport) {
                    data.print();
                }
            }
            catch (Exception e1) {
                DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ExceptionOccurred", "an exception occurred."));
                e1.printStackTrace();
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    private static boolean extraCarriageReturns(String inFile) throws FileNotFoundException, IOException {
        boolean unixNewlines = false;
        BufferedReader charReader = new BufferedReader(new FileReader(inFile));
        DumpParser.logDebug("[DumpParser] detecting first EOL");
        char c = '\u0000';
        while ((c = (char)charReader.read()) != '\r') {
            if (_logLevel >= 4) {
                System.err.print(c);
            }
            if (c != '\n') continue;
            unixNewlines = true;
            break;
        }
        DumpParser.logDebug("\n[DumpParser] Found EOL !!!");
        if (!unixNewlines && charReader.read() == 13) {
            DumpParser.logDebug("[DumpParser] extra carriage returns detected.  quitting...");
            return true;
        }
        return false;
    }

    public static DumpParser create(String fileName) throws Exception {
        BufferedReader r;
        int file_type = 99;
        file_type = DumpParser.getDumpParserTypeFromFile(fileName);
        try {
            r = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + fileName);
            throw e;
        }
        DumpParser d = null;
        d = DumpParser.createParser(file_type, r);
        return d;
    }

    public static int getDumpParserTypeFromFile(String fileName) throws Exception {
        String str1;
        int file_type = 99;
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e) {
            DumpParser.logErr("dumpparser: " + TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + fileName);
            throw e;
        }
        for (int i = 0; i < 75 && (str1 = r.readLine()) != null; ++i) {
            file_type = DumpParser.getDumpParserType(str1);
            if (file_type == 99) continue;
            _dumpingJvmName = str1.substring(str1.indexOf(" ") + 1);
            break;
        }
        return file_type;
    }

    public static int getDumpParserTypeFromDumpData(DumpData d) {
        String str1;
        int file_type = 99;
        ThreadDump thdDump = null;
        thdDump = d.getThreadDump();
        Enumeration enumeration = thdDump.getEnumerator();
        for (int i = 0; i < 75 && (file_type = DumpParser.getDumpParserType(str1 = thdDump.getNextLine(enumeration))) == 99; ++i) {
        }
        return file_type;
    }

    private static int getDumpParserType(String str) {
        int file_type = 99;
        if (str.indexOf("IBM build a118") != -1) {
            DumpParser.logDebug("jdk build: a118...");
            file_type = 8;
        }
        if (str.indexOf("IBM AIX build") != -1) {
            if (str.indexOf("IBM AIX build ca131") != -1) {
                DumpParser.logDebug("jdk AIX build: ca131...");
                file_type = 7;
            }
            if (str.indexOf("IBM AIX build ca131-20021") != -1 || str.indexOf("IBM AIX build ca131-2003") != -1) {
                DumpParser.logDebug("jdk AIX build: ca131-20021...");
                file_type = 16;
            }
            if (str.indexOf("IBM AIX build ca1411") != -1) {
                DumpParser.logDebug("jdk AIX build: ca1411...");
                file_type = 18;
            }
        }
        if (str.indexOf("IBM build ca130") != -1) {
            DumpParser.logDebug("jdk build: ca130...");
            file_type = 7;
        }
        if (str.indexOf("IBM build ca122") != -1) {
            DumpParser.logDebug("jdk build: ca122...");
            file_type = 7;
        }
        if (str.indexOf("IBM build cx130") != -1) {
            DumpParser.logDebug("jdk build: cx130...");
            file_type = 1;
        }
        if (str.indexOf("IBM build cn122") != -1) {
            DumpParser.logDebug("jdk build: cn122...");
            file_type = 11;
        }
        if (str.indexOf("IBM build cn130") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            file_type = 10;
        }
        if (str.indexOf("IBM Windows 32 build cn131") != -1) {
            DumpParser.logDebug("jdk build: cn131...");
            file_type = 12;
        }
        if (str.indexOf("A SIGQUIT has been received. Do you want to:") != -1) {
            DumpParser.logDebug(TAUtils.getNLSValue("ta.errmsg.FileTypeWs35ForSolaris", "File type ws 35 for solaris"));
            file_type = 3;
        }
        if (str.indexOf("cn130-20010925") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010925");
            file_type = 10;
        }
        if (str.indexOf("cn130-20010914") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010914");
            file_type = 10;
            if (str.indexOf("Classic VM") != -1) {
                file_type = 11;
            }
        }
        if (str.indexOf("cn130-20010609") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010609");
            file_type = 10;
        }
        if (str.indexOf("cn130-20010502") != -1) {
            DumpParser.logDebug("jdk build: cn130-20010502");
            file_type = 10;
        }
        if (str.indexOf("cn1411-20031011") != -1) {
            DumpParser.logDebug("jdk build: cn1411-20031011");
            file_type = 19;
        }
        if (str.indexOf("ca122-20010629") != -1) {
            DumpParser.logDebug("jdk build: ca122-20010629");
            file_type = 7;
        }
        if (str.indexOf("ca122-20001026b") != -1) {
            DumpParser.logDebug("jdk build: ca122-20001026b");
            file_type = 7;
        }
        if (str.indexOf("c390_x122-20010316") != -1) {
            DumpParser.logDebug("jdk build: c390_x122-20010316");
            file_type = 11;
        }
        if (str.indexOf("cn122-20010629") != -1) {
            DumpParser.logDebug("jdk build: cn122-20010629");
            file_type = 11;
            if (str.indexOf("Classic VM") == -1) {
                file_type = 10;
            }
        }
        if (str.indexOf("cn122-20010503a") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            file_type = 10;
        }
        if (str.indexOf("cn122-20010929") != -1) {
            DumpParser.logDebug("jdk build: cn130...");
            file_type = 10;
        }
        if (str.indexOf("cn122-20010308") != -1) {
            DumpParser.logDebug("jdk build: cn122-20010308");
            file_type = 11;
        }
        if (str.indexOf("cn122-20001026") != -1) {
            DumpParser.logDebug("jdk build: cn122-20001026");
            file_type = 11;
        }
        if (str.indexOf("ca122-20001026") != -1) {
            DumpParser.logDebug("jdk build: ca122-20001026");
            file_type = 7;
        }
        if (str.indexOf("ca130-20010713") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010713");
            file_type = 7;
        }
        if (str.indexOf("ca130-20010615") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010615");
            file_type = 7;
        }
        if (str.indexOf("ca130-20010330") != -1) {
            DumpParser.logDebug("jdk build: ca130-20010330");
            file_type = 7;
        }
        if (str.indexOf("ca122-20010313") != -1) {
            DumpParser.logDebug("jdk build: ca122-20010313");
            file_type = 7;
        }
        if (str.indexOf("a118-20010804") != -1) {
            DumpParser.logDebug("jdk build: a118-20010804");
            file_type = 8;
        }
        if (str.indexOf("a118-20010215a") != -1) {
            DumpParser.logDebug("jdk build: a118-20010215a");
            file_type = 8;
        }
        if (str.indexOf("a118-20000411") != -1) {
            DumpParser.logDebug("jdk build: a118-20000411");
            file_type = 8;
        }
        if (str.indexOf("lwp_id") != -1) {
            DumpParser.logDebug("lwp_id...indicates HP");
            file_type = 5;
        }
        if (str.indexOf("cx390130") != -1 || str.indexOf("cxia32130") != -1) {
            DumpParser.logDebug("J2RE 1.3.0 IBM build for Linux");
            file_type = 1;
        }
        if (str.indexOf("cx3901411-20031011") != -1) {
            DumpParser.logDebug("jdk build:  cx3901411-20031011");
            file_type = 16;
        }
        if (str.indexOf("IBM build cxppc") != -1) {
            DumpParser.logDebug("IBM build cxppc - Linux/Suse");
            file_type = 17;
        }
        if (str.indexOf("cx390131") != -1 || str.indexOf("cxia32131") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM build for Linux");
            file_type = 15;
        }
        if (str.indexOf("cxia32131-20021") != -1 || str.indexOf("cxia32131-2003") != -1 || str.indexOf("cx390131-20021") != -1 || str.indexOf("cx390131-2003") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM build for Linux");
            file_type = 16;
        }
        if (str.indexOf("cn131w-20020223") != -1) {
            DumpParser.logDebug("J2RE 1.3.1 IBM Windows 32 build cn131w-20020223 ORB130");
            file_type = 12;
        }
        if (str.indexOf("cn131-20021") != -1 || str.indexOf("cn131-2003") != -1 || str.indexOf("cn131w-20021") != -1 || str.indexOf("cndev-2003") != -1 || str.indexOf("cndev-2004") != -1 || str.indexOf("cn142-2004") != -1 || str.indexOf("cn131w-2003") != -1) {
            DumpParser.logDebug("Compatible with parser for IBM Windows 32 build cn131-20021012");
            file_type = 14;
        }
        return file_type;
    }

    public static DumpParser createParser(int file_type, BufferedReader r) {
        DumpParser d = null;
        d = file_type == 11 ? new DumpParserNT() : (file_type == 13 ? new DumpParser_ca131_20020722() : (file_type == 19 ? new DumpParser_cn131_20021012() : (file_type == 14 ? new DumpParser_cn131_20021012() : (file_type == 12 ? new DumpParser_cn131_20020223() : (file_type == 10 ? new DumpParser_cn130_20010502() : (file_type == 7 ? new DumpParser_ca122_20001026b() : (file_type == 18 ? new DumpParser_ca1411_20031011() : (file_type == 8 || file_type == 9 ? new DumpParser_a118_20010215a() : (file_type == 3 ? new DumpParserSolaris() : (file_type == 5 ? new DumpParserHP() : (file_type == 1 ? new DumpParserLinux() : (file_type == 15 ? new DumpParserLinux131() : (file_type == 16 ? new DumpParser_cxia32131_20021023() : (file_type == 17 ? new DumpParserLinux131_Suse_cxppc() : new DumpParserSolaris40()))))))))))))));
        d._r = r;
        _logLevel = DumpParser.logLevelFromArgs();
        return d;
    }

    private static int logLevelFromArgs() {
        int retVal = 2;
        String arg = DumpParser.getArg("logLevel");
        if (arg != null) {
            if (arg.equalsIgnoreCase("error")) {
                retVal = 0;
            }
            if (arg.equalsIgnoreCase("warn")) {
                retVal = 1;
            }
            if (arg.equalsIgnoreCase("info")) {
                retVal = 2;
            }
            if (arg.equalsIgnoreCase("detail")) {
                retVal = 3;
            }
            if (arg.equalsIgnoreCase("debug")) {
                retVal = 4;
            }
        }
        return retVal;
    }

    protected String getLine() throws Exception {
        String sRet = null;
        if (this._r.ready()) {
            ++this._lineNo;
            sRet = this._r.readLine();
        }
        DumpParser.logDebug("line " + this._lineNo + ": " + sRet);
        return sRet;
    }

    protected String getLine(DumpData d) throws Exception {
        String sRet = null;
        sRet = this.getLine();
        if (this.recordLineFlag) {
            d.addDumpTextLine(sRet, this._lineNo);
        }
        if (this.newDump && sRet != null) {
            int i = sRet.indexOf(32);
            String sRetNew = sRet.substring(i);
            sRetNew.trim();
            return sRetNew;
        }
        return sRet;
    }

    protected void resetFileReader() throws Exception {
        try {
            this._r.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            this._r = new BufferedReader(new FileReader(_dumpInName));
            this._lineNo = 0;
        }
        catch (Exception e) {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.ErrOpeningFile", "Error Opening File ") + _dumpInName);
            throw e;
        }
    }

    protected static void syntax() {
        DumpParser.logErr("DumpParser " + TAUtils.getNLSValue("ta.string.syntax", "syntax") + ":");
        DumpParser.logErr("   { dumpIn=filename }");
        DumpParser.logErr("   [ logLevel={ERROR | WARN | INFO | DETAIL | DEBUG} (default:INFO) ]");
        DumpParser.logErr("   [ reportType={ TEXT | HTML | NONE } ( default is HTML ) ] ");
        DumpParser.logErr("   [ dumpInType={ SERVEROUT | JAVACORE } ( default is JAVACORE ) ] ");
    }

    public void parseArgs(String[] args) {
        for (int i = 0; i < _validArgNames.length; ++i) {
            String sArg = null;
            if (_validArgNames[i].equals("detailXML")) {
                sArg = "./threadanalyzerdetail.xml";
            }
            if (_validArgNames[i].equals("reportOut")) {
                sArg = "default";
            }
            if (_validArgNames[i].equals("reportType")) {
                sArg = "html";
            }
            if (_validArgNames[i].equals("analyze")) {
                sArg = "was";
            }
            if (_validArgNames[i].equals("dumpInType")) {
                sArg = "javaCore";
            }
            _args.put(_validArgNames[i].toUpperCase(), new Arg(sArg));
        }
        Enumeration enumeration = null;
        enumeration = _args.keys();
        block1: while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].toUpperCase().startsWith(key.toUpperCase())) continue;
                String value = null;
                int idx = args[i].toUpperCase().indexOf(key.toUpperCase() + "=");
                if (idx == -1) {
                    DumpParser.syntax();
                }
                if ((value = args[i].substring((idx = args[i].indexOf("=")) + 1)).length() <= 0) {
                    DumpParser.syntax();
                }
                if (!(!key.equalsIgnoreCase("logLevel") || value.equalsIgnoreCase("ERROR") || value.equalsIgnoreCase("WARN") || value.equalsIgnoreCase("INFO") || value.equalsIgnoreCase("DETAIL") || value.equalsIgnoreCase("DEBUG"))) {
                    DumpParser.syntax();
                }
                if (!(!key.equalsIgnoreCase("analyze") || value.equalsIgnoreCase("WAS") || value.equalsIgnoreCase("EJB") || value.equalsIgnoreCase("SERVLET") || value.equalsIgnoreCase("ALL"))) {
                    DumpParser.syntax();
                }
                _args.put(key.toUpperCase(), new Arg(value));
                continue block1;
            }
        }
    }

    public void parse(DumpData d) throws Exception {
    }

    protected static void logErr(String msg) {
        System.err.println(msg);
    }

    protected static void logWarn(String msg) {
        if (_logLevel >= 1) {
            System.err.println(msg);
        }
    }

    protected static void logInfo(String msg) {
        if (_logLevel >= 2) {
            System.err.println(TAUtils.getNLSValue("ta.button.Info", "INFO") + ": " + msg);
        }
    }

    protected static void logDetail(String msg) {
        if (_logLevel >= 3) {
            System.err.println(msg);
        }
    }

    protected static void logDebug(String msg) {
        if (_logLevel >= 4) {
            System.err.println(msg);
        }
    }

    public int getLogLevel() {
        return _logLevel;
    }

    public static String getArg(String argName) {
        String sRet = null;
        Arg arg = (Arg)_args.get(argName.toUpperCase());
        if (arg != null) {
            sRet = arg.get();
        } else {
            DumpParser.logErr(TAUtils.getNLSValue("ta.errmsg.CantFindArg", "can't find argument") + ": " + argName.toUpperCase());
        }
        return sRet;
    }

    public static void setDumpInName(String inName) {
        _dumpInName = inName;
    }

    public String getDumpingJvmName() {
        return _dumpingJvmName;
    }

    class Arg {
        public String _arg;

        public Arg(String val) {
            this._arg = val;
        }

        public String get() {
            return this._arg;
        }
    }
}

