/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.config.generator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class TestJvm {
    public static boolean isSupportedJava(String path, String minVersion) {
        String ver = TestJvm.jvmVersion(path);
        return TestJvm.isMinimumVersion(minVersion, ver);
    }

    private static String jvmVersion(String path) {
        try {
            Runtime rt = Runtime.getRuntime();
            String cp = System.getProperty("java.class.path");
            String[] env = new String[]{"CLASSPATH=" + cp};
            String[] arg = new String[]{path, "org.eclipse.hyades.internal.config.generator.GetJavaVersion"};
            Process p = rt.exec(arg, env);
            BufferedReader bout = new BufferedReader(new InputStreamReader(p.getInputStream()));
            return bout.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isMinimumVersion(String req, String ver) {
        StringTokenizer stReq = new StringTokenizer(req, "._");
        StringTokenizer stVer = new StringTokenizer(ver, "._");
        try {
            int majReq = 0;
            int majVer = -1;
            if (!stReq.hasMoreTokens()) return false;
            if (!stVer.hasMoreTokens()) {
                return false;
            }
            majReq = Integer.valueOf(stReq.nextToken());
            majVer = Integer.valueOf(stVer.nextToken());
            if (majVer < majReq) {
                return false;
            }
            if (majVer > majReq) {
                return true;
            }
            int minReq = 0;
            int minVer = -1;
            if (!stReq.hasMoreTokens()) return true;
            minReq = Integer.valueOf(stReq.nextToken());
            if (!stVer.hasMoreTokens()) return false;
            minVer = Integer.valueOf(stVer.nextToken());
            if (minVer < minReq) {
                return false;
            }
            if (minVer > minReq) {
                return true;
            }
            int mntReq = 0;
            int mntVer = -1;
            if (!stReq.hasMoreTokens()) return true;
            mntReq = Integer.valueOf(stReq.nextToken());
            if (!stVer.hasMoreTokens()) return false;
            mntVer = Integer.valueOf(stVer.nextToken());
            if (mntVer < mntReq) {
                return false;
            }
            if (mntVer < mntReq) return false;
            return true;
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }
}

