/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.adapter.internal;

import java.util.Enumeration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.ui.TraceViewer;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.adapter.internal.CoveragePage;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.OpenSource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.part.IPage;

public class CoverageViewer
extends TraceViewer {
    protected static final String _title = TraceUIPlugin.getString("STR_COVERAGE_ST_TITLE");
    protected Action _packageLevel;
    protected Action _classLevel;
    protected Action _methodLevel;
    protected Action _openSource;

    public EObject getObjectToView(EObject selObject) {
        if (selObject == null) {
            return selObject;
        }
        if (selObject instanceof TRCProcessProxy) {
            int nbOfAgents = 0;
            TRCAgentProxy a = null;
            EList agents = ((TRCProcessProxy)selObject).getAgentProxies();
            for (int idx = 0; idx < agents.size(); ++idx) {
                TRCAgentProxy agent = (TRCAgentProxy)agents.get(idx);
                if (agent == null || agent.eIsProxy() || !agent.getType().equals("Profiler")) continue;
                ++nbOfAgents;
                a = agent;
            }
            if (nbOfAgents == 1) {
                return a;
            }
        }
        return selObject;
    }

    public TraceViewerPage createPage(EObject mofObject) {
        return new CoveragePage(mofObject, this);
    }

    public String getViewTitle() {
        return _title;
    }

    public void dispose() {
        Enumeration pages = this._pages.elements();
        while (pages.hasMoreElements()) {
            IPage page = (IPage)pages.nextElement();
            if (!(page instanceof CoveragePage)) continue;
            ((CoveragePage)page).dispose();
        }
        this._classLevel = null;
        this._packageLevel = null;
        this._methodLevel = null;
        this._openSource = null;
        if (this.fContextMenu != null) {
            this.fContextMenu.dispose();
        }
        this.fContextMenu = null;
        super.dispose();
    }

    public void setFocus() {
        CoveragePage page = (CoveragePage)this.getCurrentPage();
        if (page != null) {
            page.setFocus();
        }
    }

    public void makeActions() {
        if (this.isInitializedMenu()) {
            return;
        }
        this.initializedMenu(true);
        String strPackageLevel = TraceUIPlugin.getString("STR_ST_PACKAGE_LEVEL");
        this._packageLevel = new Action(strPackageLevel){

            public void run() {
                CoveragePage page = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                if (page.getView().getLevel() == 1) {
                    CoverageViewer.this._packageLevel.setChecked(true);
                } else {
                    CoverageViewer.this._classLevel.setChecked(false);
                    CoverageViewer.this._methodLevel.setChecked(false);
                    page.getView().setLevel(1);
                    page.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._packageLevel.setText(strPackageLevel);
        TracePluginImages.setImageDescriptors((IAction)this._packageLevel, "lcl16", "package_obj.gif");
        this._packageLevel.setDescription(strPackageLevel);
        this._packageLevel.setToolTipText(strPackageLevel);
        this._packageLevel.setEnabled(true);
        this._packageLevel.setChecked(true);
        String strClassLevel = TraceUIPlugin.getString("STR_ST_CLASS_LEVEL");
        this._classLevel = new Action(strClassLevel){

            public void run() {
                CoveragePage page = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                if (page.getView().getLevel() == 2) {
                    CoverageViewer.this._classLevel.setChecked(true);
                } else {
                    CoverageViewer.this._packageLevel.setChecked(false);
                    CoverageViewer.this._methodLevel.setChecked(false);
                    page.getView().setLevel(2);
                    page.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._classLevel.setText(strClassLevel);
        TracePluginImages.setImageDescriptors((IAction)this._classLevel, "lcl16", "class.gif");
        this._classLevel.setDescription(strClassLevel);
        this._classLevel.setToolTipText(strClassLevel);
        this._classLevel.setEnabled(true);
        String strMethodLevel = TraceUIPlugin.getString("STR_ST_METHOD_LEVEL");
        this._methodLevel = new Action(strMethodLevel){

            public void run() {
                CoveragePage page = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                if (page.getView().getLevel() == 3) {
                    CoverageViewer.this._methodLevel.setChecked(true);
                } else {
                    CoverageViewer.this._packageLevel.setChecked(false);
                    CoverageViewer.this._classLevel.setChecked(false);
                    page.getView().setLevel(3);
                    page.getView().redrawTable();
                }
            }

            public int getStyle() {
                return 2;
            }
        };
        this._methodLevel.setText(strMethodLevel);
        TracePluginImages.setImageDescriptors((IAction)this._methodLevel, "lcl16", "methods_co.gif");
        this._methodLevel.setDescription(strMethodLevel);
        this._methodLevel.setToolTipText(strMethodLevel);
        this._methodLevel.setEnabled(true);
        String openSourceStr = TraceUIPlugin.getString("STR_SOURCE");
        this._openSource = new Action(openSourceStr){

            public void run() {
                CoveragePage page = (CoveragePage)CoverageViewer.this.getCurrentPage();
                if (page == null) {
                    return;
                }
                OpenSource.openSource(UIPlugin.getDefault().getSelectionModel(page.getMOFObject()).getFirstElement());
            }
        };
        this._openSource.setText(openSourceStr);
        TracePluginImages.setImageDescriptors((IAction)this._openSource, "tool16", "opensource_co.gif");
        this._openSource.setDescription(openSourceStr);
        this._openSource.setToolTipText(openSourceStr);
        this._openSource.setEnabled(false);
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.removeAll();
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._packageLevel);
        tbm.add((IAction)this._classLevel);
        tbm.add((IAction)this._methodLevel);
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)this._openSource);
        this.getViewSite().getActionBars().updateActionBars();
    }

    public Action getClassLevel() {
        return this._classLevel;
    }

    public Action getMethodLevel() {
        return this._methodLevel;
    }

    public Action getPackageLevel() {
        return this._packageLevel;
    }

    public Action openSource() {
        return this._openSource;
    }
}

