/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCFullTraceObject;
import org.eclipse.hyades.models.trace.TRCHeapObject;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.ClassInstanceStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class ClassInstanceStatistic
extends StatisticView {
    private final TRCClassImpl.TRCClassSnapshot class1Delta = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot class2Delta = new TRCClassImpl.TRCClassSnapshot();

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public ClassInstanceStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new ClassStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "ClassI60";
    }

    public String getDefaultColumnsTemplate() {
        String classColumn = TraceUIPlugin.getString("STR_ST_CLASS_NAME") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_PACKAGE") + ":1:" + String.valueOf(1) + ":left:100," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":4:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":6:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":10:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":11:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":12:" + String.valueOf(16) + ":right:100";
        return classColumn;
    }

    protected IContentProvider getContentProvider() {
        return new ClassStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new ClassStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite table) {
        ClassTreeViewer tv = new ClassTreeViewer((TableTree)table);
        return tv;
    }

    protected void handleSelectionEvent() {
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).openSource().setEnabled(false);
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            Object sel = model.getFirstElement();
            if (sel instanceof TRCMethod) {
                sel = ((TRCMethod)sel).getDefiningClass();
            } else if (sel instanceof TRCObject) {
                this.select((TRCObject)sel);
            } else if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            } else if (sel instanceof TRCMethodInvocation) {
                this.select(PerftraceUtil.getClass((TRCMethodInvocation)sel));
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getUpdateAction());
        menu.add((IContributionItem)this.fSeparator);
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(TRCObject obj) {
        boolean isClassObject = true;
        TRCClass cls = obj.getIsA();
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            TableTreeItem item = items[idx];
            if (item.getData() != cls) continue;
            ((ClassTreeViewer)this.getTableViewer()).expandItem(item);
            TableTreeItem[] childItems = item.getItems();
            for (int i = 0; i < childItems.length; ++i) {
                TableTreeItem childItem = childItems[i];
                if (obj != childItem.getData()) continue;
                ((ClassTreeViewer)this.getTableViewer()).expandItem(item);
                table.setSelection(new TableTreeItem[]{childItem});
                return;
            }
        }
        table.deselectAll();
    }

    private void select(TRCClass obj) {
        TableTree table = ((TableTreeViewer)this.getTableViewer()).getTableTree();
        TableTreeItem[] items = table.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            Object data = items[idx].getData();
            if (data == null || data != obj) continue;
            table.setSelection(new TableTreeItem[]{items[idx]});
            return;
        }
        table.deselectAll();
    }

    public void updateButtons() {
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((ClassInstanceStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            itemData = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn firstColumn = table.getColumn(0);
            this._viewerSorter = new ClassStatisticSorter();
            this.getViewerSorter().setSortedColumn(firstColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        return PerftraceUtil.getAllClasses(this._page.getMOFObject()).length <= 0;
    }

    class ClassTreeViewer
    extends TableTreeViewer {
        public ClassTreeViewer(Composite parent) {
            super(parent);
        }

        public ClassTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class ClassStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public ClassStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                if (((TRCClass)obj).computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14) < 0) {
                    if (col == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (pos) {
                    case 2: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        state = ClassInstanceStatistic.this.class1Delta.getTotalInstances();
                        break;
                    }
                    case 3: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        state = ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        state = ClassInstanceStatistic.this.class1Delta.getCollectedInstances();
                        break;
                    }
                    case 5: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        state = ClassInstanceStatistic.this.class1Delta.getTotalSize();
                        break;
                    }
                    case 6: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        state = ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize();
                        break;
                    }
                    case 7: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                        d = ClassInstanceStatistic.this.class1Delta.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 8: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                        d = ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 9: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                        d = ClassInstanceStatistic.this.class1Delta.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 10: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                        d = ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 11: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        state = ClassInstanceStatistic.this.class1Delta.getCalls();
                        break;
                    }
                    case 12: {
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        state = ClassInstanceStatistic.this.class1Delta.getInheritedCalls();
                    }
                }
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCClass) {
                TRCClass clas = (TRCClass)obj;
                TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)clas.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return clas.getName();
                    }
                    case 1: {
                        return PerftraceUtil.getPackageName(clas.getPackage(), ClassInstanceStatistic.this._page.getMOFObject()).toString();
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalInstances() / (double)ClassInstanceStatistic.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalInstances());
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((double)cs.getTotalInstances() - (double)cs.getCollectedInstances()) / (double)ClassInstanceStatistic.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances() - cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                int inst = clas.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return TString.formatAsPercentage((double)((double)cs.getCollectedInstances() / (double)inst));
                            }
                            return String.valueOf(cs.getCollectedInstances());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getCollectedInstances());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalSize() / (double)ClassInstanceStatistic.this._totalSize));
                            }
                            return String.valueOf(cs.getTotalSize());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalSize());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((double)cs.getTotalSize() - (double)cs.getCollectedSize()) / (double)ClassInstanceStatistic.this._activeSize));
                            }
                            return String.valueOf(cs.getTotalSize() - cs.getCollectedSize());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getBaseTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getBaseTime());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getBaseTime());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedBaseTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedBaseTime());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getCumulativeTime());
                    }
                    case 10: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedCumulativeTime());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                        return TString.formatTimeValue((double)ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime());
                    }
                    case 11: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getCalls());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getCalls());
                    }
                    case 12: {
                        if (!info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getInheritedCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getInheritedCalls());
                        }
                        clas.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        return String.valueOf(ClassInstanceStatistic.this.class1Delta.getInheritedCalls());
                    }
                }
            } else {
                if (info.isDeltaColumn()) {
                    return "";
                }
                TRCObject object = (TRCObject)obj;
                switch (pos) {
                    case 0: {
                        TRCClass clas = PerftraceUtil.getClass(object);
                        if (clas == object.getProcess().getClassClass()) {
                            return clas.getName();
                        }
                        return clas.getName() + "." + object.getId();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                    case 3: {
                        return "";
                    }
                    case 4: {
                        if (object instanceof TRCFullTraceObject) {
                            if (((TRCFullTraceObject)object).getCollectTime() == 0.0) {
                                return "0";
                            }
                            return "1";
                        }
                        return "";
                    }
                    case 5: {
                        return String.valueOf(((TRCObject)obj).getSize());
                    }
                    case 6: {
                        if (object instanceof TRCFullTraceObject) {
                            if (((TRCFullTraceObject)object).getCollectTime() != 0.0) {
                                return "0";
                            }
                            return String.valueOf(object.getSize());
                        }
                        return "0";
                    }
                    case 7: {
                        if (object instanceof TRCFullTraceObject) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((TRCFullTraceObject)object).getBaseTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)((TRCFullTraceObject)object).getBaseTime());
                        }
                        return "";
                    }
                    case 9: {
                        if (object instanceof TRCFullTraceObject) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(((TRCFullTraceObject)object).getCumulativeTime() / ClassInstanceStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)((TRCFullTraceObject)object).getCumulativeTime());
                        }
                        return "";
                    }
                    case 11: {
                        if (object instanceof TRCFullTraceObject) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)((TRCFullTraceObject)object).getCalls() / (double)ClassInstanceStatistic.this._totalCalls));
                            }
                            return String.valueOf(((TRCFullTraceObject)object).getCalls());
                        }
                        return "";
                    }
                }
            }
            return "";
        }
    }

    public class ClassStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCObject) {
                PerftraceUtil.getClass((TRCObject)element);
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return PerftraceUtil.getAllClasses(ClassInstanceStatistic.this._page.getMOFObject());
        }

        public Object[] getChildren(Object element) {
            ClassInstanceStatistic.this.tmpList.clear();
            if (element instanceof TRCClass) {
                TRCClass cls = (TRCClass)element;
                Object[] classObjects = cls.getClassObjects().toArray();
                ClassInstanceStatistic.this.tmpList.addAll(cls.getClassObjects());
                ClassInstanceStatistic.this.tmpList.addAll(cls.getObjects());
            }
            return ClassInstanceStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            TRCClass cls;
            return element instanceof TRCClass && ((cls = (TRCClass)element).getClassObjects().size() > 0 || cls.getObjects().size() > 0);
        }
    }

    public class ClassStatisticSorter
    extends StatisticView.StatisticSorter {
        public ClassStatisticSorter() {
            super(ClassInstanceStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCClass) {
                TRCClass c1 = (TRCClass)e1;
                TRCClass c2 = (TRCClass)e2;
                TRCClassImpl.TRCClassSnapshot cs1 = (TRCClassImpl.TRCClassSnapshot)c1.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot cs2 = (TRCClassImpl.TRCClassSnapshot)c2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * c1.getName().compareToIgnoreCase(c2.getName());
                    }
                    case 1: {
                        return this._sortSequence * c1.getPackage().getName().compareToIgnoreCase(c2.getPackage().getName());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs2.getTotalInstances());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 14);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class2Delta.getTotalInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs1.getCollectedInstances() - cs2.getTotalInstances() + cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 14);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 14);
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 16);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalInstances() - ClassInstanceStatistic.this.class1Delta.getCollectedInstances() - (ClassInstanceStatistic.this.class2Delta.getTotalInstances() - ClassInstanceStatistic.this.class2Delta.getCollectedInstances()));
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            if (ClassInstanceStatistic.this.isShowPercent()) {
                                int inst = cs1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)cs1.getCollectedInstances() / (double)inst;
                                inst = cs2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)cs2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (cs1.getCollectedInstances() - cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 16);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 16);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getCollectedInstances() - ClassInstanceStatistic.this.class2Delta.getCollectedInstances());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs2.getTotalSize());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 13);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class2Delta.getTotalSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs1.getCollectedSize() - ((TRCClass)e2).getTotalSize() + ((TRCClass)e2).getCollectedSize());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 13);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 13);
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 15);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 15);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getTotalSize() - ClassInstanceStatistic.this.class1Delta.getCollectedSize() - (ClassInstanceStatistic.this.class2Delta.getTotalSize() - ClassInstanceStatistic.this.class2Delta.getCollectedSize()));
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getBaseTime() - cs2.getBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 7);
                            c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 7);
                            d = ClassInstanceStatistic.this.class1Delta.getBaseTime() - ClassInstanceStatistic.this.class2Delta.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedBaseTime() - cs2.getInheritedBaseTime();
                        } else {
                            c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 11);
                            c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 11);
                            d = ClassInstanceStatistic.this.class1Delta.getInheritedBaseTime() - ClassInstanceStatistic.this.class2Delta.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getCumulativeTime() - cs2.getCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 8);
                            c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 8);
                            d = ClassInstanceStatistic.this.class1Delta.getCumulativeTime() - ClassInstanceStatistic.this.class2Delta.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedCumulativeTime() - cs2.getInheritedCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 12);
                            c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 12);
                            d = ClassInstanceStatistic.this.class1Delta.getInheritedCumulativeTime() - ClassInstanceStatistic.this.class2Delta.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getCalls() - cs2.getCalls());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 9);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 9);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getCalls() - ClassInstanceStatistic.this.class2Delta.getCalls());
                    }
                    case 12: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getInheritedCalls() - cs2.getInheritedCalls());
                        }
                        c1.computeDelta((IDelta)ClassInstanceStatistic.this.class1Delta, 10);
                        c2.computeDelta((IDelta)ClassInstanceStatistic.this.class2Delta, 10);
                        return this._sortSequence * (ClassInstanceStatistic.this.class1Delta.getInheritedCalls() - ClassInstanceStatistic.this.class2Delta.getInheritedCalls());
                    }
                }
            } else {
                TRCObject obj1 = (TRCObject)e1;
                TRCObject obj2 = (TRCObject)e2;
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * (int)(obj1.getId() - obj2.getId());
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 0;
                    }
                    case 3: {
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            int live1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 1 : 0;
                            int live2 = class2.getCollectedSize() == 0 ? 1 : 0;
                            return this._sortSequence * (live1 - live2);
                        }
                        if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            int live2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 1 : 0;
                            int live1 = class1.getCollectedSize() == 0 ? 1 : 0;
                            return this._sortSequence * (live1 - live2);
                        }
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            int live1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 1 : 0;
                            int live2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 1 : 0;
                            return this._sortSequence * (live1 - live2);
                        }
                        return 0;
                    }
                    case 4: {
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            int collected1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 0 : 1;
                            int collected2 = class2.getCollectedSize() == 0 ? 0 : 1;
                            return this._sortSequence * (collected1 - collected2);
                        }
                        if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            int collected2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 0 : 1;
                            int collected1 = class1.getCollectedSize() == 0 ? 0 : 1;
                            return this._sortSequence * (collected1 - collected2);
                        }
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            int collected1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? 0 : 1;
                            int collected2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? 0 : 1;
                            return this._sortSequence * (collected1 - collected2);
                        }
                        return 0;
                    }
                    case 5: {
                        return this._sortSequence * (obj1.getSize() - obj2.getSize());
                    }
                    case 6: {
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            int activeSize1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                            int activeSize2 = class2.getCollectedSize() == 0 ? class2.getSize() : 0;
                            return this._sortSequence * (activeSize1 - activeSize2);
                        }
                        if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            int activeSize2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                            int activeSize1 = class1.getCollectedSize() == 0 ? class1.getSize() : 0;
                            return this._sortSequence * (activeSize1 - activeSize2);
                        }
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            int activeSize1 = ((TRCFullTraceObject)obj1).getCollectTime() == 0.0 ? obj1.getSize() : 0;
                            int activeSize2 = ((TRCFullTraceObject)obj2).getCollectTime() == 0.0 ? obj2.getSize() : 0;
                            return this._sortSequence * (activeSize1 - activeSize2);
                        }
                        return 0;
                    }
                    case 7: {
                        d = 0.0;
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            double baseTime1 = ((TRCFullTraceObject)obj1).getBaseTime();
                            double baseTime2 = class2.getBaseTime();
                            d = baseTime1 - baseTime2;
                        } else if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            double baseTime2 = ((TRCFullTraceObject)obj2).getBaseTime();
                            double baseTime1 = class1.getBaseTime();
                            d = baseTime1 - baseTime2;
                        } else if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            d = ((TRCFullTraceObject)obj1).getBaseTime() - ((TRCFullTraceObject)obj2).getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        d = 0.0;
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            double time1 = ((TRCFullTraceObject)obj1).getCumulativeTime();
                            double time2 = class2.getCumulativeTime();
                            d = time1 - time2;
                        } else if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            double time2 = ((TRCFullTraceObject)obj2).getCumulativeTime();
                            double time1 = class1.getCumulativeTime();
                            d = time1 - time2;
                        } else if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            d = ((TRCFullTraceObject)obj1).getCumulativeTime() - ((TRCFullTraceObject)obj2).getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 11: {
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCHeapObject) {
                            TRCHeapObject object2 = (TRCHeapObject)e2;
                            TRCClass class2 = PerftraceUtil.getClass((TRCObject)object2);
                            return this._sortSequence * (((TRCFullTraceObject)obj1).getCalls() - class2.getCalls());
                        }
                        if (obj1 instanceof TRCHeapObject && obj2 instanceof TRCFullTraceObject) {
                            TRCHeapObject object1 = (TRCHeapObject)e1;
                            TRCClass class1 = PerftraceUtil.getClass((TRCObject)object1);
                            return this._sortSequence * (class1.getCalls() - ((TRCFullTraceObject)obj2).getCalls());
                        }
                        if (obj1 instanceof TRCFullTraceObject && obj2 instanceof TRCFullTraceObject) {
                            return this._sortSequence * (((TRCFullTraceObject)obj1).getCalls() - ((TRCFullTraceObject)obj2).getCalls());
                        }
                        return 0;
                    }
                }
            }
            return 0;
        }
    }

    public class ClassStatisticFilter
    extends StatisticView.StatisticFilter {
        public ClassStatisticFilter() {
            super(ClassInstanceStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCClass)) {
                return true;
            }
            String compareText = "";
            if (this._noPattern) {
                return true;
            }
            if (element instanceof TRCClass) {
                compareText = ((TRCClass)element).getName();
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                for (int k = 0; k < this._textList.size(); ++k) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                }
            }
            return flag;
        }
    }
}

