/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.trace.views.internal;

import java.util.ArrayList;
import org.eclipse.hyades.loaders.trace.IDelta;
import org.eclipse.hyades.models.trace.TRCClass;
import org.eclipse.hyades.models.trace.TRCMethod;
import org.eclipse.hyades.models.trace.TRCMethodInvocation;
import org.eclipse.hyades.models.trace.TRCObject;
import org.eclipse.hyades.models.trace.TRCPackage;
import org.eclipse.hyades.models.trace.impl.TRCClassImpl;
import org.eclipse.hyades.models.trace.impl.TRCPackageImpl;
import org.eclipse.hyades.trace.ui.ITraceSelection;
import org.eclipse.hyades.trace.ui.TraceViewerPage;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.ViewSelectionChangedEvent;
import org.eclipse.hyades.trace.ui.internal.util.TString;
import org.eclipse.hyades.trace.views.adapter.internal.PackageStatisticPage;
import org.eclipse.hyades.trace.views.internal.StatisticView;
import org.eclipse.hyades.trace.views.internal.TracePluginImages;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;
import org.eclipse.hyades.trace.views.util.internal.PerftraceUtil;
import org.eclipse.hyades.trace.views.util.internal.StatisticTableColumnInfo;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class PackageStatistic
extends StatisticView {
    private final TRCPackageImpl.TRCPackageSnapshot pdelta1 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCPackageImpl.TRCPackageSnapshot pdelta2 = new TRCPackageImpl.TRCPackageSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta1 = new TRCClassImpl.TRCClassSnapshot();
    private final TRCClassImpl.TRCClassSnapshot cdelta2 = new TRCClassImpl.TRCClassSnapshot();

    protected Composite createTable(Composite parent, int options) {
        return new TableTree(parent, options);
    }

    public PackageStatistic(Composite parent, TraceViewerPage page) {
        super(parent, page);
        this._viewerFilter = new PackageStatisticFilter();
    }

    public String getColumnsPreferencesKey() {
        return "Pack60";
    }

    public String getDefaultColumnsTemplate() {
        String classColumn = TraceUIPlugin.getString("STR_ST_PACKAGE") + ":0:" + String.valueOf(7) + ":left:200," + TraceUIPlugin.getString("STR_ST_INSTANCES") + ":1:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_INSTANCES") + ":2:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_COLLECTED") + ":3:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_SIZE") + ":4:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_LIVE_STORAGE") + ":5:" + String.valueOf(17) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_TIME") + ":6:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CPU_INHTIME") + ":7:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_TIME") + ":8:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_STACK_INHTIME") + ":9:" + String.valueOf(16) + ":right:100," + TraceUIPlugin.getString("STR_ST_CALLS") + ":10:" + String.valueOf(16) + ":right:50," + TraceUIPlugin.getString("STR_ST_INHCALLS") + ":11:" + String.valueOf(16) + ":right:100";
        return classColumn;
    }

    protected IContentProvider getContentProvider() {
        return new PackageStatisticContentProvider();
    }

    public LabelProvider getTableLabelProvider() {
        return new PackageStatisticLabelProvider(this);
    }

    public Table getTable() {
        return ((TableTree)this.getTableViewer().getControl()).getTable();
    }

    protected StructuredViewer createTableViewer(Composite table) {
        PackageTreeViewer tv = new PackageTreeViewer((TableTree)table);
        return tv;
    }

    protected void handleSelectionEvent() {
        ITraceSelection model = UIPlugin.getDefault().getSelectionModel(this._page.getMOFObject());
        if (model.size() > 0) {
            Object sel = model.getFirstElement();
            if (sel instanceof TRCMethod) {
                sel = ((TRCMethod)sel).getDefiningClass();
            } else if (sel instanceof TRCMethodInvocation) {
                sel = ((TRCMethodInvocation)sel).getMethod().getDefiningClass();
            }
            if (sel instanceof TRCObject) {
                this.select(PerftraceUtil.getClass((TRCObject)sel));
            }
            if (sel instanceof TRCClass) {
                this.select((TRCClass)sel);
            }
        }
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IAction)this.getUpdateAction());
        menu.add((IAction)this.getChooseColumnsAction(this.getColumnDataList(), this.getColumnsPreferencesKey()));
    }

    private void select(Object obj) {
        TableTree table = (TableTree)this.getTableViewer().getControl();
        TRCClass cls = null;
        TRCPackage pack = null;
        if (obj instanceof TRCPackage) {
            pack = (TRCPackage)obj;
        } else if (obj instanceof TRCClass) {
            cls = (TRCClass)obj;
            pack = cls.getPackage();
        }
        TableTreeItem[] items = table.getItems();
        for (int idx = 0; idx < items.length; ++idx) {
            TableTreeItem item = items[idx];
            if (!((TRCPackage)item.getData()).getName().equals(pack.getName())) continue;
            if (cls == null) {
                table.setSelection(new TableTreeItem[]{item});
                return;
            }
            ((PackageTreeViewer)this.getTableViewer()).expandItem(item);
            TableTreeItem[] childItems = item.getItems();
            for (int i = 0; i < childItems.length; ++i) {
                TableTreeItem childItem = childItems[i];
                if (!((TRCClass)childItem.getData()).getName().equals(cls.getName())) continue;
                ((PackageTreeViewer)this.getTableViewer()).expandItem(item);
                table.setSelection(new TableTreeItem[]{childItem});
                return;
            }
        }
        table.deselectAll();
    }

    public void updateButtons() {
        ((PackageStatisticPage)this.getTraceViewerPage()).deltaColumns().setChecked(this.showingDeltaColumns());
        ((PackageStatisticPage)this.getTraceViewerPage()).percentMode().setChecked(this.isShowPercent());
    }

    protected void updateDetailsPane() {
        int selIndex = this.getTable().getSelectionIndex();
        if (selIndex < 0) {
            return;
        }
        TableItem item = this.getTable().getItem(selIndex);
        Object itemData = item.getData();
        if (itemData == null) {
            return;
        }
        if (itemData != null && itemData instanceof TableTreeItem) {
            itemData = ((TableTreeItem)itemData).getData();
        }
    }

    public void updateModelSelection() {
        ISelection selection = this.getTableViewer().getSelection();
        if (selection != null && !selection.isEmpty()) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            this.notifyViewSelectionChanged(this, sel);
        }
    }

    public void update() {
        if (this._firstTime) {
            this.getTableViewer().addFilter((ViewerFilter)this.getViewerFilter());
            this._firstTime = false;
            Table table = this.getTable();
            TableColumn firstColumn = table.getColumn(0);
            this._viewerSorter = new PackageStatisticSorter();
            this.getViewerSorter().setSortedColumn(firstColumn);
            this.getTableViewer().setSorter((ViewerSorter)this.getViewerSorter());
        }
        if (this.isShowPercent()) {
            this._totalCalls = PerftraceUtil.getTotalCalls(this._page.getMOFObject());
            this._totalInst = PerftraceUtil.getTotalInstances(this._page.getMOFObject());
            this._activeInst = PerftraceUtil.getActiveInstances(this._page.getMOFObject());
            this._totalSize = PerftraceUtil.getTotalSize(this._page.getMOFObject());
            this._activeSize = PerftraceUtil.getActiveSize(this._page.getMOFObject());
            this._maxTime = PerftraceUtil.getMaximumTime(this._page.getMOFObject());
        }
        this.getTableViewer().setInput((Object)this._page.getMOFObject());
        this.getTable().setRedraw(false);
        this.getTableViewer().refresh();
        this.getTable().setRedraw(true);
        this.handleSelectionEvent();
    }

    public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event) {
        Object source = event.getSource();
        if (source != this) {
            this.handleSelectionEvent();
        }
    }

    public boolean isEmpty() {
        Object[] packages = PerftraceUtil.getAllPackages(this._page.getMOFObject());
        int size = 0;
        for (int idx = 0; idx < packages.length; ++idx) {
            TRCPackage pack = (TRCPackage)packages[idx];
            size += pack.getClasses().size();
        }
        return size <= 0;
    }

    class PackageTreeViewer
    extends TableTreeViewer {
        public PackageTreeViewer(Composite parent) {
            super(parent);
        }

        public PackageTreeViewer(TableTree table) {
            super(table);
        }

        public void expandItem(TableTreeItem item) {
            item.setExpanded(true);
            this.createChildren((Widget)item);
        }
    }

    public class PackageStatisticLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected StatisticView _viewer;

        public PackageStatisticLabelProvider(StatisticView viewer) {
            this._viewer = viewer;
        }

        public Image getColumnImage(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (info.isDeltaColumn()) {
                return null;
            }
            int state = 0;
            double d = 0.0;
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                if (p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8) < 0) {
                    if (col == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (pos) {
                    case 1: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        state = PackageStatistic.this.pdelta1.getTotalInstances();
                        break;
                    }
                    case 2: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        state = PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 3: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        state = PackageStatistic.this.pdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        state = PackageStatistic.this.pdelta1.getTotalSize();
                        break;
                    }
                    case 5: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        state = PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize();
                        break;
                    }
                    case 6: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                        d = PackageStatistic.this.pdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 7: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                        d = PackageStatistic.this.pdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 8: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                        d = PackageStatistic.this.pdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 9: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                        d = PackageStatistic.this.pdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 10: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        state = PackageStatistic.this.pdelta1.getCalls();
                        break;
                    }
                    case 11: {
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        state = PackageStatistic.this.pdelta1.getInheritedCalls();
                    }
                }
            } else {
                TRCClass clas = (TRCClass)obj;
                if (((TRCClass)obj).computeDelta((IDelta)PackageStatistic.this.cdelta1, 14) < 0) {
                    if (col == 1) {
                        return TracePluginImages.getImage("newentry_obj.gif");
                    }
                    return null;
                }
                switch (pos) {
                    case 1: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        state = PackageStatistic.this.cdelta1.getTotalInstances();
                        break;
                    }
                    case 2: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        state = PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 3: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        state = PackageStatistic.this.cdelta1.getCollectedInstances();
                        break;
                    }
                    case 4: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        state = PackageStatistic.this.cdelta1.getTotalSize();
                        break;
                    }
                    case 5: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        state = PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize();
                        break;
                    }
                    case 6: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                        d = PackageStatistic.this.cdelta1.getBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 7: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                        d = PackageStatistic.this.cdelta1.getInheritedBaseTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 8: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                        d = PackageStatistic.this.cdelta1.getCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 9: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                        d = PackageStatistic.this.cdelta1.getInheritedCumulativeTime();
                        if (d < 0.0) {
                            state = -1;
                            break;
                        }
                        if (!(d > 0.0)) break;
                        state = 1;
                        break;
                    }
                    case 10: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        state = PackageStatistic.this.cdelta1.getCalls();
                        break;
                    }
                    case 11: {
                        clas.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        state = PackageStatistic.this.cdelta1.getInheritedCalls();
                    }
                }
            }
            if (state < 0) {
                return TracePluginImages.getImage("decreasedvalue_obj.gif");
            }
            if (state > 0) {
                return TracePluginImages.getImage("increasedvalue_obj.gif");
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            StatisticTableColumnInfo info = StatisticTableColumnInfo.getStatisticTableColumnInfo(this._viewer.getTable().getColumn(col));
            int pos = info.getColumnData().getInitalPos();
            if (obj instanceof TRCPackage) {
                TRCPackage p = (TRCPackage)obj;
                TRCPackageImpl.TRCPackageSnapshot ps = (TRCPackageImpl.TRCPackageSnapshot)p.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return PerftraceUtil.getPackageName(p, PackageStatistic.this._page.getMOFObject()).toString();
                    }
                    case 1: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getTotalInstances() / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(ps.getTotalInstances());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalInstances());
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(ps.getTotalInstances() - ps.getCollectedInstances()) / (double)PackageStatistic.this._activeInst));
                            }
                            return String.valueOf(ps.getTotalInstances() - ps.getCollectedInstances());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances());
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int inst = ps.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return TString.formatAsPercentage((double)((double)ps.getCollectedInstances() / (double)inst));
                            }
                            return String.valueOf(ps.getCollectedInstances());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        return String.valueOf(PackageStatistic.this.pdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getTotalSize() / (double)PackageStatistic.this._totalSize));
                            }
                            return String.valueOf(ps.getTotalSize());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalSize());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(ps.getTotalSize() - ps.getCollectedSize()) / (double)PackageStatistic.this._activeSize));
                            }
                            return String.valueOf(ps.getTotalSize() - ps.getCollectedSize());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        return String.valueOf(PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getBaseTime());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getBaseTime());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getInheritedBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getInheritedBaseTime());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getInheritedBaseTime());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getCumulativeTime());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getCumulativeTime());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(ps.getInheritedCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)ps.getInheritedCumulativeTime());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                        return TString.formatTimeValue((double)PackageStatistic.this.pdelta1.getInheritedCumulativeTime());
                    }
                    case 10: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(ps.getCalls());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        return String.valueOf(PackageStatistic.this.pdelta1.getCalls());
                    }
                    case 11: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)ps.getInheritedCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(ps.getInheritedCalls());
                        }
                        p.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        return String.valueOf(PackageStatistic.this.pdelta1.getInheritedCalls());
                    }
                }
            } else {
                TRCClass c = (TRCClass)obj;
                TRCClassImpl.TRCClassSnapshot cs = (TRCClassImpl.TRCClassSnapshot)c.retrieveSnapshot();
                switch (pos) {
                    case 0: {
                        return c.getName();
                    }
                    case 1: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalInstances() / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalInstances());
                    }
                    case 2: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(cs.getTotalInstances() - cs.getCollectedInstances()) / (double)PackageStatistic.this._totalInst));
                            }
                            return String.valueOf(cs.getTotalInstances() - cs.getCollectedInstances());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 3: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int inst = cs.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return TString.formatAsPercentage((double)((double)cs.getCollectedInstances() / (double)inst));
                            }
                            return String.valueOf(cs.getCollectedInstances());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        return String.valueOf(PackageStatistic.this.cdelta1.getCollectedInstances());
                    }
                    case 4: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getTotalSize() / (double)PackageStatistic.this._totalSize));
                            }
                            return String.valueOf(cs.getTotalSize());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalSize());
                    }
                    case 5: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)(cs.getTotalSize() - cs.getCollectedSize()) / (double)PackageStatistic.this._activeSize));
                            }
                            return String.valueOf(cs.getTotalSize() - cs.getCollectedSize());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        return String.valueOf(PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize());
                    }
                    case 6: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getBaseTime());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getBaseTime());
                    }
                    case 7: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedBaseTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedBaseTime());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getInheritedBaseTime());
                    }
                    case 8: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getCumulativeTime());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getCumulativeTime());
                    }
                    case 9: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)(cs.getInheritedCumulativeTime() / PackageStatistic.this._maxTime));
                            }
                            return TString.formatTimeValue((double)cs.getInheritedCumulativeTime());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                        return TString.formatTimeValue((double)PackageStatistic.this.cdelta1.getInheritedCumulativeTime());
                    }
                    case 10: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getCalls());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        return String.valueOf(PackageStatistic.this.cdelta1.getCalls());
                    }
                    case 11: {
                        if (!info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                return TString.formatAsPercentage((double)((double)cs.getInheritedCalls() / (double)PackageStatistic.this._totalCalls));
                            }
                            return String.valueOf(cs.getInheritedCalls());
                        }
                        c.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        return String.valueOf(PackageStatistic.this.cdelta1.getInheritedCalls());
                    }
                }
            }
            return "";
        }
    }

    public class PackageStatisticContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public Object getParent(Object element) {
            if (element instanceof TRCClass) {
                return ((TRCClass)element).getPackage();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Object[] packages = PerftraceUtil.getAllPackages(PackageStatistic.this._page.getMOFObject());
            ArrayList<TRCPackage> list = new ArrayList<TRCPackage>();
            for (int idx = 0; idx < packages.length; ++idx) {
                TRCPackage pack = (TRCPackage)packages[idx];
                if (pack.getClasses().size() <= 0) continue;
                list.add(pack);
            }
            return list.toArray();
        }

        public Object[] getChildren(Object element) {
            PackageStatistic.this.tmpList.clear();
            if (element instanceof TRCPackage) {
                return ((TRCPackage)element).getClasses().toArray();
            }
            return PackageStatistic.this.tmpList.toArray();
        }

        public boolean hasChildren(Object element) {
            return element instanceof TRCPackage;
        }
    }

    public class PackageStatisticSorter
    extends StatisticView.StatisticSorter {
        public PackageStatisticSorter() {
            super(PackageStatistic.this);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            double d = 0.0;
            if (e1 instanceof TRCPackage) {
                TRCPackage p1 = (TRCPackage)e1;
                TRCPackage p2 = (TRCPackage)e2;
                TRCPackageImpl.TRCPackageSnapshot ps1 = (TRCPackageImpl.TRCPackageSnapshot)p1.retrieveSnapshot();
                TRCPackageImpl.TRCPackageSnapshot ps2 = (TRCPackageImpl.TRCPackageSnapshot)p2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * p1.getName().compareToIgnoreCase(p2.getName());
                    }
                    case 1: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalInstances() - ps2.getTotalInstances());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 8);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta2.getTotalInstances());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalInstances() - ps1.getCollectedInstances() - p2.getTotalInstances() + p2.getCollectedInstances());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 8);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 8);
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalInstances() - PackageStatistic.this.pdelta1.getCollectedInstances() - PackageStatistic.this.pdelta2.getTotalInstances() + PackageStatistic.this.pdelta2.getCollectedInstances());
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int inst = ps1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)ps1.getCollectedInstances() / (double)inst;
                                inst = ps2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)ps2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (ps1.getCollectedInstances() - ps2.getCollectedInstances());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 10);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getCollectedInstances() - PackageStatistic.this.pdelta2.getCollectedInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalSize() - ps2.getTotalSize());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 7);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta2.getTotalSize());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getTotalSize() - ps1.getCollectedSize() - p2.getTotalSize() + p2.getCollectedSize());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 7);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 7);
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 9);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 9);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getTotalSize() - PackageStatistic.this.pdelta1.getCollectedSize() - PackageStatistic.this.pdelta2.getTotalSize() + PackageStatistic.this.pdelta2.getCollectedSize());
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getBaseTime() - ps2.getBaseTime();
                        } else {
                            p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 1);
                            p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 1);
                            d = PackageStatistic.this.pdelta1.getBaseTime() - PackageStatistic.this.pdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getInheritedBaseTime() - ps2.getInheritedBaseTime();
                        } else {
                            p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 5);
                            p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 5);
                            d = PackageStatistic.this.pdelta1.getInheritedBaseTime() - PackageStatistic.this.pdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getCumulativeTime() - ps2.getCumulativeTime();
                        } else {
                            p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 2);
                            p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 2);
                            d = PackageStatistic.this.pdelta1.getCumulativeTime() - PackageStatistic.this.pdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = ps1.getInheritedCumulativeTime() - ps2.getInheritedCumulativeTime();
                        } else {
                            p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 6);
                            p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 6);
                            d = PackageStatistic.this.pdelta1.getInheritedCumulativeTime() - PackageStatistic.this.pdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getCalls() - ps2.getCalls());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 3);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 3);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getCalls() - PackageStatistic.this.pdelta2.getCalls());
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (ps1.getInheritedCalls() - ps2.getInheritedCalls());
                        }
                        p1.computeDelta((IDelta)PackageStatistic.this.pdelta1, 4);
                        p2.computeDelta((IDelta)PackageStatistic.this.pdelta2, 4);
                        return this._sortSequence * (PackageStatistic.this.pdelta1.getInheritedCalls() - PackageStatistic.this.pdelta2.getInheritedCalls());
                    }
                }
            } else {
                TRCClass c1 = (TRCClass)e1;
                TRCClass c2 = (TRCClass)e2;
                TRCClassImpl.TRCClassSnapshot cs1 = (TRCClassImpl.TRCClassSnapshot)c1.retrieveSnapshot();
                TRCClassImpl.TRCClassSnapshot cs2 = (TRCClassImpl.TRCClassSnapshot)c2.retrieveSnapshot();
                switch (this._pos) {
                    case 0: {
                        return this._sortSequence * c1.getName().compareToIgnoreCase(c2.getName());
                    }
                    case 1: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs2.getTotalInstances());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 14);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta2.getTotalInstances());
                    }
                    case 2: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalInstances() - cs1.getCollectedInstances() - c2.getTotalInstances() + c2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 14);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 14);
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 16);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalInstances() - PackageStatistic.this.cdelta1.getCollectedInstances() - (PackageStatistic.this.cdelta2.getTotalInstances() - PackageStatistic.this.cdelta2.getCollectedInstances()));
                    }
                    case 3: {
                        if (!this._info.isDeltaColumn()) {
                            if (PackageStatistic.this.isShowPercent()) {
                                int inst = cs1.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                double size = (double)cs1.getCollectedInstances() / (double)inst;
                                inst = cs2.getTotalInstances();
                                if (inst == 0) {
                                    inst = 1;
                                }
                                return this._sortSequence * (int)((size -= (double)cs2.getCollectedInstances() / (double)inst) * 10000.0);
                            }
                            return this._sortSequence * (cs1.getCollectedInstances() - cs2.getCollectedInstances());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 16);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 16);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getCollectedInstances() - PackageStatistic.this.cdelta2.getCollectedInstances());
                    }
                    case 4: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs2.getTotalSize());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 13);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta2.getTotalSize());
                    }
                    case 5: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getTotalSize() - cs2.getCollectedSize() - ((TRCClass)e2).getTotalSize() + ((TRCClass)e2).getCollectedSize());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 13);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 13);
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 15);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 15);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getTotalSize() - PackageStatistic.this.cdelta1.getCollectedSize() - (PackageStatistic.this.cdelta2.getTotalSize() - PackageStatistic.this.cdelta2.getCollectedSize()));
                    }
                    case 6: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getBaseTime() - cs2.getBaseTime();
                        } else {
                            c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 7);
                            c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 7);
                            d = PackageStatistic.this.cdelta1.getBaseTime() - PackageStatistic.this.cdelta2.getBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 7: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedBaseTime() - cs2.getInheritedBaseTime();
                        } else {
                            c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 11);
                            c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 11);
                            d = PackageStatistic.this.cdelta1.getInheritedBaseTime() - PackageStatistic.this.cdelta2.getInheritedBaseTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 8: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getCumulativeTime() - cs2.getCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 8);
                            c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 8);
                            d = PackageStatistic.this.cdelta1.getCumulativeTime() - PackageStatistic.this.cdelta2.getCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 9: {
                        if (!this._info.isDeltaColumn()) {
                            d = cs1.getInheritedCumulativeTime() - cs2.getInheritedCumulativeTime();
                        } else {
                            c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 12);
                            c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 12);
                            d = PackageStatistic.this.cdelta1.getInheritedCumulativeTime() - PackageStatistic.this.cdelta2.getInheritedCumulativeTime();
                        }
                        if (d < 0.0) {
                            return -1 * this._sortSequence;
                        }
                        if (d > 0.0) {
                            return this._sortSequence;
                        }
                        return 0;
                    }
                    case 10: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getCalls() - cs2.getCalls());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 9);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 9);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getCalls() - PackageStatistic.this.cdelta2.getCalls());
                    }
                    case 11: {
                        if (!this._info.isDeltaColumn()) {
                            return this._sortSequence * (cs1.getInheritedCalls() - cs2.getInheritedCalls());
                        }
                        c1.computeDelta((IDelta)PackageStatistic.this.cdelta1, 10);
                        c2.computeDelta((IDelta)PackageStatistic.this.cdelta2, 10);
                        return this._sortSequence * (PackageStatistic.this.cdelta1.getInheritedCalls() - PackageStatistic.this.cdelta2.getInheritedCalls());
                    }
                }
            }
            return 0;
        }
    }

    public class PackageStatisticFilter
    extends StatisticView.StatisticFilter {
        public PackageStatisticFilter() {
            super(PackageStatistic.this);
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean flag = true;
            if (!(element instanceof TRCPackage)) {
                return true;
            }
            String compareText = "";
            compareText = ((TRCPackage)element).getName();
            if (compareText.equals("")) {
                compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
            }
            if (this._noPattern) {
                return true;
            }
            if (!this._caseSensitive) {
                compareText = compareText.toLowerCase();
            }
            if (this._exactMatch) {
                return compareText.compareTo(this._prefix) == 0;
            }
            if (this._prefix != "") {
                flag = compareText.startsWith(this._prefix);
            }
            if (flag && this._suffix != "") {
                flag = compareText.endsWith(this._suffix);
            }
            if (flag) {
                for (int k = 0; k < this._textList.size(); ++k) {
                    String str1 = (String)this._textList.get(k);
                    int index = compareText.lastIndexOf(str1);
                    if (index == -1) {
                        flag = false;
                        break;
                    }
                    compareText = compareText.substring(index + str1.length());
                }
            }
            return flag;
        }
    }
}

